/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jump.qa.diff.BufferGeometryMatcher;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Geometry;

public abstract class GeometryPredicate {
    static GeometryPredicate[] method = new GeometryPredicate[]{new IntersectsPredicate(), new ContainsPredicate(), new CoversPredicate(), new CoveredByPredicate(), new CrossesPredicate(), new EqualsPredicate(), new OverlapsPredicate(), new TouchesPredicate(), new WithinPredicate(), new WithinDistancePredicate(), new SimilarPredicate(), new IntersectsInteriorPointPredicate(), new InteriorPointIntersectsPredicate()};
    private String name;
    private int nArguments;
    private int nParams;
    private String description;

    static List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (GeometryPredicate m : method) {
            names.add(m.name);
        }
        return names;
    }

    static GeometryPredicate getPredicate(String name) {
        for (GeometryPredicate m : method) {
            if (!m.name.equals(name)) continue;
            return m;
        }
        return null;
    }

    public GeometryPredicate(String name, int nParams) {
        this(name, 2, nParams, null);
    }

    public GeometryPredicate(String name) {
        this(name, 2, 0, null);
    }

    public GeometryPredicate(String name, int nArgs, int nParams) {
        this(name, nArgs, nParams, null);
    }

    public GeometryPredicate(String name, int nArgs, int nParams, String description) {
        this.name = name;
        this.nArguments = nArgs;
        this.nParams = nParams;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public int getGeometryArgumentCount() {
        return this.nArguments;
    }

    public int getParameterCount() {
        return this.nParams;
    }

    public abstract boolean isTrue(Geometry var1, Geometry var2, double[] var3);

    private static class InteriorPointIntersectsPredicate
    extends GeometryPredicate {
        public InteriorPointIntersectsPredicate() {
            super(GenericNames.INTERIOR_POINT_INTERSECTS);
        }

        @Override
        public boolean isTrue(Geometry geom0, Geometry geom1, double[] param) {
            return geom0.getInteriorPoint().intersects(geom1);
        }
    }

    private static class IntersectsInteriorPointPredicate
    extends GeometryPredicate {
        public IntersectsInteriorPointPredicate() {
            super(GenericNames.INTERSECTS_INTERIOR_POINT);
        }

        @Override
        public boolean isTrue(Geometry geom0, Geometry geom1, double[] param) {
            return geom0.intersects((Geometry)geom1.getInteriorPoint());
        }
    }

    public static class SimilarPredicate
    extends GeometryPredicate {
        public SimilarPredicate() {
            super(GenericNames.SIMILAR, 1);
        }

        @Override
        public boolean isTrue(Geometry geom0, Geometry geom1, double[] param) {
            return BufferGeometryMatcher.isMatch(geom0, geom1, param[0]);
        }
    }

    public static class WithinDistancePredicate
    extends GeometryPredicate {
        public WithinDistancePredicate() {
            super(GenericNames.WITHIN_DISTANCE, 1);
        }

        @Override
        public boolean isTrue(Geometry geom0, Geometry geom1, double[] param) {
            return geom0.isWithinDistance(geom1, param[0]);
        }
    }

    private static class WithinPredicate
    extends GeometryPredicate {
        public WithinPredicate() {
            super(GenericNames.WITHIN);
        }

        @Override
        public boolean isTrue(Geometry geom0, Geometry geom1, double[] param) {
            return geom0.within(geom1);
        }
    }

    private static class TouchesPredicate
    extends GeometryPredicate {
        public TouchesPredicate() {
            super(GenericNames.TOUCHES);
        }

        @Override
        public boolean isTrue(Geometry geom0, Geometry geom1, double[] param) {
            return geom0.touches(geom1);
        }
    }

    private static class OverlapsPredicate
    extends GeometryPredicate {
        public OverlapsPredicate() {
            super(GenericNames.OVERLAPS);
        }

        @Override
        public boolean isTrue(Geometry geom0, Geometry geom1, double[] param) {
            return geom0.overlaps(geom1);
        }
    }

    private static class EqualsPredicate
    extends GeometryPredicate {
        public EqualsPredicate() {
            super(GenericNames.EQUALS);
        }

        @Override
        public boolean isTrue(Geometry geom0, Geometry geom1, double[] param) {
            return geom0.equals(geom1);
        }
    }

    public static class DisjointPredicate
    extends GeometryPredicate {
        public DisjointPredicate() {
            super(GenericNames.DISJOINT);
        }

        @Override
        public boolean isTrue(Geometry geom0, Geometry geom1, double[] param) {
            return geom0.disjoint(geom1);
        }
    }

    private static class CrossesPredicate
    extends GeometryPredicate {
        public CrossesPredicate() {
            super(GenericNames.CROSSES);
        }

        @Override
        public boolean isTrue(Geometry geom0, Geometry geom1, double[] param) {
            return geom0.crosses(geom1);
        }
    }

    private static class CoveredByPredicate
    extends GeometryPredicate {
        public CoveredByPredicate() {
            super(GenericNames.COVEREDBY);
        }

        @Override
        public boolean isTrue(Geometry geom0, Geometry geom1, double[] param) {
            return geom0.coveredBy(geom1);
        }
    }

    private static class CoversPredicate
    extends GeometryPredicate {
        public CoversPredicate() {
            super(GenericNames.COVERS);
        }

        @Override
        public boolean isTrue(Geometry geom0, Geometry geom1, double[] param) {
            return geom0.covers(geom1);
        }
    }

    private static class ContainsPredicate
    extends GeometryPredicate {
        public ContainsPredicate() {
            super(GenericNames.CONTAINS);
        }

        @Override
        public boolean isTrue(Geometry geom0, Geometry geom1, double[] param) {
            return geom0.contains(geom1);
        }
    }

    private static class IntersectsPredicate
    extends GeometryPredicate {
        public IntersectsPredicate() {
            super(GenericNames.INTERSECTS);
        }

        @Override
        public boolean isTrue(Geometry geom0, Geometry geom1, double[] param) {
            return geom0.intersects(geom1);
        }
    }
}

