/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.plugin.util.LayerNameGenerator;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.analysis.GeometryFunction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.locationtech.jts.geom.Geometry;

public class GeometryFunctionPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    public static final String GEOMETRY_FUNCTION_REG_KEY = "Geometry Function Registry Key";
    private static String sErrorsFound = I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.errors-found-while-executing-function");
    private static String sFunction = I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.function");
    private static String sFeatures = I18N.getInstance().get("jump.features-processed");
    private static String SRC_LAYER = I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.Source");
    private static String MASK_LAYER = I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.Mask");
    private static String METHODS = sFunction;
    private static String PARAM = I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.Parameter");
    private static String SELECTED_ONLY = I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.Use-selected-features-only");
    private static String UPDATE_SRC = I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.Update-Source-features-with-result");
    private static String ADD_TO_SRC = I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.Add-result-to-Source-layer");
    private static String CREATE_LYR = I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.Create-new-layer-for-result");
    private Collection functions;
    private MultiInputDialog dialog;
    private Layer srcLayer;
    private Layer maskLayer;
    private GeometryFunction functionToRun = null;
    private boolean exceptionThrown = false;
    private boolean createLayer = false;
    private boolean updateSource = false;
    private boolean addToSource = false;
    private boolean useSelected = false;
    private Geometry[] geoms = new Geometry[2];
    private double[] params = new double[2];
    private String categoryName = StandardCategoryNames.RESULT;
    private boolean addToSourceAllowed = true;
    private boolean editSourceAllowed = false;
    private JComboBox layer2ComboBox;
    private JTextField paramField;

    public void setCategoryName(String value) {
        this.categoryName = value;
    }

    public void setAddToSourceAllowed(boolean value) {
        this.addToSourceAllowed = value;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_ANALYSIS}, this.getName() + "...", false, null, GeometryFunctionPlugIn.createEnableCheck(context.getWorkbenchContext()));
        this.registerFunctions(context);
    }

    private void registerFunctions(PlugInContext context) {
        GeometryFunction[] functions = GeometryFunction.getFunctions();
        context.getWorkbenchContext().getRegistry().createClassification(GEOMETRY_FUNCTION_REG_KEY, GeometryFunction.class);
        for (GeometryFunction function : functions) {
            context.getWorkbenchContext().getRegistry().createEntry(GEOMETRY_FUNCTION_REG_KEY, function);
        }
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.functions = context.getWorkbenchContext().getRegistry().getEntries(GEOMETRY_FUNCTION_REG_KEY);
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow(this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        Collection<Feature> resultFeatures;
        monitor.allowCancellationRequests();
        if (this.functionToRun == null) {
            return;
        }
        if (this.srcLayer == null) {
            return;
        }
        if ((this.updateSource || this.addToSource) && !this.srcLayer.isEditable()) {
            context.getWorkbenchFrame().warnUser(this.srcLayer.getName() + " " + I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.is-not-editable"));
            return;
        }
        monitor.report(I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.Executing-function") + " " + this.functionToRun.getName() + "...");
        int nArgs = this.functionToRun.getGeometryArgumentCount();
        Collection<Feature> fc1 = this.getFeaturesToProcess(this.srcLayer, context);
        EditTransaction transaction = new EditTransaction(new LinkedHashSet<Feature>(), "Geometry function", this.srcLayer, true, true, context.getLayerViewPanel().getContext());
        if (nArgs == 2) {
            if (this.maskLayer == null) {
                return;
            }
            Collection<Feature> fc2 = this.getFeaturesToProcess(this.maskLayer, context);
            if (fc2.size() != 1) {
                context.getWorkbenchFrame().warnUser(I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.Mask-must-contain-exactly-one-geometry"));
                return;
            }
            Geometry geomMask = fc2.iterator().next().getGeometry();
            resultFeatures = this.runGeometryMethodWithMask(monitor, fc1, geomMask, this.functionToRun, transaction);
        } else {
            resultFeatures = this.runGeometryMethod(monitor, fc1, this.functionToRun, transaction);
        }
        if (resultFeatures == null) {
            return;
        }
        if (this.createLayer && resultFeatures.size() == 0 || this.updateSource && transaction.getFeatures().size() == 0 || this.addToSource && transaction.getFeatures().size() == 0) {
            context.getWorkbenchFrame().warnUser(I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.No-geometries-were-processed"));
            return;
        }
        if (this.createLayer) {
            String outputLayerName = LayerNameGenerator.generateOperationOnLayerName(this.functionToRun.toString(), this.srcLayer.getName());
            FeatureDataset resultFC = new FeatureDataset(this.srcLayer.getFeatureCollectionWrapper().getFeatureSchema());
            resultFC.addAll(resultFeatures);
            context.getLayerManager().addCategory(this.categoryName);
            context.addLayer(this.categoryName, outputLayerName, resultFC);
        } else if (this.updateSource) {
            transaction.commit();
        } else if (this.addToSource) {
            transaction.commit();
        }
        if (this.exceptionThrown) {
            context.getWorkbenchFrame().warnUser(sErrorsFound);
        }
    }

    private Collection<Feature> getSelectedFeatures(Layer lyr, PlugInContext context) {
        return context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(lyr);
    }

    private Collection<Feature> getFeaturesToProcess(Layer lyr, PlugInContext context) {
        if (this.useSelected && lyr.equals(this.srcLayer)) {
            return context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(lyr);
        }
        return lyr.getFeatureCollectionWrapper().getFeatures();
    }

    private Collection<Feature> runGeometryMethodWithMask(TaskMonitor monitor, Collection<Feature> fcA, Geometry geomB, GeometryFunction func, EditTransaction transaction) {
        this.exceptionThrown = false;
        ArrayList<Feature> resultColl = new ArrayList<Feature>();
        int total = fcA.size();
        int count = 0;
        for (Feature fa : fcA) {
            Geometry ga;
            monitor.report(count++, total, sFeatures);
            if (monitor.isCancelRequested()) {
                return null;
            }
            this.geoms[0] = ga = fa.getGeometry();
            this.geoms[1] = geomB;
            Geometry result = this.execute(func, this.geoms, this.params);
            this.saveResult(fa, result, resultColl, transaction);
        }
        return resultColl;
    }

    private Collection<Feature> runGeometryMethod(TaskMonitor monitor, Collection<Feature> fc, GeometryFunction func, EditTransaction transaction) {
        this.exceptionThrown = false;
        ArrayList<Feature> resultColl = new ArrayList<Feature>();
        int total = fc.size();
        int count = 0;
        for (Feature fSrc : fc) {
            monitor.report(count++, total, sFeatures);
            if (monitor.isCancelRequested()) {
                return null;
            }
            Geometry gSrc = fSrc.getGeometry();
            if (gSrc == null) continue;
            this.geoms[0] = gSrc;
            Geometry result = this.execute(func, this.geoms, this.params);
            this.saveResult(fSrc, result, resultColl, transaction);
        }
        return resultColl;
    }

    private void saveResult(Feature srcFeat, Geometry resultGeom, Collection<Feature> resultColl, EditTransaction transaction) {
        if (this.createLayer || this.addToSource) {
            Feature fNew = srcFeat.clone(false, false);
            fNew.setGeometry(resultGeom);
            if (resultGeom != null && !resultGeom.isEmpty()) {
                if (this.createLayer) {
                    resultColl.add(fNew);
                } else if (this.addToSource) {
                    transaction.createFeature(fNew);
                }
            }
        } else if (this.updateSource) {
            transaction.modifyFeatureGeometry(srcFeat, resultGeom);
        }
    }

    private Geometry execute(GeometryFunction func, Geometry[] geoms, double[] params) {
        try {
            return func.execute(geoms, params);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            this.exceptionThrown = true;
            return null;
        }
    }

    private void setDialogValues(final MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.Computes-a-geometric-function-on-features-in-the-Source-layer") + "  " + I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.Geometry-can-be-saved-to-a-new-layer,-updated-in-place,-or-added-to-the-Source-layer") + "  " + I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.Binary-geometric-functions-take-a-mask-feature-as-their-second-operand"));
        this.srcLayer = context.getCandidateLayer(0);
        this.editSourceAllowed = this.srcLayer.isEditable();
        JComboBox<Layer> srcLayerComboBox = dialog.addLayerComboBox(SRC_LAYER, this.srcLayer, I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.The-Source-layer-features-provide-the-first-operand-for-the-chosen-function"), context.getLayerManager());
        srcLayerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeometryFunctionPlugIn.this.srcLayer = dialog.getLayer(SRC_LAYER);
                GeometryFunctionPlugIn.this.editSourceAllowed = GeometryFunctionPlugIn.this.srcLayer.isEditable();
            }
        });
        JComboBox<GeometryFunction> functionComboBox = dialog.addComboBox(METHODS, this.functionToRun, this.functions, null);
        functionComboBox.addItemListener(new MethodItemListener());
        this.paramField = dialog.addDoubleField(PARAM, this.params[0], 10);
        if (this.maskLayer == null) {
            this.maskLayer = context.getLayerManager().size() > 1 ? context.getCandidateLayer(1) : this.srcLayer;
        }
        this.layer2ComboBox = dialog.addLayerComboBox(MASK_LAYER, this.maskLayer, I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.The-Mask-layer-must-contain-a-single-feature,-which-is-used-as-the-second-operand-for-binary-functions"), context.getLayerManager());
        JCheckBox useSelectedCheckBox = dialog.addCheckBox(SELECTED_ONLY, this.useSelected);
        boolean selectionEmpty = this.getSelectedFeatures((Layer)srcLayerComboBox.getSelectedItem(), context).isEmpty();
        useSelectedCheckBox.setSelected(this.useSelected && !selectionEmpty);
        useSelectedCheckBox.setEnabled(!selectionEmpty);
        String OUTPUT_GROUP = I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.Match-Type");
        JRadioButton createNewLayerRB = dialog.addRadioButton(CREATE_LYR, OUTPUT_GROUP, true, I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.Create-a-new-layer-for-the-results"));
        JRadioButton updateSourceRB = dialog.addRadioButton(UPDATE_SRC, OUTPUT_GROUP, false, I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.Replace-the-geometry-of-Source-features-with-the-result-geometry") + "  ");
        updateSourceRB.setEnabled(this.editSourceAllowed);
        JRadioButton addToSourceRB = dialog.addRadioButton(ADD_TO_SRC, OUTPUT_GROUP, false, I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.Add-the-result-geometry-to-the-Source-layer") + "  ");
        addToSourceRB.setEnabled(this.addToSourceAllowed && this.editSourceAllowed);
        this.updateUIForMethod(this.functionToRun);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.srcLayer = dialog.getLayer(SRC_LAYER);
        this.maskLayer = dialog.getLayer(MASK_LAYER);
        this.functionToRun = (GeometryFunction)dialog.getComboBox(METHODS).getSelectedItem();
        this.params[0] = dialog.getDouble(PARAM);
        this.useSelected = dialog.getBoolean(SELECTED_ONLY);
        this.createLayer = dialog.getBoolean(CREATE_LYR);
        this.updateSource = dialog.getBoolean(UPDATE_SRC);
        if (this.addToSourceAllowed) {
            this.addToSource = dialog.getBoolean(ADD_TO_SRC);
        }
    }

    private void updateUIForMethod(GeometryFunction func) {
        boolean layer2Used = false;
        boolean paramUsed = false;
        if (func != null) {
            layer2Used = func.getGeometryArgumentCount() > 1;
            paramUsed = func.getParameterCount() > 0;
        }
        this.layer2ComboBox.setEnabled(layer2Used);
        this.paramField.setEnabled(paramUsed);
        this.paramField.setOpaque(paramUsed);
        this.dialog.validate();
    }

    private class MethodItemListener
    implements ItemListener {
        private MethodItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            GeometryFunctionPlugIn.this.updateUIForMethod((GeometryFunction)e.getItem());
        }
    }
}

