/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.FlexibleDateParser;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public abstract class AttributePredicate {
    static AttributePredicate[] methods = new AttributePredicate[]{new EqualPredicate(), new NotEqualPredicate(), new LessThanPredicate(), new LessThanOrEqualPredicate(), new GreaterThanPredicate(), new GreaterThanOrEqualPredicate(), new ContainsPredicate(), new StartsWithPredicate(), new EndsWithPredicate(), new MatchesPredicate()};
    static AttributePredicate[] methodsCaseInsensitive = new AttributePredicate[]{new EqualCIPredicate(), new NotEqualCIPredicate(), new LessThanCIPredicate(), new LessThanOrEqualCIPredicate(), new GreaterThanCIPredicate(), new GreaterThanOrEqualCIPredicate(), new ContainsCIPredicate(), new StartsWithCIPredicate(), new EndsWithCIPredicate(), new MatchesCIPredicate()};
    private static FlexibleDateParser dateParser = new FlexibleDateParser();
    private String name;
    private String description;
    protected static final int NOT_COMPARABLE = Integer.MIN_VALUE;

    static List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (AttributePredicate method : methods) {
            names.add(method.name);
        }
        return names;
    }

    static List<String> getNamesCI() {
        ArrayList<String> names = new ArrayList<String>();
        for (AttributePredicate attributePredicate : methodsCaseInsensitive) {
            names.add(attributePredicate.name);
        }
        return names;
    }

    static AttributePredicate getPredicate(String name) {
        for (AttributePredicate method : methods) {
            if (!method.name.equals(name)) continue;
            return method;
        }
        return null;
    }

    static AttributePredicate getPredicate(String name, boolean caseInsensitive) {
        AttributePredicate pred = null;
        if (caseInsensitive) {
            for (AttributePredicate attributePredicate : methodsCaseInsensitive) {
                if (!attributePredicate.name.equals(name)) continue;
                pred = attributePredicate;
            }
        }
        if (pred == null) {
            pred = AttributePredicate.getPredicate(name);
        }
        return pred;
    }

    public AttributePredicate(String name) {
        this(name, null);
    }

    public AttributePredicate(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean isTrue(Object var1, Object var2);

    protected boolean compareObjects(Object arg1, Object arg2) {
        Object o2 = AttributePredicate.coerce((String)arg2, arg1);
        if (o2 == null) {
            return false;
        }
        int comp = AttributePredicate.compareTo(arg1, o2);
        if (comp == Integer.MIN_VALUE) {
            return false;
        }
        return this.testCompareValue(comp);
    }

    protected boolean testCompareValue(int comp) {
        return false;
    }

    public static Object coerce(String constantValue, Object attrVal) {
        try {
            if (attrVal instanceof Boolean) {
                return AttributePredicate.getBooleanLoose(constantValue);
            }
            if (attrVal instanceof Double) {
                return Double.valueOf(constantValue);
            }
            if (attrVal instanceof Integer) {
                return Integer.valueOf(constantValue);
            }
            if (attrVal instanceof Long) {
                return Long.valueOf(constantValue);
            }
            if (attrVal instanceof String) {
                return constantValue;
            }
            if (attrVal instanceof Date) {
                return dateParser.parse(constantValue, true);
            }
        }
        catch (NumberFormatException | ParseException exception) {
            // empty catch block
        }
        return null;
    }

    protected static int compareTo(Object o1, Object o2) {
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            return ((Boolean)o1).equals(o2) ? 0 : 1;
        }
        if (!(o1 instanceof Comparable)) {
            return Integer.MIN_VALUE;
        }
        if (!(o2 instanceof Comparable)) {
            return Integer.MIN_VALUE;
        }
        return ((Comparable)o1).compareTo(o2);
    }

    private static boolean getBooleanLoose(String boolStr) {
        return boolStr.equalsIgnoreCase("true") || boolStr.equalsIgnoreCase("yes") || boolStr.equalsIgnoreCase("1") || boolStr.equalsIgnoreCase("y");
    }

    private static class MatchesCIPredicate
    extends MatchesPredicate {
        private MatchesCIPredicate() {
        }

        @Override
        public boolean isTrue(Object arg1, Object arg2) {
            if (arg1 == null || arg2 == null) {
                return false;
            }
            return Pattern.compile(arg2.toString(), 2).matcher(arg1.toString()).matches();
        }
    }

    private static class MatchesPredicate
    extends AttributePredicate {
        public MatchesPredicate() {
            super(I18N.getInstance().get("ui.plugin.analysis.AttributePredicate.matches"));
        }

        @Override
        public boolean isTrue(Object arg1, Object arg2) {
            if (arg1 == null || arg2 == null) {
                return false;
            }
            return Pattern.compile(arg2.toString()).matcher(arg1.toString()).matches();
        }
    }

    private static class EndsWithCIPredicate
    extends EndsWithPredicate {
        private EndsWithCIPredicate() {
        }

        @Override
        public boolean isTrue(Object arg1, Object arg2) {
            if (arg1 == null || arg2 == null) {
                return false;
            }
            return arg1.toString().toLowerCase().endsWith(arg2.toString().toLowerCase());
        }
    }

    private static class EndsWithPredicate
    extends AttributePredicate {
        public EndsWithPredicate() {
            super(I18N.getInstance().get("ui.plugin.analysis.AttributePredicate.ends-with"));
        }

        @Override
        public boolean isTrue(Object arg1, Object arg2) {
            if (arg1 == null || arg2 == null) {
                return false;
            }
            return arg1.toString().endsWith(arg2.toString());
        }
    }

    private static class StartsWithCIPredicate
    extends StartsWithPredicate {
        private StartsWithCIPredicate() {
        }

        @Override
        public boolean isTrue(Object arg1, Object arg2) {
            if (arg1 == null || arg2 == null) {
                return false;
            }
            return arg1.toString().toLowerCase().startsWith(arg2.toString().toLowerCase());
        }
    }

    private static class StartsWithPredicate
    extends AttributePredicate {
        public StartsWithPredicate() {
            super(I18N.getInstance().get("ui.plugin.analysis.AttributePredicate.starts-with"));
        }

        @Override
        public boolean isTrue(Object arg1, Object arg2) {
            if (arg1 == null || arg2 == null) {
                return false;
            }
            return arg1.toString().startsWith(arg2.toString());
        }
    }

    private static class ContainsCIPredicate
    extends ContainsPredicate {
        private ContainsCIPredicate() {
        }

        @Override
        public boolean isTrue(Object arg1, Object arg2) {
            if (arg1 == null || arg2 == null) {
                return false;
            }
            return arg1.toString().toLowerCase().indexOf(arg2.toString().toLowerCase()) >= 0;
        }
    }

    private static class ContainsPredicate
    extends AttributePredicate {
        public ContainsPredicate() {
            super(GenericNames.CONTAINS);
        }

        @Override
        public boolean isTrue(Object arg1, Object arg2) {
            if (arg1 == null || arg2 == null) {
                return false;
            }
            return arg1.toString().indexOf(arg2.toString()) >= 0;
        }
    }

    private static class GreaterThanOrEqualCIPredicate
    extends GreaterThanOrEqualPredicate {
        private GreaterThanOrEqualCIPredicate() {
        }

        @Override
        public boolean isTrue(Object arg1, Object arg2) {
            if (arg1 instanceof String) {
                arg1 = arg1.toString().toLowerCase();
                arg2 = arg2.toString().toLowerCase();
            }
            return super.compareObjects(arg1, arg2);
        }
    }

    private static class GreaterThanOrEqualPredicate
    extends AttributePredicate {
        public GreaterThanOrEqualPredicate() {
            super(">=");
        }

        @Override
        public boolean isTrue(Object arg1, Object arg2) {
            return this.compareObjects(arg1, arg2);
        }

        @Override
        protected boolean testCompareValue(int comp) {
            return comp >= 0;
        }
    }

    private static class GreaterThanCIPredicate
    extends GreaterThanPredicate {
        private GreaterThanCIPredicate() {
        }

        @Override
        public boolean isTrue(Object arg1, Object arg2) {
            if (arg1 instanceof String) {
                arg1 = arg1.toString().toLowerCase();
                arg2 = arg2.toString().toLowerCase();
            }
            return super.compareObjects(arg1, arg2);
        }
    }

    private static class GreaterThanPredicate
    extends AttributePredicate {
        public GreaterThanPredicate() {
            super(">");
        }

        @Override
        public boolean isTrue(Object arg1, Object arg2) {
            return this.compareObjects(arg1, arg2);
        }

        @Override
        protected boolean testCompareValue(int comp) {
            return comp > 0;
        }
    }

    private static class LessThanOrEqualCIPredicate
    extends LessThanOrEqualPredicate {
        private LessThanOrEqualCIPredicate() {
        }

        @Override
        public boolean isTrue(Object arg1, Object arg2) {
            if (arg1 instanceof String) {
                arg1 = arg1.toString().toLowerCase();
                arg2 = arg2.toString().toLowerCase();
            }
            return super.compareObjects(arg1, arg2);
        }
    }

    private static class LessThanOrEqualPredicate
    extends AttributePredicate {
        public LessThanOrEqualPredicate() {
            super("<=");
        }

        @Override
        public boolean isTrue(Object arg1, Object arg2) {
            return this.compareObjects(arg1, arg2);
        }

        @Override
        protected boolean testCompareValue(int comp) {
            return comp <= 0;
        }
    }

    private static class LessThanCIPredicate
    extends LessThanPredicate {
        private LessThanCIPredicate() {
        }

        @Override
        public boolean isTrue(Object arg1, Object arg2) {
            if (arg1 instanceof String) {
                arg1 = arg1.toString().toLowerCase();
                arg2 = arg2.toString().toLowerCase();
            }
            return super.compareObjects(arg1, arg2);
        }
    }

    private static class LessThanPredicate
    extends AttributePredicate {
        public LessThanPredicate() {
            super("<");
        }

        @Override
        public boolean isTrue(Object arg1, Object arg2) {
            return this.compareObjects(arg1, arg2);
        }

        @Override
        protected boolean testCompareValue(int comp) {
            return comp < 0;
        }
    }

    private static class NotEqualCIPredicate
    extends NotEqualPredicate {
        private NotEqualCIPredicate() {
        }

        @Override
        public boolean isTrue(Object arg1, Object arg2) {
            if (arg1 instanceof String) {
                arg1 = arg1.toString().toLowerCase();
                arg2 = arg2.toString().toLowerCase();
            }
            return super.compareObjects(arg1, arg2);
        }
    }

    private static class NotEqualPredicate
    extends AttributePredicate {
        public NotEqualPredicate() {
            super("<>");
        }

        @Override
        public boolean isTrue(Object arg1, Object arg2) {
            return this.compareObjects(arg1, arg2);
        }

        @Override
        protected boolean testCompareValue(int comp) {
            return comp != 0;
        }
    }

    private static class EqualCIPredicate
    extends EqualPredicate {
        private EqualCIPredicate() {
        }

        @Override
        public boolean isTrue(Object arg1, Object arg2) {
            if (arg1 instanceof String) {
                arg1 = arg1.toString().toLowerCase();
                arg2 = arg2.toString().toLowerCase();
            }
            return super.compareObjects(arg1, arg2);
        }
    }

    private static class EqualPredicate
    extends AttributePredicate {
        public EqualPredicate() {
            super("=");
        }

        @Override
        public boolean isTrue(Object arg1, Object arg2) {
            return this.compareObjects(arg1, arg2);
        }

        @Override
        protected boolean testCompareValue(int comp) {
            return comp == 0;
        }
    }
}

