/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.undo.UndoManager;

public class UndoPlugIn
extends AbstractPlugIn {
    private ImageIcon icon = IconLoader.icon("Undo.gif");

    public UndoPlugIn() {
        this.setShortcutKeys(90);
        this.setShortcutModifiers(2);
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        ((LayerManagerProxy)((Object)context.getWorkbenchContext().getWorkbench().getFrame().getActiveInternalFrame())).getLayerManager().getUndoableEditReceiver().getUndoManager().undo();
        this.reportNothingToUndoYet(context);
        context.getWorkbenchFrame().getToolBar().updateEnabledState();
        return true;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        return new MultiEnableCheck().add(EnableCheckFactory.getInstance(workbenchContext).createWindowWithLayerManagerMustBeActiveCheck()).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                UndoManager undoManager = ((LayerManagerProxy)((Object)JUMPWorkbench.getInstance().getFrame().getActiveInternalFrame())).getLayerManager().getUndoableEditReceiver().getUndoManager();
                if (component != null) {
                    component.setToolTipText(undoManager.getUndoPresentationName());
                }
                return !undoManager.canUndo() ? I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.plugin.UndoPlugIn.nothing-to-undo") : null;
            }
        });
    }

    @Override
    public ImageIcon getIcon() {
        return this.icon;
    }
}

