/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.Animations;
import com.vividsolutions.jump.workbench.ui.plugin.VerticesInFencePlugIn;
import java.awt.Color;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;

public class SnapVerticesOp {
    public static final String INSERT_VERTICES_IF_NECESSARY_KEY = SnapVerticesOp.class.getName() + " - INSERT_VERTICES_IF_NECESSARY";
    private static final String NO_TARGET_VERTICES_IN_FENCE_WARNING = I18N.getInstance().get("ui.cursortool.editing.SnapVerticesOp.fence-contains-no-vertices-of-the-selected-feature-part-or-linestring");
    private final GeometryEditor geometryEditor = new GeometryEditor();

    private Collection<Feature> featuresInFence(Layer layer, Geometry fence, LayerViewPanel panel) {
        Collection featuresInFence = panel.visibleLayerToFeaturesInFenceMap(fence).get(layer);
        if (featuresInFence == null) {
            return new ArrayList<Feature>();
        }
        return featuresInFence;
    }

    public Coordinate pickTarget(Geometry targetGeometry, Geometry fence, Coordinate suggestedTarget) {
        List<Coordinate> verticesInFence = VerticesInFencePlugIn.verticesInFence(targetGeometry, fence, true).getCoordinates();
        if (verticesInFence.isEmpty()) {
            return null;
        }
        return CoordUtil.closest(verticesInFence, suggestedTarget);
    }

    public boolean execute(Geometry fence, Collection<Layer> editableLayers, boolean rollingBackInvalidEdits, final LayerViewPanel panel, Task task, Coordinate suggestedTarget, Feature targetFeature, boolean insertVerticesIfNecessary) throws Exception {
        Map<Layer, Collection<Feature>> editableLayerToFeaturesInFenceMap = this.editableLayerToFeaturesInFenceMap(editableLayers, fence, panel);
        Collection<Feature> editableFeatures = CollectionUtil.concatenate(editableLayerToFeaturesInFenceMap.values());
        if (editableFeatures.isEmpty()) {
            panel.getContext().warnUser(I18N.getInstance().get("ui.cursortool.editing.SnapVerticesOp.fence-contains-no-features-from-editable-layers"));
            return false;
        }
        if (VerticesInFencePlugIn.verticesInFence(targetFeature.getGeometry(), fence, true).getCoordinates().isEmpty() && VerticesInFencePlugIn.verticesInFence(FeatureUtil.toGeometries(editableFeatures), fence, true).isEmpty()) {
            panel.getContext().warnUser(NO_TARGET_VERTICES_IN_FENCE_WARNING);
            return false;
        }
        Geometry targetGeometry = targetFeature.getGeometry();
        ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
        for (Layer editableLayer : editableLayers) {
            Collection<Feature> featuresInFence = editableLayerToFeaturesInFenceMap.get(editableLayer);
            EditTransaction transaction = new EditTransaction(featuresInFence, I18N.getInstance().get("ui.cursortool.editing.SnapVerticesOp.snap-vertices-together"), editableLayer, rollingBackInvalidEdits, false, panel);
            transactions.add(transaction);
            if (!insertVerticesIfNecessary) continue;
            this.insertVerticesIfNecessary(transaction, suggestedTarget, fence);
            if (!featuresInFence.contains(targetFeature)) continue;
            targetGeometry = transaction.getGeometry(targetFeature);
        }
        final Coordinate target = this.pickTarget(targetGeometry, fence, suggestedTarget);
        if (target == null) {
            panel.getContext().warnUser(NO_TARGET_VERTICES_IN_FENCE_WARNING);
            return false;
        }
        boolean geometryChanged = this.moveVertices(transactions, fence, target);
        if (!geometryChanged) {
            return true;
        }
        return EditTransaction.commit(transactions, new EditTransaction.SuccessAction(){

            @Override
            public void run() {
                try {
                    SnapVerticesOp.this.indicateSuccess(target, panel);
                }
                catch (Throwable t) {
                    panel.getContext().warnUser(t.toString());
                }
            }
        });
    }

    private boolean moveVertices(List<EditTransaction> transactions, Geometry fence, Coordinate target) {
        boolean geometryChanged = false;
        for (EditTransaction transaction : transactions) {
            for (Feature feature : transaction.getFeatures()) {
                Geometry proposedGeometry = transaction.getGeometry(feature);
                this.move(VerticesInFencePlugIn.verticesInFence(proposedGeometry, fence, false).getCoordinates(), target);
                try {
                    proposedGeometry = this.geometryEditor.removeRepeatedPoints(proposedGeometry);
                }
                catch (IllegalArgumentException e) {
                    Assert.isTrue((e.getMessage().toLowerCase().contains("point") && e.getMessage().toLowerCase().contains(">") ? 1 : 0) != 0, (String)"I assumed that we would get here only if too few points were passed into the Geometry constructor [Jon Aquino]");
                    proposedGeometry = new GeometryFactory(proposedGeometry.getPrecisionModel(), proposedGeometry.getSRID()).createPoint(target);
                }
                transaction.setGeometry(feature, proposedGeometry);
            }
            geometryChanged = geometryChanged || !this.coordinatesEqual(transaction, fence);
        }
        return geometryChanged;
    }

    private Map<Layer, Collection<Feature>> editableLayerToFeaturesInFenceMap(Collection<Layer> editableLayers, Geometry fence, LayerViewPanel panel) {
        HashMap<Layer, Collection<Feature>> editableLayerToFeaturesInFenceMap = new HashMap<Layer, Collection<Feature>>();
        for (Layer editableLayer : editableLayers) {
            Assert.isTrue((boolean)editableLayer.isEditable());
            editableLayerToFeaturesInFenceMap.put(editableLayer, this.featuresInFence(editableLayer, fence, panel));
        }
        return editableLayerToFeaturesInFenceMap;
    }

    private boolean coordinatesEqual(EditTransaction transaction, Geometry fence) {
        for (Feature originalFeature : transaction.getFeatures()) {
            Geometry newGeometry = transaction.getGeometry(originalFeature);
            if (this.coordinatesEqual(VerticesInFencePlugIn.verticesInFence(originalFeature.getGeometry(), fence, true).getCoordinates(), VerticesInFencePlugIn.verticesInFence(newGeometry, fence, true).getCoordinates())) continue;
            return false;
        }
        return true;
    }

    private boolean coordinatesEqual(List<Coordinate> a, List<Coordinate> b) {
        if (a.size() != b.size()) {
            return false;
        }
        TreeSet<Coordinate> A = new TreeSet<Coordinate>(a);
        TreeSet<Coordinate> B = new TreeSet<Coordinate>(b);
        if (A.size() != B.size()) {
            return false;
        }
        Iterator<Coordinate> Ai = A.iterator();
        Iterator<Coordinate> Bi = B.iterator();
        while (Ai.hasNext()) {
            if (Ai.next().equals((Object)Bi.next())) continue;
            return false;
        }
        return true;
    }

    private void indicateSuccess(Coordinate target, LayerViewPanel panel) throws NoninvertibleTransformException {
        Point2D center = panel.getViewport().toViewPoint(CoordUtil.toPoint2D(target));
        Animations.drawExpandingRing(center, false, Color.green, panel, null);
    }

    private void move(Collection<Coordinate> verticesToMove, Coordinate target) {
        for (Coordinate vertexToMove : verticesToMove) {
            vertexToMove.setCoordinate(target);
        }
    }

    private int insertVerticesIfNecessary(EditTransaction transaction, final Coordinate target, final Geometry fence) {
        final int[] verticesInserted = new int[]{0};
        for (Feature feature : transaction.getFeatures()) {
            transaction.setGeometry(feature, this.geometryEditor.edit(transaction.getGeometry(feature), new GeometryEditor.GeometryEditorOperation(){

                @Override
                public Geometry edit(Geometry geometry) {
                    if (geometry instanceof Polygon) {
                        return geometry;
                    }
                    if (geometry instanceof GeometryCollection) {
                        return geometry;
                    }
                    if (!fence.intersects(geometry)) {
                        return geometry;
                    }
                    if (!VerticesInFencePlugIn.verticesInFence(geometry, fence, true).getCoordinates().isEmpty()) {
                        return geometry;
                    }
                    verticesInserted[0] = verticesInserted[0] + 1;
                    Geometry newGeometry = SnapVerticesOp.this.geometryEditor.insertVertex(geometry, target, fence);
                    Assert.isTrue((newGeometry != null ? 1 : 0) != 0);
                    return newGeometry;
                }
            }));
        }
        return verticesInserted[0];
    }
}

