/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.Configuration;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.DelegatingTool;
import com.vividsolutions.jump.workbench.ui.cursortool.FeatureInfoTool;
import com.vividsolutions.jump.workbench.ui.cursortool.LeftClickFilter;
import com.vividsolutions.jump.workbench.ui.cursortool.SelectFeaturesTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.DeleteVertexTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.InsertVertexTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.MoveSelectedItemsTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.MoveVertexTool;
import com.vividsolutions.jump.workbench.ui.zoom.PanTool;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomTool;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import org.openjump.core.CheckOS;
import org.openjump.core.ui.plugin.edittoolbox.cursortools.RotateSelectedItemTool;

public class QuasimodeTool
extends DelegatingTool {
    private final HashMap<ModifierKeySpec, CursorTool> keySpecToToolMap;
    private boolean useDefaults = false;
    private static final HashMap<ModifierKeySpec, CursorTool> defaultToolsMap = new LinkedHashMap<ModifierKeySpec, CursorTool>();
    private final Map<Integer, Integer> keyTimeMap = new HashMap<Integer, Integer>();
    private final KeyListener keyListener = new KeyListener(){
        private Set<Integer> previous = null;

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            QuasimodeTool.this.keyTimeMap.put(e.getKeyCode(), 0);
            this.keyStateChanged(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            QuasimodeTool.this.keyTimeMap.remove(e.getKeyCode());
            this.keyStateChanged(e);
        }

        private void keyStateChanged(KeyEvent e) {
            Set keys = QuasimodeTool.this.keyTimeMap.keySet();
            if (this.previous != null && this.previous.equals(keys)) {
                return;
            }
            this.previous = new HashSet(keys);
            QuasimodeTool.this.setTool(keys);
        }
    };
    private LayerViewPanel panel;

    public QuasimodeTool(CursorTool defaultTool) {
        this(defaultTool, null);
    }

    private QuasimodeTool(CursorTool defaultTool, HashMap<ModifierKeySpec, CursorTool> keyMap) {
        super(defaultTool);
        this.keySpecToToolMap = keyMap != null ? new HashMap<ModifierKeySpec, CursorTool>(keyMap) : new HashMap();
        this.setDefaultTool(defaultTool);
    }

    public CursorTool getDefaultTool() {
        return this.keySpecToToolMap.get(ModifierKeySpec.DEFAULT);
    }

    public QuasimodeTool add(ModifierKeySpec keySpec, CursorTool tool) {
        if (tool != null && keySpec != null) {
            this.keySpecToToolMap.put(keySpec, tool.isRightMouseButtonUsed() ? tool : new LeftClickFilter(tool));
        }
        return this;
    }

    public QuasimodeTool remove(ModifierKeySpec keySpec) {
        this.keySpecToToolMap.remove(keySpec);
        return this;
    }

    private void setDefaultTool(CursorTool tool) {
        this.add(ModifierKeySpec.DEFAULT, tool);
    }

    public QuasimodeTool cloneAndSetDefaultTool(CursorTool defaultTool) {
        return new QuasimodeTool(defaultTool, this.keySpecToToolMap);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (ModifierKeySpec keys : this.keySpecToToolMap.keySet()) {
            buf.append(keys + "=" + this.keySpecToToolMap.get(keys) + "\n");
        }
        if (this.useDefaults) {
            for (ModifierKeySpec keys : defaultToolsMap.keySet()) {
                buf.append(keys + "=" + defaultToolsMap.get(keys) + "\n");
            }
        }
        return this.getDefaultTool().getName() + "\n" + buf;
    }

    @Override
    public void cancelGesture() {
        for (CursorTool ct : this.keySpecToToolMap.values()) {
            ct.cancelGesture();
        }
        if (this.useDefaults) {
            for (CursorTool ct : defaultToolsMap.values()) {
                ct.cancelGesture();
            }
        }
    }

    private CursorTool getTool(Collection<Integer> keys) {
        ModifierKeySet ks = new ModifierKeySet(keys);
        CursorTool tool = this.keySpecToToolMap.get(ks);
        if (this.useDefaults && tool == null) {
            tool = defaultToolsMap.get(ks);
        }
        return tool;
    }

    public KeyListener getKeyListener() {
        return this.keyListener;
    }

    private void revalidateQuasiMode() {
        this.keyTimeMap.clear();
        this.setTool(this.keyTimeMap.keySet());
    }

    private void setTool(Set<Integer> keys) {
        CursorTool tool = this.getTool(keys);
        if (tool == null) {
            tool = this.getDefaultTool();
        }
        if (tool.equals(this.getDelegate())) {
            return;
        }
        super.deactivate();
        this.setDelegate(tool);
        super.activate(this.panel);
        this.panel.setCursor(this.getCursor());
        this.panel.setCurrentCursorTool(this);
    }

    @Override
    public void activate(LayerViewPanel panel) {
        if (panel == null) {
            return;
        }
        this.panel = panel;
        this.revalidateQuasiMode();
        super.activate(panel);
        panel.getWorkBenchFrame().addEasyKeyListener(this.keyListener);
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.panel != null) {
            this.panel.getWorkBenchFrame().removeEasyKeyListener(this.keyListener);
            this.panel = null;
        }
    }

    public static QuasimodeTool createWithDefaults(CursorTool tool) {
        QuasimodeTool quasimodeTool = tool instanceof QuasimodeTool ? (QuasimodeTool)tool : new QuasimodeTool(tool);
        quasimodeTool.useDefaults(true);
        return quasimodeTool;
    }

    private static CursorTool addDefaultTool(ModifierKeySpec key, CursorTool tool) {
        tool = tool.isRightMouseButtonUsed() || tool instanceof LeftClickFilter ? tool : new LeftClickFilter(tool);
        defaultToolsMap.put(key, tool);
        return tool;
    }

    public void useDefaults(boolean onoff) {
        this.useDefaults = onoff;
    }

    public static CursorTool getDefaultKeyboardShortcutTool(ModifierKeySpec key) {
        return defaultToolsMap.get(key);
    }

    public static Set<ModifierKeySpec> getDefaultKeyboardShortcuts() {
        return defaultToolsMap.keySet();
    }

    public static class ModifierKeySpec
    extends HashSet<Integer> {
        public static final ModifierKeySpec DEFAULT = new ModifierKeySpec();

        private ModifierKeySpec() {
        }

        public ModifierKeySpec(int[] keys) {
            for (int i : keys) {
                this.add(i);
            }
        }

        public ModifierKeySpec(Collection<Integer> keys) {
            this.addAll(keys);
        }

        public ModifierKeySpec(boolean needsControl, boolean needsShift, boolean needsAltOrMeta) {
            if (needsControl) {
                this.add(17);
            }
            if (needsShift) {
                this.add(16);
            }
            if (needsAltOrMeta) {
                this.add(18);
            }
        }

        @Override
        public boolean add(Integer e) {
            if (e == 17 && CheckOS.isMacOsx()) {
                e = 157;
            }
            return super.add(e);
        }

        protected void addAllRaw(Collection<Integer> c) {
            for (Integer integer : c) {
                super.add(integer);
            }
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ModifierKeySpec) {
                ModifierKeySpec other = (ModifierKeySpec)obj;
                for (Integer keyval : this) {
                    if (other.contains(keyval)) continue;
                    return false;
                }
                return true;
            }
            if (obj instanceof KeyStroke) {
                KeyStroke other = (KeyStroke)obj;
                return other.equals(this.toKeyStroke());
            }
            return false;
        }

        public KeyStroke toKeyStroke() {
            int modifiers = 0;
            int keys = 0;
            for (Integer keyval : this) {
                if (keyval == 16) {
                    modifiers |= 1;
                    continue;
                }
                if (keyval == 17) {
                    modifiers |= 2;
                    continue;
                }
                if (keyval == 157) {
                    modifiers |= 4;
                    continue;
                }
                if (keyval == 18) {
                    modifiers |= 8;
                    continue;
                }
                if (keyval == 65406) {
                    modifiers |= 0x20;
                    continue;
                }
                keys |= keyval.intValue();
            }
            return KeyStroke.getKeyStroke(keys, modifiers);
        }

        @Override
        public String toString() {
            String out = "";
            for (Integer keyval : this) {
                String keyDesc = KeyEvent.getKeyText(keyval);
                out = out + (out.length() > 0 ? "+" + keyDesc : keyDesc);
            }
            return out;
        }
    }

    public static class ModifierKeySet
    extends ModifierKeySpec {
        public ModifierKeySet(Collection<Integer> keys) {
            this.addAllRaw(keys);
        }
    }

    public static class Setup
    implements Configuration {
        @Override
        public void configure(PlugInContext context) throws Exception {
            WorkbenchContext workbenchContext = context.getWorkbenchContext();
            ZoomTool zoom = new ZoomTool(workbenchContext);
            PanTool pan = new PanTool(workbenchContext);
            CursorTool selectFeaturesTool = new SelectFeaturesTool(workbenchContext){

                @Override
                protected boolean selectedLayersOnly() {
                    return false;
                }
            };
            FeatureInfoTool info = new FeatureInfoTool(workbenchContext);
            InsertVertexTool insVertex = new InsertVertexTool(workbenchContext);
            DeleteVertexTool delVertex = new DeleteVertexTool(workbenchContext);
            MoveVertexTool movVertex = new MoveVertexTool(workbenchContext);
            MoveSelectedItemsTool moveItem = new MoveSelectedItemsTool(workbenchContext);
            CursorTool rotateItem = new RotateSelectedItemTool(workbenchContext);
            QuasimodeTool.addDefaultTool(new ModifierKeySpec(false, false, true), zoom);
            QuasimodeTool.addDefaultTool(new ModifierKeySpec(false, true, false), pan);
            selectFeaturesTool = QuasimodeTool.addDefaultTool(new ModifierKeySpec(true, false, false), selectFeaturesTool);
            QuasimodeTool.addDefaultTool(new ModifierKeySpec(true, true, false), selectFeaturesTool);
            QuasimodeTool.addDefaultTool(new ModifierKeySpec(true, false, true), info);
            QuasimodeTool.addDefaultTool(new ModifierKeySpec(new int[]{65}), insVertex);
            QuasimodeTool.addDefaultTool(new ModifierKeySpec(new int[]{88}), delVertex);
            QuasimodeTool.addDefaultTool(new ModifierKeySpec(new int[]{86}), movVertex);
            QuasimodeTool.addDefaultTool(new ModifierKeySpec(new int[]{77}), moveItem);
            rotateItem = QuasimodeTool.addDefaultTool(new ModifierKeySpec(new int[]{82}), rotateItem);
            QuasimodeTool.addDefaultTool(new ModifierKeySpec(new int[]{82, 16}), rotateItem);
        }
    }
}

