/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.LayerTreeModel;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.CloneableInternalFrame;
import com.vividsolutions.jump.workbench.ui.DummyLayerNamePanel;
import com.vividsolutions.jump.workbench.ui.InfoFrame;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerNameRenderer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerableNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerableNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.PrimaryInfoFrame;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import com.vividsolutions.jump.workbench.ui.TaskFrameProxy;
import com.vividsolutions.jump.workbench.ui.TreeLayerNamePanel;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.NoninvertibleTransformException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.Timer;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.xml.namespace.QName;
import org.openjump.core.ccordsys.utils.SRSInfo;
import org.openjump.core.ccordsys.utils.SridLookupTable;

public class TaskFrame
extends JInternalFrame
implements TaskFrameProxy,
CloneableInternalFrame,
LayerViewPanelProxy,
LayerNamePanelProxy,
LayerableNamePanelProxy,
LayerManagerProxy,
SelectionManagerProxy,
Task.NameListener {
    private int cloneIndex;
    private InfoFrame infoFrame = null;
    private LayerableNamePanel layerNamePanel = new DummyLayerNamePanel();
    private LayerViewPanel layerViewPanel;
    private Task task;
    private WorkbenchContext workbenchContext;
    private final JSplitPane splitPane = new JSplitPane();
    private Timer timer;
    private String realTitle;

    @Override
    public TaskFrame getTaskFrame() {
        return this;
    }

    public TaskFrame(Task task, WorkbenchContext workbenchContext) {
        this(task, 0, workbenchContext);
    }

    @Override
    public SelectionManager getSelectionManager() {
        return this.getLayerViewPanel().getSelectionManager();
    }

    public TaskFrame() {
    }

    private TaskFrame(Task task, int cloneIndex, final WorkbenchContext workbenchContext) {
        this.task = task;
        this.cloneIndex = cloneIndex;
        this.workbenchContext = workbenchContext;
        final WorkbenchFrame frame = workbenchContext.getWorkbench().getFrame();
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                frame.setActiveTaskFrame((TaskFrame)e.getInternalFrame());
                frame.getToolBar().reClickSelectedCursorToolButton();
                TaskFrame.this.getLayerViewPanel().reSetCurrentCursorTool();
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                try {
                    TaskFrame.this.timer.stop();
                }
                catch (Throwable t) {
                    frame.handleThrowable(t);
                }
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent e) {
                TaskFrame.this.splitPane.remove((Component)((Object)TaskFrame.this.layerNamePanel));
                TaskFrame.this.layerNamePanel = TaskFrame.this.createLayerNamePanel();
                TaskFrame.this.splitPane.add((Component)((Object)TaskFrame.this.layerNamePanel), "left");
                TaskFrame.this.layerNamePanel.addListener(workbenchContext.getWorkbench().getFrame().getLayerNamePanelListener());
            }
        });
        this.layerViewPanel = new LayerViewPanel(task.getLayerManager(), workbenchContext.getWorkbench().getFrame());
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                super.mouseDragged(e);
                try {
                    TaskFrame.this.layerViewPanel.getViewport().update();
                }
                catch (NoninvertibleTransformException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                try {
                    TaskFrame.this.layerViewPanel.getViewport().update();
                }
                catch (NoninvertibleTransformException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.layerViewPanel.addListener(workbenchContext.getWorkbench().getFrame().getLayerViewPanelListener());
        this.layerViewPanel.getViewport().addListener(workbenchContext.getWorkbench().getFrame());
        task.add(this);
        this.installAnimator();
    }

    protected LayerableNamePanel createLayerNamePanel() {
        TreeLayerNamePanel treeLayerNamePanel = new TreeLayerNamePanel(this, new LayerTreeModel(this), this.layerViewPanel.getRenderingManager(), new HashMap());
        Map<Class<?>, JPopupMenu> nodeClassToPopupMenuMap = this.workbenchContext.getWorkbench().getFrame().getNodeClassToPopupMenuMap();
        for (Class<?> nodeClass : nodeClassToPopupMenuMap.keySet()) {
            treeLayerNamePanel.addPopupMenu(nodeClass, nodeClassToPopupMenuMap.get(nodeClass));
        }
        return treeLayerNamePanel;
    }

    @Override
    public LayerManager getLayerManager() {
        return this.task.getLayerManager();
    }

    public InfoFrame getInfoFrame() {
        if (this.infoFrame == null || this.infoFrame.isClosed()) {
            this.infoFrame = new PrimaryInfoFrame(this.workbenchContext, this, this);
        }
        return this.infoFrame;
    }

    @Override
    public LayerNamePanel getLayerNamePanel() {
        return this.layerNamePanel;
    }

    @Override
    public LayerableNamePanel getLayerableNamePanel() {
        return this.layerNamePanel;
    }

    @Override
    public LayerViewPanel getLayerViewPanel() {
        return this.layerViewPanel;
    }

    public void setTask(Task task) {
        if (this.task != null) {
            throw new IllegalStateException("Task is already set");
        }
        this.task = task;
    }

    public Task getTask() {
        return this.task;
    }

    private int nextCloneIndex() {
        String key = this.getClass().getName() + " - LAST_CLONE_INDEX";
        this.task.getLayerManager().getBlackboard().put(key, 1 + this.task.getLayerManager().getBlackboard().get(key, 0));
        return this.task.getLayerManager().getBlackboard().getInt(key);
    }

    @Override
    public JInternalFrame internalFrameClone() {
        TaskFrame clone = new TaskFrame(this.task, this.nextCloneIndex(), this.workbenchContext);
        clone.splitPane.setDividerLocation(0);
        clone.setSize(300, 300);
        if (this.task.getLayerManager().size() > 0) {
            clone.getLayerViewPanel().getViewport().initialize(this.getLayerViewPanel().getViewport().getScale(), this.getLayerViewPanel().getViewport().getOriginInModelCoordinates());
            clone.getLayerViewPanel().setViewportInitialized(true);
        }
        return clone;
    }

    @Override
    public void taskNameChanged(String name) {
        this.updateTitle();
    }

    private void jbInit() {
        this.setResizable(true);
        this.setClosable(true);
        this.setMaximizable(true);
        this.setIconifiable(true);
        this.setSize(680, 380);
        this.getContentPane().setLayout(new BorderLayout());
        this.splitPane.setBorder(null);
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.splitPane.add((Component)((Object)this.layerNamePanel), "left");
        this.splitPane.add((Component)this.layerViewPanel, "right");
        this.splitPane.setDividerLocation(200);
        this.updateTitle();
    }

    public String getRealTitle() {
        return this.realTitle;
    }

    public void updateTitle() {
        SRSInfo srid;
        String title = this.task.getName();
        if (this.cloneIndex > 0) {
            title = title + " (View " + (this.cloneIndex + 1) + ")";
        }
        this.realTitle = title;
        if (this.task.getProperties().containsKey(new QName("Project SRS ID")) && !(srid = SridLookupTable.getSrsAndUnitFromCode(this.task.getProperty(new QName("Project SRS ID")).toString())).getCode().matches("0")) {
            String proj = srid.toString();
            int endIndex = proj.lastIndexOf("[");
            String description = proj.substring(0, endIndex);
            title = title + " < " + description + " > ";
        }
        this.setTitle(title);
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    protected void installAnimator() {
        this.timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.clockedRenderingInProgress()) {
                    TaskFrame.this.repaint();
                } else if (this.clocksShown()) {
                    TaskFrame.this.repaint();
                }
            }

            private boolean clockedRenderingInProgress() {
                for (Layerable layerable : TaskFrame.this.getLayerManager().getLayerables(Layerable.class)) {
                    Renderer renderer;
                    if (!layerable.getBlackboard().get(LayerNameRenderer.USE_CLOCK_ANIMATION_KEY, false) || (renderer = TaskFrame.this.layerViewPanel.getRenderingManager().getRenderer(layerable)) == null || !renderer.isRendering()) continue;
                    return true;
                }
                return false;
            }

            private boolean clocksShown() {
                for (Layerable layerable : TaskFrame.this.getLayerManager().getLayerables(Layerable.class)) {
                    if (layerable.getBlackboard().get(LayerNameRenderer.PROGRESS_ICON_KEY) == null) continue;
                    return true;
                }
                return false;
            }
        });
        this.timer.setCoalesce(true);
        this.timer.start();
    }
}

