/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableChecked;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import org.openjump.core.CheckOS;

public class ShortcutPluginExecuteKeyListener
implements KeyListener {
    private HashMap<KeyStroke, PlugIn> keyStrokeToPluginMap = new LinkedHashMap<KeyStroke, PlugIn>();
    private HashMap<KeyStroke, EnableCheck> keyStrokeToCheckMap = new HashMap();
    private WorkbenchContext workbenchContext;

    public ShortcutPluginExecuteKeyListener(WorkbenchContext wbc) {
        this.workbenchContext = wbc;
    }

    public void add(int keyCode, int modifiers, PlugIn plugin, EnableCheck enableCheck) {
        KeyStroke key = ShortcutPluginExecuteKeyListener.keyStroke(keyCode, modifiers, true);
        this.keyStrokeToPluginMap.put(key, plugin);
        if (enableCheck != null) {
            this.keyStrokeToCheckMap.put(key, enableCheck);
        }
    }

    public void add(KeyStroke key, PlugIn plugin) {
        this.keyStrokeToPluginMap.put(key, plugin);
    }

    public boolean contains(KeyStroke key) {
        return this.keyStrokeToPluginMap.containsKey(key);
    }

    public boolean containsDefinition(KeyStroke key) {
        key = ShortcutPluginExecuteKeyListener.keyStroke(key.getKeyCode(), key.getModifiers(), true);
        return this.keyStrokeToPluginMap.containsKey(key);
    }

    public PlugIn getPlugIn(KeyStroke key) {
        return this.keyStrokeToPluginMap.get(key);
    }

    public EnableCheck getEnableCheck(KeyStroke key) {
        return this.keyStrokeToCheckMap.get(key);
    }

    public final Set<KeyStroke> getAllKeyStrokes() {
        return this.keyStrokeToPluginMap.keySet();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.contains(ShortcutPluginExecuteKeyListener.keyStroke(e.getKeyCode(), e.getModifiers(), false))) {
            e.consume();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        KeyStroke key = ShortcutPluginExecuteKeyListener.keyStroke(e.getKeyCode(), e.getModifiers(), false);
        PlugIn plugin = this.getPlugIn(key);
        if (plugin == null) {
            return;
        }
        e.consume();
        EnableCheck enableCheck = this.getEnableCheck(key);
        if (enableCheck == null && plugin instanceof EnableChecked) {
            enableCheck = ((EnableChecked)((Object)plugin)).getEnableCheck();
        }
        String msg = null;
        if (enableCheck != null && (msg = enableCheck.check(null)) != null) {
            this.workbenchContext.getWorkbench().getFrame().warnUser(msg);
            return;
        }
        AbstractPlugIn.toActionListener(plugin, this.workbenchContext, new TaskMonitorManager()).actionPerformed(null);
    }

    public String toString() {
        String out = "";
        Iterator<Map.Entry<KeyStroke, PlugIn>> iterator = this.keyStrokeToPluginMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<KeyStroke, PlugIn> e;
            Map.Entry<KeyStroke, PlugIn> entry = e = iterator.next();
            out = out + entry.getKey() + "/" + (((Object)entry.getKey()).toString().contains("79") ? this.valueToString(entry.getValue()) : "") + ", ";
        }
        return out;
    }

    private String valueToString(Object value) {
        PlugIn p = (PlugIn)((Object[])value)[0];
        return p.getName();
    }

    public static KeyStroke getPlatformKeyStroke(KeyStroke stroke) {
        return KeyStroke.getKeyStroke(stroke.getKeyCode(), ShortcutPluginExecuteKeyListener.filterModifierDefinition(stroke.getModifiers()), stroke.isOnKeyRelease());
    }

    private static int filterModifierDownMasks(int modifiers) {
        int old = modifiers;
        modifiers &= 0xFFFFFF7F;
        modifiers &= 0xFFFFFFBF;
        modifiers &= 0xFFFFFDFF;
        modifiers &= 0xFFFFDFFF;
        return modifiers &= 0xFFFFFEFF;
    }

    private static int filterModifierDefinition(int modifiers) {
        if (CheckOS.isMacOsx() && (modifiers & 2) != 0) {
            modifiers &= 0xFFFFFFFD;
            modifiers &= 0xFFFFFF7F;
            modifiers |= 4;
        }
        return modifiers;
    }

    private static KeyStroke keyStroke(int keyCode, int modifiers, boolean define) {
        modifiers = define ? ShortcutPluginExecuteKeyListener.filterModifierDefinition(modifiers) : ShortcutPluginExecuteKeyListener.filterModifierDownMasks(modifiers);
        return KeyStroke.getKeyStroke(keyCode, modifiers);
    }
}

