/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import org.openjump.core.apitools.IOTools;
import org.openjump.core.ui.io.file.FileNameExtensionFilter;

public class JTablePanel
extends JPanel {
    private final String sSaved = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.file.saved");
    private final String SCouldNotSave = I18N.getInstance().get("org.openjump.sextante.gui.additionalResults.AdditionalResultsPlugIn.Could-not-save-selected-result");
    private static final long serialVersionUID = 1L;
    private JScrollPane pane = new JScrollPane();
    private final JPanel filterPanel = new JPanel(new BorderLayout());
    private JTable jTable = new JTable();
    private final JLabel jLabel = new JLabel();
    private DefaultTableModel model = new DefaultTableModel();
    private final Color LIGHT_GRAY = new Color(230, 230, 230);
    private JPanel southPanel = new JPanel();
    private final JTable subtable = new JTable();

    public JTablePanel(DefaultTableModel defaultTableModel) {
        this.model = defaultTableModel;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    public JTable getTable() {
        return this.jTable;
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.jLabel.setText(I18N.getInstance().get("org.openjump.core.ui.plugin.raster.DEMStatisticsPlugIn.rows") + ": " + this.model.getRowCount() + " - " + I18N.getInstance().get("org.openjump.core.ui.plugin.raster.DEMStatisticsPlugIn.columns") + ": " + this.model.getColumnCount());
        this.jLabel.setFont(this.jLabel.getFont().deriveFont(1));
        this.setTableModel(this.model);
        this.jTable = new JTable();
        this.jTable.setGridColor(Color.WHITE);
        this.jTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                c.setBackground(row % 2 == 0 ? Color.white : JTablePanel.this.LIGHT_GRAY);
                if (isSelected) {
                    c.setBackground(Color.cyan);
                }
                return c;
            }
        });
        this.pane = new JScrollPane(this.jTable, 20, 30);
        this.jTable.setModel(this.model);
        this.jTable.setEnabled(true);
        this.southPanel = new JPanel(new BorderLayout());
        this.southPanel.add((Component)this.commandPanel(), "North");
        this.southPanel.add((Component)this.savePanel(), "Center");
        this.add((Component)this.jLabel, "North");
        this.add((Component)this.pane, "Center");
        this.add((Component)this.southPanel, "South");
    }

    private JPanel savePanel() {
        JPanel save = new JPanel();
        save.setLayout(new FlowLayout(2));
        JButton saveButton = new JButton(I18N.getInstance().get("deejump.plugin.SaveLegendPlugIn.Save"));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FileNameExtensionFilter filter2 = new FileNameExtensionFilter("Comma-Separated Values (csv)", "csv");
                    GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting();
                    fc.setFileFilter(filter2);
                    fc.setFileFilter(filter2);
                    fc.addChoosableFileFilter(filter2);
                    int returnVal = fc.showSaveDialog(JUMPWorkbench.getInstance().getFrame());
                    if (returnVal == 0) {
                        File file = new File(((JFileChooser)fc).getSelectedFile() + ".csv");
                        IOTools.saveCSV(JTablePanel.this.jTable, file.getAbsolutePath());
                        JTablePanel.this.saved(file);
                    }
                }
                catch (Exception ex) {
                    JTablePanel.this.notsaved();
                }
            }
        });
        save.add(saveButton);
        return save;
    }

    private JPanel commandPanel() {
        final TableRowSorter<DefaultTableModel> sorter = new TableRowSorter<DefaultTableModel>(this.model);
        this.jTable.setRowSorter(sorter);
        final JTextField txtFilter = new JTextField();
        JButton btnOK = new JButton(IconLoader.icon("search.png"));
        btnOK.setToolTipText("Search");
        btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String expr = txtFilter.getText();
                sorter.setRowFilter(RowFilter.regexFilter(expr, new int[0]));
                sorter.setSortKeys(null);
                JTablePanel.this.subtable.setRowSorter(sorter);
            }
        });
        JButton btSave = new JButton(IconLoader.icon("disk.png"));
        btSave.setToolTipText("Save search");
        btSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FileNameExtensionFilter filter2 = new FileNameExtensionFilter("Comma-Separated Values (csv)", "csv");
                    GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting();
                    fc.setFileFilter(filter2);
                    fc.setFileFilter(filter2);
                    fc.addChoosableFileFilter(filter2);
                    int returnVal = fc.showSaveDialog(JUMPWorkbench.getInstance().getFrame());
                    if (returnVal == 0) {
                        File file = new File(((JFileChooser)fc).getSelectedFile() + ".csv");
                        IOTools.saveCSV(JTablePanel.this.subtable, file.getAbsolutePath());
                        JTablePanel.this.saved(file);
                    }
                }
                catch (Exception ex) {
                    JTablePanel.this.notsaved();
                }
            }
        });
        JPanel jbuttonpan = new JPanel();
        jbuttonpan.add((Component)btnOK, "West");
        jbuttonpan.add((Component)btSave, "East");
        this.filterPanel.add((Component)txtFilter, "Center");
        this.filterPanel.add((Component)jbuttonpan, "East");
        return this.filterPanel;
    }

    public DefaultTableModel setTableModel(DefaultTableModel table) {
        return this.model;
    }

    public JPanel getAllComponetsExceptTable() {
        return this.southPanel;
    }

    public DefaultTableModel getTableModel() {
        return this.model;
    }

    public JPanel getCommandPanel() {
        return this.commandPanel();
    }

    public JPanel getSavePanel() {
        return this.savePanel();
    }

    protected void saved(File file) {
        JUMPWorkbench.getInstance().getFrame().setStatusMessage(this.sSaved + " :" + file.getAbsolutePath());
    }

    protected void notsaved() {
        JUMPWorkbench.getInstance().getFrame().warnUser(this.SCouldNotSave);
    }
}

