/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.OptionsPanel;
import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.locationtech.jts.util.Assert;
import org.saig.core.gui.swing.sldeditor.util.FormUtils;
import org.saig.jump.widgets.config.ConfigTooltipPanel;

public class EditOptionsPanel
extends JPanel
implements OptionsPanel {
    private JPanel editPanel;
    private JCheckBox preventEditsCheckBox;
    private JCheckBox selectNewGeometryCheckBox;
    private JCheckBox selectInfoNewGeometryCheckBox;
    private JCheckBox singleEditableLayerCheckBox;
    private JPanel layerToolTipPanel;
    private Blackboard blackboard;
    private JCheckBox tooltipCheckBox;
    public static final String SELECT_NEW_GEOMETRY_KEY = ConfigTooltipPanel.class.getName() + " - SELECT_NEW_GEOMETRY";
    public static final String SELECT_INFO_GEOMETRY_KEY = ConfigTooltipPanel.class.getName() + " - SELECT_INFO_GEOMETRY";
    public static final String SINGLE_EDITABLE_LAYER_KEY = ConfigTooltipPanel.class.getName() + " - SINGLE_EDITABLE_LAYER";
    public static final String LAYER_TOOLTIPS_KEY = ConfigTooltipPanel.class.getName() + " - LAYER_TOOLTIPS";
    public static final String EDIT_PANEL = I18N.getInstance().get("ui.EditOptionsPanel.edit-panel");
    public static final String PREVENT_INVALID_EDIT = I18N.getInstance().get("ui.EditOptionsPanel.prevent-edits-resulting-in-invalid-geometries");
    public static final String SELECT_NEW_GEOMETRY = I18N.getInstance().get("ui.EditOptionsPanel.select-new-geometry");
    public static final String SELECT_INFO_GEOMETRY = "..." + I18N.getInstance().get("ui.EditOptionsPanel.open.info.frame");
    public static final String SELECT_NEW_GEOMETRY_WARNING = I18N.getInstance().get("ui.EditOptionsPanel.select-new-geometry-deselect-previous-selection");
    public static final String SINGLE_EDITABLE_LAYER = I18N.getInstance().get("ui.EditOptionsPanel.single-editable-layer");
    public static final String CONFIGURE_LAYERTREE_PANEL = I18N.getInstance().get("ui.EditOptionsPanel.configure-layer-tree-tooltip");
    public static final String LAYER_TOOLTIP = I18N.getInstance().get("ui.EditOptionsPanel.enable-JUMP-basic-tooltips");

    public EditOptionsPanel(Blackboard blackboard) {
        this.blackboard = blackboard;
        this.setLayout(new GridBagLayout());
        FormUtils.addRowInGBL(this, 1, 0, this.getEditPanel());
        FormUtils.addRowInGBL(this, 3, 0, this.getTooltipPanel());
        FormUtils.addFiller(this, 4, 0);
        try {
            this.init();
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere((String)e.toString());
        }
        this.selectNewGeometryCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EditOptionsPanel.this.selectInfoNewGeometryCheckBox.setEnabled(true);
                } else {
                    EditOptionsPanel.this.selectInfoNewGeometryCheckBox.setSelected(false);
                    EditOptionsPanel.this.selectInfoNewGeometryCheckBox.setEnabled(false);
                }
            }
        });
    }

    @Override
    public void init() {
        this.preventEditsCheckBox.setSelected(this.blackboard.get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false));
        this.selectNewGeometryCheckBox.setSelected(this.blackboard.get(SELECT_NEW_GEOMETRY_KEY, false));
        this.selectInfoNewGeometryCheckBox.setSelected(this.blackboard.get(SELECT_INFO_GEOMETRY_KEY, false));
        this.selectInfoNewGeometryCheckBox.setEnabled(this.blackboard.get(SELECT_NEW_GEOMETRY_KEY, true));
        this.singleEditableLayerCheckBox.setSelected(this.blackboard.get(SINGLE_EDITABLE_LAYER_KEY, true));
        this.tooltipCheckBox.setSelected(this.blackboard.get(LAYER_TOOLTIPS_KEY, false));
        this.blackboard.put(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, this.preventEditsCheckBox.isSelected());
        this.blackboard.put(SELECT_NEW_GEOMETRY_KEY, this.selectNewGeometryCheckBox.isSelected());
        this.blackboard.put(SELECT_INFO_GEOMETRY_KEY, this.selectInfoNewGeometryCheckBox.isSelected());
        this.blackboard.put(SINGLE_EDITABLE_LAYER_KEY, this.singleEditableLayerCheckBox.isSelected());
        this.blackboard.put(LAYER_TOOLTIPS_KEY, this.tooltipCheckBox.isSelected());
    }

    @Override
    public String validateInput() {
        return null;
    }

    @Override
    public void okPressed() {
        this.blackboard.put(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, this.preventEditsCheckBox.isSelected());
        this.blackboard.put(SELECT_NEW_GEOMETRY_KEY, this.selectNewGeometryCheckBox.isSelected());
        this.blackboard.put(SELECT_INFO_GEOMETRY_KEY, this.selectInfoNewGeometryCheckBox.isSelected());
        this.blackboard.put(SINGLE_EDITABLE_LAYER_KEY, this.singleEditableLayerCheckBox.isSelected());
        this.blackboard.put(LAYER_TOOLTIPS_KEY, this.tooltipCheckBox.isSelected());
    }

    private JPanel getEditPanel() {
        if (this.editPanel == null) {
            this.editPanel = new JPanel(new GridBagLayout());
            TitledBorder titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), EDIT_PANEL);
            this.editPanel.setBorder(titledBorder2);
            this.preventEditsCheckBox = new JCheckBox(PREVENT_INVALID_EDIT);
            this.selectNewGeometryCheckBox = new JCheckBox(SELECT_NEW_GEOMETRY);
            this.selectInfoNewGeometryCheckBox = new JCheckBox(SELECT_INFO_GEOMETRY);
            this.selectInfoNewGeometryCheckBox.setEnabled(this.selectNewGeometryCheckBox.isSelected());
            this.selectNewGeometryCheckBox.setToolTipText(SELECT_NEW_GEOMETRY_WARNING);
            this.singleEditableLayerCheckBox = new JCheckBox(SINGLE_EDITABLE_LAYER);
            FormUtils.addRowInGBL(this.editPanel, 0, 0, this.preventEditsCheckBox);
            FormUtils.addRowInGBL(this.editPanel, 1, 0, this.selectNewGeometryCheckBox);
            FormUtils.addRowInGBL(this.editPanel, 2, 0, this.selectInfoNewGeometryCheckBox);
            FormUtils.addRowInGBL(this.editPanel, 3, 0, this.singleEditableLayerCheckBox);
        }
        return this.editPanel;
    }

    private JPanel getTooltipPanel() {
        if (this.layerToolTipPanel == null) {
            this.layerToolTipPanel = new JPanel(new GridBagLayout());
            TitledBorder titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), CONFIGURE_LAYERTREE_PANEL);
            this.layerToolTipPanel.setBorder(titledBorder1);
            this.tooltipCheckBox = new JCheckBox(LAYER_TOOLTIP);
            FormUtils.addRowInGBL(this.layerToolTipPanel, 0, 0, this.tooltipCheckBox);
        }
        return this.layerToolTipPanel;
    }
}

