/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.plugin;

import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.driver.DriverManager;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import com.vividsolutions.jump.workbench.ui.HTMLFrame;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerableNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerableNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.Collection;
import javax.swing.JInternalFrame;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.rasterimage.RasterImageLayer;

public class PlugInContext
implements LayerViewPanelProxy,
LayerNamePanelProxy,
LayerableNamePanelProxy,
LayerManagerProxy {
    private Task task;
    private LayerNamePanel layerNamePanel;
    private LayerViewPanel layerViewPanel;
    private WorkbenchContext workbenchContext;
    private LayerManagerProxy layerManagerProxy;

    public PlugInContext(WorkbenchContext workbenchContext, Task task, LayerManagerProxy layerManagerProxy, LayerNamePanel layerNamePanel, LayerViewPanel layerViewPanel) {
        this.workbenchContext = workbenchContext;
        this.task = task;
        this.layerManagerProxy = layerManagerProxy;
        this.layerNamePanel = layerNamePanel;
        this.layerViewPanel = layerViewPanel;
    }

    public DriverManager getDriverManager() {
        return this.workbenchContext.getDriverManager();
    }

    public ErrorHandler getErrorHandler() {
        return this.workbenchContext.getErrorHandler();
    }

    public WorkbenchContext getWorkbenchContext() {
        return this.workbenchContext;
    }

    public Layer getSelectedLayer(int i) {
        Layer[] selectedLayers = this.getSelectedLayers();
        if (selectedLayers.length > i) {
            return selectedLayers[i];
        }
        return null;
    }

    public Layer getCandidateLayer(int i) {
        Layer lyr = this.getSelectedLayer(i);
        if (lyr != null) {
            return lyr;
        }
        return this.getLayerManager().getLayer(i);
    }

    public Layer[] getSelectedLayers() {
        return this.getLayerNamePanel().getSelectedLayers();
    }

    public Collection<Layerable> getSelectedLayerables() {
        if (this.getLayerNamePanel() instanceof LayerableNamePanel) {
            return ((LayerableNamePanel)this.getLayerNamePanel()).getSelectedLayerables();
        }
        return null;
    }

    public Envelope getSelectedLayerEnvelope() {
        return this.getSelectedLayer(0).getFeatureCollectionWrapper().getEnvelope();
    }

    public Task getTask() {
        return this.task;
    }

    @Override
    public LayerNamePanel getLayerNamePanel() {
        return this.layerNamePanel;
    }

    @Override
    public LayerableNamePanel getLayerableNamePanel() {
        if (this.layerNamePanel instanceof LayerableNamePanel) {
            return (LayerableNamePanel)this.layerNamePanel;
        }
        return null;
    }

    @Override
    public LayerManager getLayerManager() {
        return this.layerManagerProxy.getLayerManager();
    }

    @Override
    public LayerViewPanel getLayerViewPanel() {
        return this.layerViewPanel;
    }

    public WorkbenchFrame getWorkbenchFrame() {
        return this.workbenchContext.getWorkbench().getFrame();
    }

    public Layer addLayer(String categoryName, String layerName, FeatureCollection featureCollection) {
        return this.getLayerManager().addLayer(categoryName, layerName, featureCollection);
    }

    public void addLayerSextanteRaster(String categoryName, RasterImageLayer raster) {
        this.getLayerManager().addLayerable(categoryName, raster);
    }

    public HTMLFrame getOutputFrame() {
        return this.workbenchContext.getWorkbench().getFrame().getOutputFrame();
    }

    public JInternalFrame getActiveInternalFrame() {
        return this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame();
    }

    public EnableCheckFactory getCheckFactory() {
        return EnableCheckFactory.getInstance(this.workbenchContext);
    }

    public FeatureInstaller getFeatureInstaller() {
        return FeatureInstaller.getInstance(this.workbenchContext);
    }
}

