/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jump.coordsys.CoordinateSystem;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.ObjectGraphIterator;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.CategoryEventType;
import com.vividsolutions.jump.workbench.model.Disposable;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.FenceLayerFinder;
import com.vividsolutions.jump.workbench.model.GeoReferencedLayerable;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.model.UndoableEditReceiver;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.style.AbstractPalettePanel;
import java.awt.Color;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.util.Assert;
import org.openjump.core.ccordsys.utils.SRSInfo;
import org.openjump.core.rasterimage.RasterImageLayer;

public class LayerManager {
    private static int layerManagerCount = 0;
    private final UndoableEditReceiver undoableEditReceiver = new UndoableEditReceiver();
    private final List<Category> categories = new ArrayList<Category>();
    private final List<WeakReference<Layerable>> layerReferencesToDispose = new ArrayList<WeakReference<Layerable>>();
    private final List<LayerListener> layerListeners = new ArrayList<LayerListener>();
    private final Iterator<Color> firstColors;
    private final Blackboard blackboard = new Blackboard();
    private boolean firingEvents = true;
    private Task task;
    private CoordinateSystem coordinateSystem = CoordinateSystem.UNSPECIFIED;

    public LayerManager() {
        this.firstColors = this.firstColors().iterator();
        ++layerManagerCount;
    }

    public LayerManager(Task task) {
        this();
        this.task = task;
    }

    public UndoableEditReceiver getUndoableEditReceiver() {
        return this.undoableEditReceiver;
    }

    public void deferFiringEvents(Runnable r) {
        boolean firingEvents = this.isFiringEvents();
        this.setFiringEvents(false);
        try {
            r.run();
        }
        finally {
            this.setFiringEvents(firingEvents);
        }
    }

    private Collection<Color> firstColors() {
        ArrayList<Color> firstColors = new ArrayList<Color>();
        List<BasicStyle> basicStyles = AbstractPalettePanel.basicStyles();
        if (basicStyles != null) {
            for (BasicStyle basicStyle : basicStyles) {
                if (!basicStyle.isRenderingFill()) continue;
                firstColors.add(basicStyle.getFillColor());
            }
        }
        return firstColors;
    }

    public Color generateLayerFillColor() {
        Color color = this.firstColors.hasNext() ? this.firstColors.next() : new Color((int)Math.floor(Math.random() * 256.0), (int)Math.floor(Math.random() * 256.0), (int)Math.floor(Math.random() * 256.0));
        color = new Color(color.getRed(), color.getGreen(), color.getBlue());
        return color;
    }

    public Layer addLayer(String categoryName, Layer layer) {
        this.addLayerable(categoryName, layer);
        return layer;
    }

    public void addLayerable(String categoryName, Layerable layerable) {
        if (layerable instanceof GeoReferencedLayerable) {
            CoordinateSystem cs;
            Layer layer;
            SRSInfo srsInfo;
            if (this.size() == 0 && this.getCoordinateSystem() == CoordinateSystem.UNSPECIFIED && (srsInfo = ((GeoReferencedLayerable)layerable).getSrsInfo()) != null && srsInfo.getRegistry().equals((Object)SRSInfo.Registry.EPSG)) {
                CoordinateSystem crs = new CoordinateSystem(srsInfo.getDescription(), Integer.parseInt(srsInfo.getCode()), null);
                this.setCoordinateSystem(crs);
            }
            if (layerable instanceof Layer && ((layer = (Layer)layerable).getSrsInfo() == null || layer.getSrsInfo().getCode().equals("0")) && (cs = layer.getFeatureCollectionWrapper().getFeatureSchema().getCoordinateSystem()) != null) {
                try {
                    int epsg = cs.getEPSGCode();
                    if (epsg != 0) {
                        SRSInfo srsInfo2 = new SRSInfo();
                        srsInfo2.setCode("" + epsg);
                        srsInfo2.complete();
                        layer.setSrsInfo(srsInfo2);
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            this.layerReferencesToDispose.add(new WeakReference<Layerable>(layerable));
        }
        this.addCategory(categoryName);
        Category cat = this.getCategory(categoryName);
        try {
            cat.add(0, layerable);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.fireLayerChanged(layerable, LayerEventType.METADATA_CHANGED);
    }

    public void addCategory(String categoryName) {
        this.addCategory(categoryName, this.categories.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCategory(String categoryName, int index) {
        if (this.getCategory(categoryName) != null) {
            return;
        }
        Category category = new Category();
        category.setLayerManager(this);
        boolean firingEvents = this.isFiringEvents();
        this.setFiringEvents(false);
        try {
            category.setName(categoryName);
        }
        finally {
            this.setFiringEvents(firingEvents);
        }
        this.categories.add(index, category);
        this.fireCategoryChanged(category, CategoryEventType.ADDED, this.indexOf(category));
    }

    public Category getCategory(String name) {
        for (Category category : this.categories) {
            if (!category.getName().equals(name)) continue;
            return category;
        }
        return null;
    }

    public List<Category> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public Layer addLayer(String categoryName, String layerName, FeatureCollection featureCollection) {
        String actualName = layerName == null ? "Layer" : layerName;
        Layer layer = new Layer(actualName, this.generateLayerFillColor(), featureCollection, this);
        this.addLayerable(categoryName, layer);
        return layer;
    }

    public Layer addOrReplaceLayer(String categoryName, String layerName, FeatureCollection featureCollection) {
        Layer oldLayer = this.getLayer(layerName);
        if (oldLayer != null) {
            this.remove(oldLayer);
        }
        Layer newLayer = this.addLayer(categoryName, layerName, featureCollection);
        if (oldLayer != null) {
            newLayer.setStyles(oldLayer.cloneStyles());
        }
        return newLayer;
    }

    public String uniqueLayerName(String name) {
        String newName;
        if (!this.isExistingLayerableName(name)) {
            return name;
        }
        int i = 2;
        do {
            newName = name + " (" + i + ")";
            ++i;
        } while (this.isExistingLayerableName(newName));
        return newName;
    }

    private boolean isExistingLayerableName(String name) {
        for (Layerable layerable : this.getLayerables(Layerable.class)) {
            if (!layerable.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void remove(Layerable layerable) {
        this.remove(new Layerable[]{layerable}, false);
    }

    public void remove(Layerable[] layerables) {
        this.remove(layerables, false);
    }

    private void remove(Layerable[] layerables, boolean dispose) {
        for (Layerable layerable : layerables) {
            for (Category category : this.categories) {
                int index = category.indexOf(layerable);
                if (index != -1) {
                    category.remove(layerable);
                    if (dispose && layerable instanceof Disposable) {
                        ((Disposable)((Object)layerable)).dispose();
                    }
                    this.fireLayerChanged(layerable, LayerEventType.REMOVED, category, index);
                }
                if (!(layerable instanceof Layer)) continue;
                this.layerListeners.remove(((Layer)layerable).getLayerListener());
            }
        }
        System.gc();
    }

    public void removeIfEmpty(Category category) {
        if (!category.isEmpty()) {
            return;
        }
        int categoryIndex = this.indexOf(category);
        this.categories.remove(category);
        this.fireCategoryChanged(category, CategoryEventType.REMOVED, categoryIndex);
    }

    public void dispose() {
        this.setFiringEvents(false);
        for (WeakReference<Layerable> reference : this.layerReferencesToDispose) {
            if (!(reference instanceof Disposable)) continue;
            ((Disposable)((Object)reference)).dispose();
        }
        --layerManagerCount;
        this.undoableEditReceiver.getUndoManager().discardAllEdits();
    }

    public void dispose(Layerable l) {
        this.dispose(new Layerable[]{l});
    }

    public void dispose(Layerable[] ls) {
        this.remove(ls, true);
    }

    public int indexOf(Category category) {
        return this.categories.indexOf(category);
    }

    void fireCategoryChanged(Category category, CategoryEventType type) {
        this.fireCategoryChanged(category, type, this.indexOf(category));
    }

    private void fireCategoryChanged(Category category, CategoryEventType type, int categoryIndex) {
        if (!this.firingEvents) {
            return;
        }
        for (LayerListener layerListener : new ArrayList<LayerListener>(this.layerListeners)) {
            this.fireLayerEvent(() -> layerListener.categoryChanged(new CategoryEvent(category, type, categoryIndex)));
        }
    }

    public void fireFeaturesChanged(Collection<Feature> features, FeatureEventType type, Layer layer) {
        Assert.isTrue((type != FeatureEventType.GEOMETRY_MODIFIED ? 1 : 0) != 0);
        this.fireFeaturesChanged(features, type, layer, null);
    }

    public void fireGeometryModified(Collection<Feature> features, Layer layer, Collection<Feature> oldFeatureClones) {
        Assert.isTrue((oldFeatureClones != null ? 1 : 0) != 0);
        this.fireFeaturesChanged(features, FeatureEventType.GEOMETRY_MODIFIED, layer, oldFeatureClones);
    }

    private void fireFeaturesChanged(Collection<Feature> features, FeatureEventType type, Layer layer, Collection<Feature> oldFeatureClones) {
        if (!this.firingEvents) {
            return;
        }
        for (LayerListener layerListener : new ArrayList<LayerListener>(this.layerListeners)) {
            this.fireLayerEvent(() -> layerListener.featuresChanged(new FeatureEvent(features, type, layer, oldFeatureClones)));
        }
    }

    private void fireLayerEvent(Runnable eventFirer) {
        try {
            GUIUtil.invokeOnEventThread(eventFirer);
        }
        catch (InterruptedException e) {
            Assert.shouldNeverReachHere();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace(System.err);
            Assert.shouldNeverReachHere();
        }
    }

    private void fireLayerChanged(Layerable layerable, LayerEventType layerChangeType, Category category, int layerIndex) {
        if (!this.firingEvents) {
            return;
        }
        for (LayerListener layerListener : new ArrayList<LayerListener>(this.layerListeners)) {
            this.fireLayerEvent(() -> layerListener.layerChanged(new LayerEvent(layerable, layerChangeType, category, layerIndex)));
        }
    }

    public void fireLayerChanged(Layerable layerable, LayerEventType type) {
        Category cat = this.getCategory(layerable);
        if (cat == null) {
            Assert.isTrue((!this.isFiringEvents() ? 1 : 0) != 0, (String)("If this event is being fired because you are constructing a Layer, cat will be null because you haven't yet added the Layer to the LayerManager. While constructing a layer, you should set firingEvents to false. (Layerable = " + layerable.getName() + ")"));
            return;
        }
        this.fireLayerChanged(layerable, type, cat, cat.indexOf(layerable));
    }

    public void setFiringEvents(boolean firingEvents) {
        this.firingEvents = firingEvents;
    }

    public boolean isFiringEvents() {
        return this.firingEvents;
    }

    public <T extends Layerable> Iterator<T> reverseIterator(Class<T> layerableClass) {
        ArrayList<T> layerablesCopy = new ArrayList<T>(this.getLayerables(layerableClass));
        Collections.reverse(layerablesCopy);
        this.moveLayersDrawnLastToEnd(layerablesCopy);
        return layerablesCopy.iterator();
    }

    private <T extends Layerable> void moveLayersDrawnLastToEnd(List<T> layerables) {
        ArrayList<Layerable> layersDrawnLast = new ArrayList<Layerable>();
        Iterator<T> i = layerables.iterator();
        while (i.hasNext()) {
            Layer layer;
            Layerable layerable = (Layerable)i.next();
            if (!(layerable instanceof Layer) || !(layer = (Layer)layerable).isDrawingLast()) continue;
            layersDrawnLast.add(layerable);
            i.remove();
        }
        layerables.addAll(layersDrawnLast);
    }

    public <T> Iterator<T> iterator(final Class<T> clazz) {
        final ObjectGraphIterator<Object> iterator = new ObjectGraphIterator<Object>(this, input -> {
            if (input instanceof LayerManager) {
                return ((LayerManager)input).getCategories().iterator();
            }
            if (input instanceof Category) {
                if (clazz.isInstance(input)) {
                    return input;
                }
                return ((Category)input).iterator();
            }
            if (input instanceof Layerable) {
                return input;
            }
            throw new ClassCastException();
        });
        return new Iterator<T>(){
            Object nextNode = null;
            boolean hasNext = false;
            boolean nextConsumed = true;

            @Override
            public boolean hasNext() {
                if (this.nextConsumed) {
                    this.hasNext = iterator.hasNext();
                    if (this.hasNext) {
                        this.nextNode = iterator.next();
                        if (!clazz.isInstance(this.nextNode)) {
                            return this.hasNext();
                        }
                        this.nextConsumed = false;
                        return true;
                    }
                    this.nextConsumed = false;
                    return false;
                }
                return this.hasNext;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    this.nextConsumed = true;
                    return this.nextNode;
                }
                throw new NoSuchElementException("No such element");
            }
        };
    }

    public Layer getLayer(String name) {
        Iterator<Layer> i = this.iterator(Layer.class);
        while (i.hasNext()) {
            Layer layer = i.next();
            if (!layer.getName().equals(name)) continue;
            return layer;
        }
        return null;
    }

    public void addLayerListener(LayerListener layerListener) {
        Assert.isTrue((!this.layerListeners.contains(layerListener) ? 1 : 0) != 0);
        this.layerListeners.add(layerListener);
    }

    public void removeLayerListener(LayerListener layerListener) {
        this.layerListeners.remove(layerListener);
    }

    public Layer getLayer(int index) {
        return this.getLayers().get(index);
    }

    public int size() {
        return this.getLayers().size();
    }

    public Envelope getEnvelopeOfAllLayers() {
        return this.getEnvelopeOfAllLayers(false);
    }

    public Envelope getEnvelopeOfAllLayers(boolean visibleLayersOnly) {
        Envelope envelope = new Envelope();
        for (Layer layer : this.getLayers()) {
            if (visibleLayersOnly && !layer.isVisible()) continue;
            envelope.expandToInclude(layer.getFeatureCollectionWrapper().getEnvelope());
        }
        for (WMSLayer wLayer : this.getWMSLayers()) {
            if (visibleLayersOnly && !wLayer.isVisible()) continue;
            envelope.expandToInclude(wLayer.getEnvelope());
        }
        for (RasterImageLayer rLayer : this.getRasterImageLayers()) {
            if (visibleLayersOnly && !rLayer.isVisible()) continue;
            envelope.expandToInclude(rLayer.getWholeImageEnvelope());
        }
        return envelope;
    }

    public List<WMSLayer> getWMSLayers() {
        return this.getLayerables(WMSLayer.class);
    }

    public List<RasterImageLayer> getRasterImageLayers() {
        return this.getLayerables(RasterImageLayer.class);
    }

    public int indexOf(Layer layer) {
        return this.getLayers().indexOf(layer);
    }

    public Category getCategory(Layerable layerable) {
        for (Category category : this.categories) {
            if (!category.contains(layerable)) continue;
            return category;
        }
        return null;
    }

    public List<Layer> getLayers() {
        return this.getLayerables(Layer.class);
    }

    public <T extends Layerable> List<T> getLayerables(Class<T> layerableClass) {
        Assert.isTrue((boolean)Layerable.class.isAssignableFrom(layerableClass));
        ArrayList<Layerable> layers = new ArrayList<Layerable>();
        for (Category category : this.categories) {
            for (Layerable layerable : new ArrayList<Layerable>(category.getLayerables())) {
                if (!layerableClass.isInstance(layerable)) continue;
                layers.add(layerable);
            }
        }
        return layers;
    }

    public List<Layer> getVisibleLayers(boolean includeFence) {
        ArrayList<Layer> visibleLayers = new ArrayList<Layer>(this.getLayers());
        Iterator<Layer> i = visibleLayers.iterator();
        while (i.hasNext()) {
            Layer layer = i.next();
            if (layer.getName().equals(FenceLayerFinder.LAYER_NAME) && !includeFence) {
                i.remove();
                continue;
            }
            if (layer.isVisible()) continue;
            i.remove();
        }
        return visibleLayers;
    }

    public static int layerManagerCount() {
        return layerManagerCount;
    }

    public Collection<Layer> getEditableLayers() {
        ArrayList<Layer> editableLayers = new ArrayList<Layer>();
        for (Layer layer : this.getLayers()) {
            if (!layer.isEditable()) continue;
            editableLayers.add(layer);
        }
        return editableLayers;
    }

    public Blackboard getBlackboard() {
        return this.blackboard;
    }

    public Collection<Layer> getLayersWithModifiedFeatureCollections() {
        ArrayList<Layer> layersWithModifiedFeatureCollections = new ArrayList<Layer>();
        for (Layer layer : this.getLayers()) {
            if (!layer.isFeatureCollectionModified()) continue;
            layersWithModifiedFeatureCollections.add(layer);
        }
        return layersWithModifiedFeatureCollections;
    }

    public LinkedList<String> getTemporaryRasterImageLayers() {
        LinkedList<String> list = new LinkedList<String>();
        List<RasterImageLayer> rlayers = this.getLayerables(RasterImageLayer.class);
        for (RasterImageLayer layer : rlayers) {
            if (!layer.isTemporaryLayer()) continue;
            list.add(layer.getName());
        }
        return list;
    }

    public LinkedList<Layer> getLayersWithNullDataSource() {
        LinkedList<Layer> list = new LinkedList<Layer>();
        Iterator<Layer> i = this.iterator(Layer.class);
        while (i.hasNext()) {
            Layer layer = i.next();
            if (layer.getDataSourceQuery() != null) continue;
            list.add(layer);
        }
        return list;
    }

    public void setCoordinateSystem(CoordinateSystem coordinateSystem) {
        this.coordinateSystem = coordinateSystem;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public void fireFeaturesAttChanged(Collection<Feature> features, FeatureEventType type, Layer layer, Collection<Feature> oldFeatureClones) {
        Assert.isTrue((type != FeatureEventType.GEOMETRY_MODIFIED ? 1 : 0) != 0);
        this.fireFeaturesChanged(features, type, layer, oldFeatureClones);
    }

    public Task getTask() {
        return this.task;
    }
}

