/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jump.util.LangUtil;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.Task;
import org.locationtech.jts.util.Assert;

public abstract class AbstractLayerable
implements Layerable,
LayerManagerProxy {
    private LayerManager layerManager;
    private String name;
    private boolean visible = true;
    private boolean editable = false;
    private boolean selectable = true;
    private boolean readonly = false;
    private boolean scaleDependentRenderingEnabled = false;
    private Double minScale = null;
    private Double maxScale = null;

    public AbstractLayerable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractLayerable(String name, LayerManager layerManager) {
        Assert.isTrue((name != null ? 1 : 0) != 0);
        Assert.isTrue((layerManager != null ? 1 : 0) != 0);
        this.layerManager = layerManager;
        boolean firingEvents = layerManager.isFiringEvents();
        layerManager.setFiringEvents(false);
        try {
            this.setName(layerManager.uniqueLayerName(name));
        }
        finally {
            layerManager.setFiringEvents(firingEvents);
        }
    }

    @Override
    public void setLayerManager(LayerManager layerManager) {
        this.layerManager = layerManager;
    }

    @Override
    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    public void fireLayerChanged(LayerEventType type) {
        if (this.getLayerManager() == null) {
            return;
        }
        this.getLayerManager().fireLayerChanged(this, type);
    }

    public void fireAppearanceChanged() {
        this.fireLayerChanged(LayerEventType.APPEARANCE_CHANGED);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.fireLayerChanged(LayerEventType.METADATA_CHANGED);
    }

    public Task getTask() {
        if (this.layerManager != null) {
            return this.layerManager.getTask();
        }
        return null;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.visible = visible;
        this.fireLayerChanged(LayerEventType.VISIBILITY_CHANGED);
    }

    @Override
    public void setEditable(boolean editable) {
        if (this.editable == editable) {
            return;
        }
        this.editable = editable;
        this.fireLayerChanged(LayerEventType.METADATA_CHANGED);
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public void setReadonly(boolean value) {
        this.readonly = value;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public void setSelectable(boolean value) {
        this.selectable = value;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Double getMaxScale() {
        return this.maxScale;
    }

    @Override
    public Layerable setMaxScale(Double maxScale) {
        if (LangUtil.bothNullOrEqual(this.maxScale, maxScale)) {
            return this;
        }
        this.maxScale = maxScale;
        this.fireAppearanceChanged();
        return this;
    }

    @Override
    public Double getMinScale() {
        return this.minScale;
    }

    @Override
    public Layerable setMinScale(Double minScale) {
        if (LangUtil.bothNullOrEqual(this.minScale, minScale)) {
            return this;
        }
        this.minScale = minScale;
        this.fireAppearanceChanged();
        return this;
    }

    @Override
    public boolean isScaleDependentRenderingEnabled() {
        return this.scaleDependentRenderingEnabled;
    }

    @Override
    public Layerable setScaleDependentRenderingEnabled(boolean scaleDependentRenderingEnabled) {
        if (this.scaleDependentRenderingEnabled == scaleDependentRenderingEnabled) {
            return this;
        }
        this.scaleDependentRenderingEnabled = scaleDependentRenderingEnabled;
        this.fireAppearanceChanged();
        return this;
    }
}

