/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.graphic;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageException;
import com.vividsolutions.jump.workbench.imagery.graphic.WorldFile;
import com.vividsolutions.jump.workbench.model.Disposable;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.AlphaSetting;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import org.locationtech.jts.geom.Envelope;

public abstract class AbstractGraphicImage
implements ReferencedImage,
Disposable,
AlphaSetting {
    protected String uristring;
    protected BufferedImage image = null;
    protected WorldFile wf;
    protected boolean initialload;
    protected Envelope env;
    protected String type = "";
    protected String loader = "";
    int alpha = 255;

    public AbstractGraphicImage(String location, WorldFile wf) {
        this.wf = wf;
        this.uristring = location;
        this.initialload = true;
        if (wf == null) {
            this.wf = WorldFile.create(location);
        }
    }

    @Override
    public Envelope getEnvelope() throws ReferencedImageException {
        if (this.env == null) {
            this.env = this.computeEnvelope();
        }
        return this.env;
    }

    private Envelope computeEnvelope() throws ReferencedImageException {
        this.initImage();
        double xm = this.wf.getXUpperLeft() + this.wf.getXSize() * -0.5;
        double xM = this.wf.getXUpperLeft() + this.wf.getXSize() * (-0.5 + (double)this.image.getWidth());
        double ym = this.wf.getYUpperLeft() + this.wf.getYSize() * -0.5;
        double yM = this.wf.getYUpperLeft() + this.wf.getYSize() * (-0.5 + (double)this.image.getHeight());
        return new Envelope(xm, xM, ym, yM);
    }

    @Override
    public void paint(Feature f, Graphics2D g, Viewport viewport) throws ReferencedImageException {
        this.initImage();
        int jpgPixelWidth = this.image.getWidth();
        int jpgPixelHeight = this.image.getHeight();
        double jpg_xres = this.wf.getXSize();
        double jpg_ulx = f.getGeometry().getEnvelopeInternal().getMinX();
        double jpg_uly = f.getGeometry().getEnvelopeInternal().getMaxY();
        if (this.initialload) {
            if (this.wf.getFilename() != null) {
                jpg_xres = this.wf.getXSize();
                jpg_ulx = this.wf.getXUpperLeft() - this.wf.getXSize() * 0.5;
                jpg_uly = this.wf.getYUpperLeft() + this.wf.getYSize() * 0.5 - (double)this.image.getHeight();
            }
            this.initialload = false;
        } else {
            jpg_xres = f.getGeometry().getEnvelopeInternal().getWidth() / (double)this.image.getWidth();
        }
        int image_x = 0;
        int image_y = 0;
        int image_w = viewport.getPanel().getWidth();
        int image_h = viewport.getPanel().getHeight();
        Envelope vpEnvelope = viewport.getEnvelopeInModelCoordinates();
        double view_res = 1.0 / viewport.getScale();
        double rwViewLeft = vpEnvelope.getMinX();
        double rwViewRight = vpEnvelope.getMaxX();
        double rwViewTop = vpEnvelope.getMaxY();
        double rwViewBot = vpEnvelope.getMinY();
        double halfPixel = 0.5 * jpg_xres;
        double rwJpgFileLeftEdge = jpg_ulx;
        double rwJpgFileRightEdge = rwJpgFileLeftEdge + (double)jpgPixelWidth * jpg_xres;
        double rwJpgFileTopEdge = jpg_uly;
        double rwJpgFileBotEdge = rwJpgFileTopEdge - (double)jpgPixelHeight * jpg_xres;
        double rwRasterLeft = Math.max(rwViewLeft, rwJpgFileLeftEdge);
        double rwRasterRight = Math.min(rwViewRight, rwJpgFileRightEdge);
        double rwRasterTop = Math.min(rwViewTop, rwJpgFileTopEdge);
        double rwRasterBot = Math.max(rwViewBot, rwJpgFileBotEdge);
        if (!(rwJpgFileRightEdge <= rwViewLeft || rwJpgFileLeftEdge >= rwViewRight || rwJpgFileTopEdge <= rwViewBot || rwJpgFileBotEdge >= rwViewTop)) {
            int jpgLeftPixel = (int)((rwRasterLeft - rwJpgFileLeftEdge) / jpg_xres);
            int jpgRightPixel = (int)((rwRasterRight - rwJpgFileLeftEdge) / jpg_xres);
            if (jpgRightPixel == jpgPixelWidth) {
                jpgRightPixel = jpgPixelWidth - 1;
            }
            int jpgTopPixel = (int)((rwJpgFileTopEdge - rwRasterTop) / jpg_xres);
            int jpgBotPixel = (int)((rwJpgFileTopEdge - rwRasterBot) / jpg_xres);
            if (jpgBotPixel == jpgPixelHeight) {
                jpgBotPixel = jpgPixelHeight - 1;
            }
            double rwJpgLeft = rwJpgFileLeftEdge + (double)jpgLeftPixel * jpg_xres;
            double rwJpgRight = rwJpgFileLeftEdge + (double)jpgRightPixel * jpg_xres + jpg_xres;
            double rwJpgTop = rwJpgFileTopEdge - (double)jpgTopPixel * jpg_xres;
            double rwJpgBot = rwJpgFileTopEdge - (double)jpgBotPixel * jpg_xres - jpg_xres;
            int leftOffset = this.round((rwRasterLeft - rwJpgLeft) / view_res);
            int rightOffset = this.round((rwJpgRight - rwRasterRight) / view_res);
            int topOffset = this.round((rwJpgTop - rwRasterTop) / view_res);
            int botOffset = this.round((rwRasterBot - rwJpgBot) / view_res);
            image_x = this.round(rwRasterLeft / view_res) - this.round(rwViewLeft / view_res);
            image_w = this.round(rwRasterRight / view_res) - this.round(rwRasterLeft / view_res);
            if (image_w <= 0) {
                image_w = 1;
            }
            image_y = this.round(rwViewTop / view_res) - this.round(rwRasterTop / view_res);
            image_h = this.round(rwRasterTop / view_res) - this.round(rwRasterBot / view_res);
            if (image_h <= 0) {
                image_h = 1;
            }
            Composite composite = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / 255.0f));
            g.drawImage(this.image, image_x, image_y -= topOffset, (image_x -= leftOffset) + (image_w += leftOffset + rightOffset), image_y + (image_h += topOffset + botOffset), jpgLeftPixel, jpgTopPixel, jpgRightPixel + 1, jpgBotPixel + 1, viewport.getPanel());
            g.setComposite(composite);
        }
    }

    private int round(double num) {
        return (int)Math.round(num);
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getLoader() {
        return this.loader;
    }

    public String getUri() {
        return this.uristring;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    protected abstract void initImage() throws ReferencedImageException;

    public static void close(Closeable is) {
        try {
            if (is instanceof Closeable) {
                is.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void dispose() {
        this.image.flush();
        this.image = null;
        this.wf = null;
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }
}

