/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.datastore;

import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.DataStoreDriver;
import com.vividsolutions.jump.datastore.DataStoreException;
import com.vividsolutions.jump.datastore.DataStoreMetadata;
import com.vividsolutions.jump.datastore.Query;
import com.vividsolutions.jump.datastore.SpatialReferenceSystemID;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDSLayer;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesSQLBuilder;
import com.vividsolutions.jump.io.FeatureInputStream;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.ui.ApplicationExitHandler;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;

public class ConnectionManager {
    private WorkbenchContext context;
    private Map<ConnectionDescriptor, DataStoreConnection> connectionDescriptorToConnectionMap = new HashMap<ConnectionDescriptor, DataStoreConnection>();
    private static final DataStoreConnection DUMMY_CONNECTION = new DataStoreConnection(){

        @Override
        public DataStoreMetadata getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FeatureInputStream execute(Query query) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws DataStoreException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Connection getJdbcConnection() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isClosed() throws DataStoreException {
            return true;
        }

        @Override
        public SpatialDatabasesSQLBuilder getSqlBuilder(SpatialReferenceSystemID srid, String[] colNames) {
            throw new UnsupportedOperationException();
        }
    };
    private List<Listener> listeners = new ArrayList<Listener>();

    private ConnectionManager(WorkbenchContext context, final Collection<ConnectionDescriptor> connectionDescriptors) {
        this.context = context;
        for (ConnectionDescriptor connectionDescriptor : connectionDescriptors) {
            if (connectionDescriptor == null) continue;
            this.connectionDescriptorToConnectionMap.put(connectionDescriptor, DUMMY_CONNECTION);
        }
        this.addListener(new Listener(){

            @Override
            public void connectionDescriptorAdded(ConnectionDescriptor connectionDescriptor) {
                this.updateConnectionDescriptors();
            }

            @Override
            public void connectionDescriptorRemoved(ConnectionDescriptor connectionDescriptor) {
                this.updateConnectionDescriptors();
            }

            private void updateConnectionDescriptors() {
                connectionDescriptors.clear();
                connectionDescriptors.addAll(ConnectionManager.this.connectionDescriptorToConnectionMap.keySet());
            }
        });
        context.getWorkbench().getFrame().addApplicationExitHandler(new ApplicationExitHandler(){

            @Override
            public void exitApplication(JFrame mainFrame) {
                ConnectionManager.this.closeConnections();
            }
        });
    }

    public DataStoreConnection getOpenConnection(ConnectionDescriptor connectionDescriptor) throws Exception {
        if (this.getConnection(connectionDescriptor).isClosed()) {
            this.connectionDescriptorToConnectionMap.put(connectionDescriptor, connectionDescriptor.createConnection(this.getDriver(connectionDescriptor.getDataStoreDriverClassName())));
        }
        return this.getConnection(connectionDescriptor);
    }

    public DataStoreDriver getDriver(String driverClassName) {
        DataStoreDriver driver = this.findDriverRegistryEntry(driverClassName);
        if (driver == null) {
            throw new RuntimeException("Can't find DataStoreDriver: " + driverClassName);
        }
        return driver;
    }

    private DataStoreDriver findDriverRegistryEntry(String driverClassName) {
        List drivers = this.context.getRegistry().getEntries(DataStoreDriver.REGISTRY_CLASSIFICATION);
        for (DataStoreDriver driver : drivers) {
            if (!driver.getClass().getName().equals(driverClassName)) continue;
            return driver;
        }
        return null;
    }

    public DataStoreConnection getConnection(ConnectionDescriptor connectionDescriptor) {
        if (connectionDescriptor == null) {
            return DUMMY_CONNECTION;
        }
        if (!this.connectionDescriptorToConnectionMap.containsKey(connectionDescriptor)) {
            this.connectionDescriptorToConnectionMap.put(connectionDescriptor, DUMMY_CONNECTION);
            this.fireConnectionDescriptorAdded(connectionDescriptor);
        }
        return this.connectionDescriptorToConnectionMap.get(connectionDescriptor);
    }

    public Collection<ConnectionDescriptor> getConnectionDescriptors() {
        return Collections.unmodifiableCollection(this.connectionDescriptorToConnectionMap.keySet());
    }

    public void deleteConnectionDescriptor(ConnectionDescriptor connectionDescriptor) throws DataStoreException {
        if (!this.getConnection(connectionDescriptor).isClosed()) {
            this.getConnection(connectionDescriptor).close();
        }
        this.connectionDescriptorToConnectionMap.remove(connectionDescriptor);
        this.fireConnectionDescriptorRemoved(connectionDescriptor);
    }

    private void fireConnectionDescriptorAdded(ConnectionDescriptor connectionDescriptor) {
        for (Listener listener : this.listeners) {
            listener.connectionDescriptorAdded(connectionDescriptor);
        }
    }

    private void fireConnectionDescriptorRemoved(ConnectionDescriptor connectionDescriptor) {
        for (Listener listener : this.listeners) {
            listener.connectionDescriptorRemoved(connectionDescriptor);
        }
    }

    public static ConnectionManager instance(WorkbenchContext context) {
        String INSTANCE_KEY;
        Blackboard blackboard = context.getBlackboard();
        if (blackboard.get(INSTANCE_KEY = ConnectionManager.class.getName() + " - INSTANCE") == null) {
            blackboard.put(INSTANCE_KEY, new ConnectionManager(context, (Collection)PersistentBlackboardPlugIn.get(blackboard).get(ConnectionManager.class.getName() + " - CONNECTION DESCRIPTORS", new ArrayList())));
        }
        return (ConnectionManager)blackboard.get(INSTANCE_KEY);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void closeConnections() {
        for (ConnectionDescriptor connectionDescriptor : this.getConnectionDescriptors()) {
            this.closeConnection(connectionDescriptor);
        }
    }

    public void closeConnectionsUnused() {
        for (ConnectionDescriptor connectionDescriptor : this.getConnectionDescriptors()) {
            if (!this.getLayersUsing(connectionDescriptor).isEmpty()) continue;
            this.closeConnection(connectionDescriptor);
        }
    }

    public void closeConnection(SpatialDSLayer layer2remove) {
        if (layer2remove.getDataSourceQuery() == null) {
            return;
        }
        ConnectionDescriptor cd2remove = (ConnectionDescriptor)layer2remove.getDataSourceQuery().getDataSource().getProperties().get("Connection Descriptor");
        List<SpatialDSLayer> layers = this.getLayersUsing(cd2remove);
        for (SpatialDSLayer layer : layers) {
            ConnectionDescriptor layerCd = (ConnectionDescriptor)layer.getDataSourceQuery().getDataSource().getProperties().get("Connection Descriptor");
            if (layer == layer2remove) continue;
            return;
        }
        this.closeConnection(cd2remove);
    }

    public void closeConnection(ConnectionDescriptor cd2remove) {
        try {
            if (!this.getConnection(cd2remove).isClosed()) {
                this.getConnection(cd2remove).close();
            }
        }
        catch (DataStoreException e) {
            Logger.error(e);
        }
    }

    private List<SpatialDSLayer> getLayersUsing(ConnectionDescriptor cd) {
        ArrayList<SpatialDSLayer> layers = new ArrayList<SpatialDSLayer>();
        for (TaskFrame frame : this.context.getWorkbench().getFrame().getTaskFrames()) {
            layers.addAll(frame.getLayerManager().getLayerables(SpatialDSLayer.class));
        }
        ArrayList<SpatialDSLayer> layersUsingThisCD = new ArrayList<SpatialDSLayer>();
        for (SpatialDSLayer layer : layers) {
            try {
                ConnectionDescriptor layerCd = (ConnectionDescriptor)layer.getDataSourceQuery().getDataSource().getProperties().get("Connection Descriptor");
                if (cd != layerCd) continue;
                layersUsingThisCD.add(layer);
            }
            catch (NullPointerException e) {
                Logger.error(e);
            }
        }
        return layersUsingThisCD;
    }

    public static interface Listener {
        public void connectionDescriptorAdded(ConnectionDescriptor var1);

        public void connectionDescriptorRemoved(ConnectionDescriptor var1);
    }
}

