/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.JUMPVersion;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.LangUtil;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.util.Timer;
import com.vividsolutions.jump.util.commandline.CommandLine;
import com.vividsolutions.jump.util.commandline.Param;
import com.vividsolutions.jump.util.commandline.ParamSpec;
import com.vividsolutions.jump.util.commandline.ParseException;
import com.vividsolutions.jump.workbench.JUMPConfiguration;
import com.vividsolutions.jump.workbench.JUMPWorkbenchContext;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.WorkbenchProperties;
import com.vividsolutions.jump.workbench.WorkbenchPropertiesFile;
import com.vividsolutions.jump.workbench.driver.DriverManager;
import com.vividsolutions.jump.workbench.plugin.PlugInManager;
import com.vividsolutions.jump.workbench.ui.ErrorDialog;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import com.vividsolutions.jump.workbench.ui.ProgressMonitor;
import com.vividsolutions.jump.workbench.ui.SplashPanelV2;
import com.vividsolutions.jump.workbench.ui.SplashWindow;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.network.ProxySettingsOptionsPanel;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.skin.InstallSkinsPlugIn;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class JUMPWorkbench {
    private static ImageIcon splashImage;
    public static final ArrayList<Image> APP_ICONS;
    public static final ImageIcon APP_ICON;
    public static final String PROPERTIES_OPTION = "properties";
    public static final String DEFAULT_PLUGINS = "default-plugins";
    public static final String EXTS_DIRECTORY_OPTION = "extensions-directory";
    public static final String LIMIT_LOOKUP_OPTION = "limit-ext-lookup";
    public static final String JARS_DIRECTORY_OPTION = "jars-directory";
    public static final String I18N_FILE = "i18n";
    public static final String I18NPREFIX;
    public static final String STATE_OPTION = "state";
    public static String I18N_SETLOCALE;
    private static final Class<?> progressMonitorClass;
    private static JUMPWorkbench workbench;
    private static CommandLine commandLine;
    private final WorkbenchContext context = new JUMPWorkbenchContext(this);
    private WorkbenchFrame frame;
    private final DriverManager driverManager = new DriverManager(this.frame);
    private final WorkbenchProperties properties;
    private final PlugInManager plugInManager;
    private final Blackboard blackboard = new Blackboard();

    public static ImageIcon splashImage() {
        if (splashImage == null) {
            splashImage = IconLoader.icon("splash7.png");
        }
        return splashImage;
    }

    private static ArrayList<Image> appIcons() {
        ArrayList<Image> iconlist = new ArrayList<Image>();
        if (SplashPanelV2.itsThatTimeAgain()) {
            ImageIcon ovl = IconLoader.icon("hat.png");
            iconlist.add(SplashPanelV2.gimmick(SplashPanelV2.gimmick(new ImageIcon(new BufferedImage(14, 14, 2)), ovl, 0.48f, -1, -1), IconLoader.icon("oj_16_bottomright.png"), 1.0f, -2, -2).getImage());
            iconlist.add(SplashPanelV2.gimmick(SplashPanelV2.gimmick(new ImageIcon(new BufferedImage(16, 16, 2)), ovl, 0.54f, -1, -1), IconLoader.icon("oj_16_bottomright.png"), 1.0f, 0, 0).getImage());
            iconlist.add(SplashPanelV2.gimmick(IconLoader.icon("oj_24.png"), ovl, 0.12f, 19, 10).getImage());
            iconlist.add(SplashPanelV2.gimmick(IconLoader.icon("oj_32.png"), ovl, 0.15f, 26, 14).getImage());
            iconlist.add(SplashPanelV2.gimmick(IconLoader.icon("oj_48.png"), ovl, 0.25f, 37, 21).getImage());
            iconlist.add(SplashPanelV2.gimmick(IconLoader.icon("oj_256.png"), ovl, 1.4f, 194, 113).getImage());
        } else {
            iconlist.add(IconLoader.image("oj_kang_14.v2.png"));
            iconlist.add(IconLoader.image("oj_16_Kplain2oj.png"));
            iconlist.add(IconLoader.image("oj_24.png"));
            iconlist.add(IconLoader.image("oj_32.png"));
            iconlist.add(IconLoader.image("oj_48.png"));
            iconlist.add(IconLoader.image("oj_256.png"));
        }
        return iconlist;
    }

    public static void setIcon(Object o) {
        if (o instanceof JFrame) {
            JFrame frame = (JFrame)o;
            try {
                Class[] types = new Class[]{List.class};
                Method method = JFrame.class.getMethod("setIconImages", types);
                Object[] params = new Object[]{APP_ICONS};
                method.invoke((Object)frame, params);
            }
            catch (Exception e) {
                frame.setIconImage(APP_ICON.getImage());
            }
        } else if (o instanceof JInternalFrame) {
            JInternalFrame f = (JInternalFrame)o;
            f.setFrameIcon(JUMPWorkbench.getIcon());
        }
    }

    public static ImageIcon getIcon() {
        return APP_ICON;
    }

    public JUMPWorkbench(String title, final Component s, TaskMonitor monitor) throws Exception {
        this.frame = new WorkbenchFrame(title, this.context);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                s.setVisible(false);
            }
        });
        boolean defaultFileExists = false;
        File defaultFile = null;
        if (commandLine.hasParam(DEFAULT_PLUGINS)) {
            defaultFile = new File(commandLine.getParam(DEFAULT_PLUGINS).getArg(0));
            if (defaultFile.exists()) {
                defaultFileExists = true;
            } else {
                Logger.warn("Default plugins file does not exist: " + defaultFile);
            }
        }
        boolean propertiesFileExists = false;
        File propertiesFile = null;
        if (commandLine.hasParam(PROPERTIES_OPTION)) {
            propertiesFile = new File(commandLine.getParam(PROPERTIES_OPTION).getArg(0));
            if (propertiesFile.exists()) {
                propertiesFileExists = true;
            } else {
                Logger.warn("Properties file does not exist: " + propertiesFile);
            }
        }
        ArrayList<File> files = new ArrayList<File>();
        if (defaultFileExists) {
            files.add(defaultFile);
        }
        if (propertiesFileExists) {
            files.add(propertiesFile);
        }
        this.properties = new WorkbenchPropertiesFile(files, (ErrorHandler)this.frame);
        if (commandLine.hasParam(STATE_OPTION)) {
            File option = new File(commandLine.getParam(STATE_OPTION).getArg(0));
            if (option.isDirectory()) {
                PersistentBlackboardPlugIn.setPersistenceDirectory(option.getPath());
            }
            if (option.isFile()) {
                PersistentBlackboardPlugIn.setFileName(option.getName());
                PersistentBlackboardPlugIn.setPersistenceDirectory(option.getAbsoluteFile().getParent());
            }
        }
        this.plugInManager = new PlugInManager(this.context, monitor);
        Iterator<Param> params = commandLine.getParams();
        while (params.hasNext()) {
            String folder;
            Param param = params.next();
            if (param.getSpec().matches(EXTS_DIRECTORY_OPTION)) {
                folder = param.getArg(0);
                this.plugInManager.addExtensionsFolder(new File(folder));
                continue;
            }
            if (param.getSpec().matches(LIMIT_LOOKUP_OPTION)) {
                String trueFalse = param.getArg(0);
                this.plugInManager.setLimitExtensionLookup(trueFalse.toLowerCase().equals("true"));
                continue;
            }
            if (!param.getSpec().matches(JARS_DIRECTORY_OPTION)) continue;
            folder = param.getArg(0);
            this.plugInManager.addJarsFolder(new File(folder));
        }
        this.driverManager.loadDrivers(this.properties);
        workbench = this;
    }

    public static void main(String[] args) {
        long start = Timer.milliSecondsSince(0L);
        try {
            JUMPWorkbench.parseCommandLine(args);
            if (commandLine.hasParam(I18N_FILE)) {
                I18N_SETLOCALE = commandLine.getParam(I18N_FILE).getArg(0);
                Locale loc = I18N.fromCode(I18N_SETLOCALE);
                I18N.applyToRuntime(loc);
                I18N.setLocale(loc);
            }
            if (System.getProperty("http.agent") == null) {
                System.setProperty("http.agent", I18N.getInstance().get("JUMPWorkbench.jump") + " " + JUMPVersion.CURRENT_VERSION);
            }
            if (commandLine.hasParam("help")) {
                JUMPWorkbench.printProperly(commandLine.printDoc());
                System.exit(0);
            } else if (commandLine.hasParam("version")) {
                JUMPWorkbench.printProperly(I18N.getInstance().get("JUMPWorkbench.jump") + " " + I18N.getInstance().get("ui.AboutDialog.version") + " " + JUMPVersion.CURRENT_VERSION);
                System.exit(0);
            } else if (commandLine.hasParam("print-properties")) {
                JUMPWorkbench.printProperties("args[]=" + Arrays.toString(args));
                System.exit(0);
            }
            if (commandLine.hasParam("verbosity")) {
                Param v = commandLine.getParam("verbosity");
                if (v.getNumArgs() < 1) {
                    JUMPWorkbench.printProperly(I18N.getInstance().get(v.getSpec().getDesc()));
                    System.exit(1);
                }
                Logger.setLevel(v.getArg(0));
            }
            JUMPWorkbench.initLookAndFeel();
            JUMPWorkbench.fixLookAndFeel();
            if (JUMPWorkbench.setFont()) {
                Logger.info("New fonts have been loaded");
            }
            ProgressMonitor progressMonitor = (ProgressMonitor)progressMonitorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            SplashPanelV2 splashPanel = new SplashPanelV2(JUMPWorkbench.splashImage(), I18N.getInstance().get("JUMPWorkbench.version") + " " + JUMPVersion.CURRENT_VERSION);
            splashPanel.addProgressMonitor(progressMonitor);
            JUMPWorkbench.main(I18N.getInstance().get("JUMPWorkbench.jump"), splashPanel, progressMonitor);
            Logger.info("OJ start took " + Timer.secondsSinceString(start) + "s alltogether.");
        }
        catch (Throwable t) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    try {
                        JUMPWorkbench.initLookAndFeel();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorDialog.show(null, StringUtil.toFriendlyName(t.getClass().getSimpleName()), WorkbenchFrame.toMessage(t), StringUtil.stackTrace(t));
                });
            }
            catch (Throwable t2) {
                Logger.error(t2);
            }
            Logger.error(t);
            System.exit(1);
        }
    }

    static void main(String title, JComponent splashComponent, TaskMonitor taskMonitor) throws Exception {
        SplashWindow splashWindow = new SplashWindow(splashComponent);
        splashWindow.setVisible(true);
        taskMonitor.report(I18N.getInstance().get("JUMPWorkbench.status.create"));
        workbench = new JUMPWorkbench(title, splashWindow, taskMonitor);
        taskMonitor.report(I18N.getInstance().get("JUMPWorkbench.status.configure-core"));
        PersistentBlackboardPlugIn persistentBlackboard = new PersistentBlackboardPlugIn();
        persistentBlackboard.initialize(JUMPWorkbench.workbench.context.createPlugInContext());
        new InstallSkinsPlugIn().initialize(JUMPWorkbench.workbench.context.createPlugInContext());
        WorkbenchFrame frame = workbench.getFrame();
        ProxySettingsOptionsPanel.restoreSystemSettings(PersistentBlackboardPlugIn.get(JUMPWorkbench.workbench.context.getWorkbench().getBlackboard()));
        JUMPConfiguration config = new JUMPConfiguration();
        config.setup(JUMPWorkbench.workbench.context);
        taskMonitor.report(I18N.getInstance().get("JUMPWorkbench.status.load-extensions"));
        JUMPWorkbench.workbench.context.getWorkbench().getPlugInManager().load();
        taskMonitor.report(I18N.getInstance().get("JUMPWorkbench.status.initialize-datasources"));
        config.postExtensionInitialization(JUMPWorkbench.workbench.context);
        taskMonitor.report(I18N.getInstance().get("JUMPWorkbench.status.restore-state"));
        frame.restore();
        taskMonitor.report(I18N.getInstance().get("JUMPWorkbench.status.show-workbench"));
        frame.setVisible(true);
        SwingUtilities.invokeLater(() -> frame.getToolBar().reClickSelectedCursorToolButton());
    }

    private static void fixLookAndFeel() {
        UIDefaults defaults = UIManager.getDefaults();
        Font ta_font = (Font)defaults.get("TextArea.font");
        if (ta_font.getSize() < 11) {
            UIManager.put("TextArea.font", ta_font.deriveFont(13.0f));
            Logger.info("Fix text area font size bug.");
        }
    }

    private static void initLookAndFeel() throws Exception {
        if (LangUtil.ifNull(System.getProperty("initLookAndFeel"), "true").toString().equalsIgnoreCase("false")) {
            return;
        }
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("apple.awt.showGrowBox", "true");
        if (UIManager.getLookAndFeel() != null && UIManager.getLookAndFeel().getClass().getName().equals(UIManager.getSystemLookAndFeelClassName())) {
            return;
        }
        String laf = System.getProperty("swing.defaultlaf");
        if (laf == null) {
            laf = UIManager.getSystemLookAndFeelClassName();
        }
        UIManager.setLookAndFeel(laf);
    }

    private static Font[] loadFonts() throws Exception {
        Font font = Font.createFont(0, Class.class.getResource("/language/fonts/code2000.ttf").openStream());
        return new Font[]{font};
    }

    private static boolean setFont() throws Exception {
        String test = I18N.getInstance().get("ui.MenuNames.FILE");
        boolean replaced = false;
        Font font = null;
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            FontUIResource fnew;
            FontUIResource fold;
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource) || (fold = (FontUIResource)value).canDisplayUpTo(test) == -1) continue;
            if (font == null) {
                font = JUMPWorkbench.loadFonts()[0];
            }
            Map<TextAttribute, ?> attrs = fold.getAttributes();
            TextAttribute fam = null;
            for (TextAttribute textAttribute : attrs.keySet()) {
                if (!textAttribute.toString().equals("java.awt.font.TextAttribute(family)")) continue;
                fam = textAttribute;
                break;
            }
            if (fam != null) {
                attrs.remove(fam);
            }
            if ((fnew = new FontUIResource(font.deriveFont(attrs))).canDisplayUpTo(test) != -1) continue;
            UIManager.put(key, fnew);
            replaced = true;
        }
        return replaced;
    }

    public DriverManager getDriverManager() {
        return this.driverManager;
    }

    public WorkbenchProperties getProperties() {
        return this.properties;
    }

    public WorkbenchFrame getFrame() {
        return this.frame;
    }

    public WorkbenchContext getContext() {
        return this.context;
    }

    public static CommandLine getCommandLine() {
        return commandLine;
    }

    public static JUMPWorkbench getInstance() {
        return workbench;
    }

    private static void printProperties(String in) {
        Properties ps = System.getProperties();
        TreeSet<Object> v = new TreeSet<Object>(ps.keySet());
        StringBuilder out = new StringBuilder();
        for (Object key : v) {
            out.append(key).append("=").append(ps.getProperty(key.toString())).append("\n");
        }
        out.append("\n\napplying default lnf");
        try {
            JUMPWorkbench.initLookAndFeel();
            out.append(" - OK\n");
        }
        catch (Exception e) {
            out.append("\n\n").append(StringUtil.stackTrace(e)).append("\n\n");
        }
        out.append("\n\nUIDefaults\n\n");
        UIDefaults defaults = UIManager.getDefaults();
        for (Map.Entry entry : defaults.entrySet().stream().sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList())) {
            out.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        JUMPWorkbench.printProperly(in + "\n" + out.toString());
    }

    private static void parseCommandLine(String[] args) {
        commandLine = new CommandLine();
        commandLine.addParamSpec(new ParamSpec(PROPERTIES_OPTION, 1, "workbench property file (activate extensions and plugins)"));
        commandLine.addParamSpec(new ParamSpec(DEFAULT_PLUGINS, 1, "property file (default OpenJUMP extensions and plugins)"));
        commandLine.addParamSpec(new ParamSpec(EXTS_DIRECTORY_OPTION, 1, "extensions folder location, can be defined multiple times\n default './lib/ext'"));
        commandLine.addParamSpec(new ParamSpec(LIMIT_LOOKUP_OPTION, 1, "limit extension class lookup to jars in extension folders' root"));
        commandLine.addParamSpec(new ParamSpec(JARS_DIRECTORY_OPTION, 1, "adds jar files recursively to classpath, for development"));
        commandLine.addParamSpec(new ParamSpec(I18N_FILE, 1, "switch language and number formatting by overriding system's default locale setting, e.g. en_US"));
        commandLine.addParamSpec(new ParamSpec(STATE_OPTION, 1, "where to save workbench settings, default OJ_HOME folder or USER_HOME/.openjump/"));
        commandLine.addParamSpec(new ParamSpec(new String[]{"v", "verbosity"}, 1, "logging verbosity, either: off, error, warn, info, debug, trace, all"));
        commandLine.addParamSpec(new ParamSpec(new String[]{"h", "help", "-help"}, 0, "show this help"));
        commandLine.addParamSpec(new ParamSpec(new String[]{"version", "-version"}, 0, "show version information"));
        commandLine.addParamSpec(new ParamSpec(new String[]{"p", "print-properties"}, 0, "print a list of runtime properties"));
        try {
            commandLine.parse(args);
        }
        catch (ParseException e) {
            JUMPWorkbench.printProperly(commandLine.printDoc(e));
            System.exit(1);
        }
    }

    public PlugInManager getPlugInManager() {
        return this.plugInManager;
    }

    public Blackboard getBlackboard() {
        return this.blackboard;
    }

    private static void printProperly(String text) {
        try {
            JUMPWorkbench.initLookAndFeel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        JTextArea textArea = new JTextArea();
        JScrollPane scrollPane = new JScrollPane(textArea);
        textArea.setEditable(false);
        textArea.setText(text);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        JOptionPane pane = new JOptionPane(scrollPane, 1, -1, IconLoader.icon("oj_32.png"));
        JDialog d = pane.createDialog(I18N.getInstance().get("JUMPWorkbench.jump"));
        ArrayList<Image> l = new ArrayList<Image>(APP_ICONS);
        l.add(0, IconLoader.image("information_16x16.png"));
        d.setIconImages(l);
        textArea.setBackground(new JLabel().getBackground());
        d.setResizable(true);
        d.pack();
        d.setVisible(true);
    }

    static {
        APP_ICONS = JUMPWorkbench.appIcons();
        APP_ICON = new ImageIcon(APP_ICONS.get(0));
        I18NPREFIX = JUMPWorkbench.class.getPackage().getName() + ".";
        I18N_SETLOCALE = "";
        progressMonitorClass = SingleLineProgressMonitor.class;
    }

    private static class SingleLineProgressMonitor
    extends ProgressMonitor {
        public SingleLineProgressMonitor() {
            super(new JLabel(" "));
            this.getComponent().setFont(this.getComponent().getFont().deriveFont(1));
            ((JLabel)this.getComponent()).setHorizontalAlignment(2);
        }

        @Override
        protected void addText(String s) {
            ((JLabel)this.getComponent()).setText(s);
        }
    }
}

