/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util.commandline;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.commandline.Param;
import com.vividsolutions.jump.util.commandline.ParamSpec;
import com.vividsolutions.jump.util.commandline.ParseException;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

public class CommandLine {
    private final Vector<ParamSpec> paramSpecs = new Vector();
    private final Vector<Param> params = new Vector();
    private final Vector<String> arguments = new Vector();
    private char optionChar = (char)45;

    public CommandLine() {
    }

    public CommandLine(char optionCh) {
        this.optionChar = optionCh;
    }

    public void addParamSpec(ParamSpec paramSpec) {
        this.paramSpecs.add(paramSpec);
    }

    private ParamSpec getParamSpec(String name) {
        for (ParamSpec paramSpec : this.paramSpecs) {
            if (!paramSpec.matches(name)) continue;
            return paramSpec;
        }
        return null;
    }

    public Param getParam(String name) {
        ParamSpec spec = this.getParamSpec(name);
        return spec != null ? spec.getParam() : null;
    }

    public Iterator<ParamSpec> getParamSpecs() {
        return this.paramSpecs.iterator();
    }

    public Iterator<Param> getParams() {
        return this.params.iterator();
    }

    public Iterator<String> getArguments() {
        return this.arguments.iterator();
    }

    public boolean hasParam(String name) {
        ParamSpec spec = this.getParamSpec(name);
        return spec != null && spec.hasArguments();
    }

    public Iterator<String> getParamsArguments(String name) {
        ParamSpec spec = this.getParamSpec(name);
        return spec != null ? spec.getAllArguments() : Collections.emptyIterator();
    }

    public String printDoc() {
        return this.printDoc(null);
    }

    public String printDoc(Exception e) {
        StringBuilder out = new StringBuilder();
        if (e != null) {
            out.append("Error:\n  ").append(e.getMessage()).append("\n\n");
        }
        out.append("Syntax:\n  oj_starter [-parameter [<argument>]]... [<project_file>]... [<data_file>]...\n\nParameters:\n");
        for (ParamSpec paramSpec : this.paramSpecs) {
            String names = "";
            for (String name : paramSpec.getNames()) {
                names = names.isEmpty() ? this.optionChar + name : names + ", " + this.optionChar + name;
            }
            out.append("  ").append(names).append("\n    ").append(paramSpec.getDesc()).append("\n");
        }
        return out.toString();
    }

    public void parse(String[] args) throws ParseException {
        if (this.params.size() > 0 || this.arguments.size() > 0) {
            throw new ParseException("CommandLine already contains parsed parameters or arguments!");
        }
        int i = 0;
        while (i < args.length) {
            ParamSpec paramSpec;
            if (args[i].charAt(0) == this.optionChar && (paramSpec = this.getParamSpec(args[i].substring(1))) != null) {
                Param param = paramSpec.addParam(this.splitParamArguments(args, i));
                i += 1 + param.getNumArgs();
                this.params.add(param);
                continue;
            }
            if (new File(args[i]).exists()) {
                this.arguments.add(args[i]);
                ++i;
                continue;
            }
            throw new ParseException(I18N.getInstance().get(this.getClass().getName() + ".unknown-option-or-file-not-found-{0}", args[i]));
        }
    }

    private Vector<String> splitParamArguments(String[] args, int i) {
        String param;
        Vector<String> params = new Vector<String>();
        for (int j = ++i; j < args.length && ((param = args[j]).charAt(0) != this.optionChar || this.getParamSpec(param.substring(1)) == null); ++j) {
            params.add(param);
        }
        return params;
    }
}

