/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtil {
    public static final String I18NPREFIX = FileUtil.class.getName() + ".";
    public static final String PREFIX = "openjump";
    public static final String SUFFIX = ".tmp";

    public static List<String> getContents(String filename) throws IOException {
        return FileUtil.getContents(new FileInputStream(filename));
    }

    public static List<String> getContents(String filename, String encoding) throws IOException {
        return FileUtil.getContents(new FileInputStream(filename), encoding);
    }

    public static List<String> getContents(URI uri) throws IOException {
        return FileUtil.getContents(CompressedFile.openFile(uri));
    }

    public static List<String> getContents(InputStream inputStream) throws IOException {
        return FileUtil.getContents(inputStream, Charset.defaultCharset().name());
    }

    public static List<String> getContents(InputStream inputStream, String encoding) throws IOException {
        ArrayList<String> contents = new ArrayList<String>();
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, encoding);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String line;
            while (null != (line = bufferedReader.readLine())) {
                contents.add(line);
            }
        }
        return contents;
    }

    public static void setContents(String filename, String contents) throws IOException {
        FileUtil.setContents(filename, contents, Charset.defaultCharset().name());
    }

    public static void setContents(String filename, List<String> lines) throws IOException {
        FileUtil.setContents(filename, lines, Charset.defaultCharset().name());
    }

    public static void setContents(String filename, String contents, String encoding) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(contents);
        FileUtil.setContents(filename, lines, encoding);
    }

    public static void setContents(String filename, List<String> lines, String encoding) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(filename);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, encoding);){
            String lineSep = System.lineSeparator();
            Iterator<String> it = lines.iterator();
            while (it.hasNext()) {
                osw.write(it.next());
                if (!it.hasNext()) continue;
                osw.write(lineSep);
            }
        }
    }

    public static void zip(Collection<File> files, File zipFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             ZipOutputStream zos = new ZipOutputStream(bos);){
            for (File file : files) {
                zos.putNextEntry(new ZipEntry(file.getName()));
                try (FileInputStream fis = new FileInputStream(file);
                     BufferedInputStream bis = new BufferedInputStream(fis);){
                    int j;
                    while ((j = bis.read()) != -1) {
                        zos.write(j);
                    }
                }
            }
        }
    }

    public static String getExtension(String s) {
        String ext = "";
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String getExtension(File f) {
        String s = f.getName();
        return FileUtil.getExtension(s);
    }

    public static File addExtensionIfNone(File file, String extension) {
        if (FileUtil.getExtension(file).length() > 0) {
            return file;
        }
        String path = file.getAbsolutePath();
        if (!path.endsWith(".")) {
            path = path + ".";
        }
        path = path + extension;
        return new File(path);
    }

    public static File removeExtensionIfAny(File file) {
        int i = file.getName().lastIndexOf(46);
        if (i > 0) {
            String path = file.getAbsolutePath();
            path = path.substring(0, path.length() - file.getName().length() + i);
            return new File(path);
        }
        return file;
    }

    public static String getFileNameFromLayerName(String layerName) {
        return layerName.replaceAll("[/\\\\\\?%\\*:\\|\"<> ]+", "_").replaceAll("^_", "").replaceAll("_$", "");
    }

    public static void close(Closeable is) {
        try {
            if (is instanceof Closeable) {
                is.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static File copyInputStreamToTempFile(InputStream in, String prefix, String suffix, TaskMonitor monitor) throws IOException {
        int r;
        File tempFile = File.createTempFile(prefix != null ? prefix : PREFIX, suffix != null ? suffix : SUFFIX);
        tempFile.deleteOnExit();
        BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(tempFile));
        long counter = 0L;
        byte[] b = new byte[1024];
        long startCounter = counter;
        long stopCounter = counter;
        long startTime = System.currentTimeMillis();
        int i = 0;
        float speed = 0.0f;
        while ((r = in.read(b)) != -1) {
            counter += (long)r;
            if (++i % 1023 == 0) {
                long stopTime = System.currentTimeMillis();
                stopCounter = counter;
                speed = (float)(stopCounter - startCounter) / 1024.0f / 1024.0f / ((float)(stopTime - startTime) / 1000.0f);
            }
            if (monitor != null) {
                monitor.report(I18N.getInstance().get(I18NPREFIX + "receiving-{0}-MiB-(at-{1}-{2})", String.format("%.2f", Float.valueOf((float)counter / 1024.0f / 1024.0f)), String.format("%.2f", Float.valueOf(speed < 1.0f ? speed * 1024.0f : speed)), speed < 1.0f ? I18N.getInstance().get(I18NPREFIX + "KiB/s") : I18N.getInstance().get(I18NPREFIX + "MiB/s")));
            }
            fout.write(b, 0, r);
            if (i < 1023) continue;
            startTime = System.currentTimeMillis();
            startCounter = counter + 1L;
            i = 0;
        }
        in.close();
        fout.close();
        return tempFile;
    }

    public static File findFileInClassPath(String fileOrFolder) {
        File f = null;
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource(fileOrFolder);
            f = new File(url.toURI());
        }
        catch (Exception e) {
            Logger.debug("Cannot resolve '" + fileOrFolder + "' in classpath.", e);
        }
        return f;
    }
}

