/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.IndexedFeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.tools.AttributeMapping;
import com.vividsolutions.jump.workbench.Logger;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.overlayng.OverlayNGRobust;

public class OverlayEngine {
    private boolean splittingGeometryCollections = true;
    private boolean allowingPolygonsOnly = true;

    public FeatureCollection overlay(FeatureCollection a, FeatureCollection b, TaskMonitor monitor) {
        return this.overlay(a, b, new AttributeMapping(a.getFeatureSchema(), b.getFeatureSchema()), monitor);
    }

    public FeatureCollection overlay(FeatureCollection a, FeatureCollection b, AttributeMapping mapping, TaskMonitor monitor) {
        monitor.allowCancellationRequests();
        monitor.report(I18N.getInstance().get("tools.OverlayEngine.indexing-second-feature-collection"));
        IndexedFeatureCollection indexedB = new IndexedFeatureCollection(b);
        monitor.report(I18N.getInstance().get("tools.OverlayEngine.overlaying-feature-collections"));
        FeatureDataset overlay = new FeatureDataset(mapping.createSchema("GEOMETRY"));
        List<Feature> aFeatures = a.getFeatures();
        int count = 0;
        for (Feature aFeature : aFeatures) {
            if (monitor.isCancelRequested()) break;
            for (Feature bFeature : indexedB.query(aFeature.getGeometry().getEnvelopeInternal())) {
                if (monitor.isCancelRequested()) break;
                this.addIntersection(aFeature, bFeature, mapping, overlay, monitor);
            }
            monitor.report(count++, a.size(), "features");
        }
        return overlay;
    }

    private void addIntersection(Feature a, Feature b, AttributeMapping mapping, FeatureCollection overlay, TaskMonitor monitor) {
        if (!a.getGeometry().getEnvelope().intersects(b.getGeometry().getEnvelope())) {
            return;
        }
        Geometry intersection = null;
        try {
            intersection = OverlayNGRobust.overlay((Geometry)a.getGeometry(), (Geometry)b.getGeometry(), (int)1);
        }
        catch (Exception ex) {
            monitor.report(ex);
            Logger.error(a.getGeometry().toString());
            Logger.error(b.getGeometry().toString());
        }
        if (intersection == null || intersection.isEmpty()) {
            return;
        }
        this.addFeature(intersection, overlay, mapping, a, b);
    }

    private void addFeature(Geometry intersection, FeatureCollection overlay, AttributeMapping mapping, Feature a, Feature b) {
        if (this.splittingGeometryCollections && intersection instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)intersection;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                this.addFeature(gc.getGeometryN(i), overlay, mapping, a, b);
            }
            return;
        }
        if (this.allowingPolygonsOnly && !(intersection instanceof Polygon) && !(intersection instanceof MultiPolygon)) {
            return;
        }
        BasicFeature feature = new BasicFeature(overlay.getFeatureSchema());
        mapping.transferAttributes(a, b, feature);
        feature.setGeometry(intersection);
        overlay.add(feature);
    }

    public void setSplittingGeometryCollections(boolean splittingGeometryCollections) {
        this.splittingGeometryCollections = splittingGeometryCollections;
    }

    public void setAllowingPolygonsOnly(boolean allowingPolygonsOnly) {
        this.allowingPolygonsOnly = allowingPolygonsOnly;
    }
}

