/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.qa.diff;

import com.vividsolutions.jump.algorithm.VertexHausdorffDistance;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.qa.diff.SegmentIndex;
import com.vividsolutions.jump.util.CoordinateArrays;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;

public class UniqueSegmentsWithToleranceFinder {
    private final FeatureCollection queryFC;
    private final SegmentIndex segIndex;
    private final List<LineSegment> resultSegs = new ArrayList<LineSegment>();
    private final Envelope queryEnv = new Envelope();

    public static double maximumDistance(LineSegment seg1, LineSegment seg2) {
        double dist;
        double maxDist = dist = seg1.p0.distance(seg2.p0);
        dist = seg1.p0.distance(seg2.p1);
        if (dist > maxDist) {
            maxDist = dist;
        }
        if ((dist = seg1.p1.distance(seg2.p0)) > maxDist) {
            maxDist = dist;
        }
        if ((dist = seg1.p1.distance(seg2.p1)) > maxDist) {
            maxDist = dist;
        }
        return maxDist;
    }

    public UniqueSegmentsWithToleranceFinder(FeatureCollection fc0, FeatureCollection fc1) {
        this.queryFC = fc0;
        this.segIndex = new SegmentIndex(fc1);
    }

    public List<LineSegment> findUniqueSegments(double tolerance) {
        for (Feature f : this.queryFC.getFeatures()) {
            Geometry geom = f.getGeometry();
            this.findUniqueSegments(geom, tolerance);
        }
        return this.resultSegs;
    }

    public void findUniqueSegments(Geometry geom, double tolerance) {
        List<Coordinate[]> coordArrays = CoordinateArrays.toCoordinateArrays(geom, false);
        for (Coordinate[] coordArray : coordArrays) {
            this.findUniqueSegments(coordArray, tolerance);
        }
    }

    public void findUniqueSegments(Coordinate[] coord, double tolerance) {
        for (int i = 0; i < coord.length - 1; ++i) {
            LineSegment querySeg = new LineSegment(coord[i], coord[i + 1]);
            querySeg.normalize();
            this.queryEnv.init(querySeg.p0, querySeg.p1);
            Envelope queryEnvExp = EnvelopeUtil.expand(this.queryEnv, tolerance);
            List testSegs = this.segIndex.query(queryEnvExp);
            if (this.hasSegmentWithinTolerance(querySeg, testSegs, tolerance)) continue;
            this.resultSegs.add(querySeg);
        }
    }

    private boolean hasSegmentWithinTolerance(LineSegment querySeg, List testSegs, double tolerance) {
        for (LineSegment testSeg : testSegs) {
            VertexHausdorffDistance vhd = new VertexHausdorffDistance(querySeg, testSeg);
            if (!(vhd.distance() < tolerance)) continue;
            return true;
        }
        return false;
    }
}

