/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.edit;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.operation.overlay.snap.GeometrySnapper;

public class GeometrySnapperPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private static final I18N i18n = I18N.getInstance();
    private static final String LAYER = i18n.get("ui.GenericNames.LAYER");
    private static final String REF_LAYER = i18n.get("ui.GenericNames.REFERENCE_LAYER");
    private static final String TOLERANCE = i18n.get("ui.plugin.analysis.GeometrySnapperPlugIn.tolerance");
    private String layer;
    private String refLayer;
    private double tolerance = 1.0E-12;

    @Override
    public String getName() {
        return i18n.get("ui.plugin.analysis.GeometrySnapperPlugIn.Geometry-Snapper");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY}, this.getName() + "...", false, null, GeometrySnapperPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        monitor.report(i18n.get("ui.plugin.analysis.GeometrySnapperPlugIn.snapping"));
        FeatureCollectionWrapper fc = context.getLayerManager().getLayer(this.layer).getFeatureCollectionWrapper();
        STRtree index = new STRtree();
        for (Feature f : context.getLayerManager().getLayer(this.refLayer).getFeatureCollectionWrapper().getFeatures()) {
            Geometry geometry = f.getGeometry();
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                Geometry g = geometry.getGeometryN(i);
                index.insert(g.getEnvelopeInternal(), (Object)g);
            }
        }
        EditTransaction transaction = new EditTransaction(new ArrayList<Feature>(), this.getName(), context.getLayerManager().getLayer(this.layer), this.isRollingBackInvalidEdits(context), true, context.getWorkbenchFrame());
        for (Feature feature : fc.getFeatures()) {
            Envelope env = feature.getGeometry().getEnvelopeInternal();
            env.expandBy(this.tolerance);
            Geometry refGeom = feature.getGeometry().getFactory().buildGeometry((Collection)index.query(env));
            Geometry newGeom = new GeometrySnapper(feature.getGeometry()).snapTo(refGeom, this.tolerance);
            if (newGeom.equalsExact(feature.getGeometry())) continue;
            transaction.modifyFeatureGeometry(feature, newGeom);
        }
        transaction.commit();
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        Layer layer1;
        dialog.setSideBarDescription(i18n.get("ui.plugin.analysis.GeometrySnapperPlugIn.description"));
        Layer layer = layer1 = this.layer == null || context.getLayerManager().getLayer(this.layer) == null ? context.getCandidateLayer(0) : context.getLayerManager().getLayer(this.layer);
        Layer layer2 = this.refLayer == null || context.getLayerManager().getLayer(this.refLayer) == null ? (context.getLayerManager().getLayers().size() > 1 ? context.getCandidateLayer(1) : context.getCandidateLayer(0)) : context.getLayerManager().getLayer(this.layer);
        dialog.addLayerComboBox(LAYER, layer1, context.getLayerManager());
        dialog.addLayerComboBox(REF_LAYER, layer2, context.getLayerManager());
        dialog.addDoubleField(TOLERANCE, this.tolerance, 12);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer = dialog.getLayer(LAYER).getName();
        this.refLayer = dialog.getLayer(REF_LAYER).getName();
        this.tolerance = dialog.getDouble(TOLERANCE);
    }
}

