/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.edit;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.plugin.edit.AffineTransControlPointExtracter;
import com.vividsolutions.jump.plugin.edit.TransRotScaleBuilder;
import com.vividsolutions.jump.plugin.edit.TriPointTransRotScaleBuilder;
import com.vividsolutions.jump.plugin.edit.TwoPointTransRotScaleBuilder;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.SaveFileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.imagery.ImageryLayerDataset;
import com.vividsolutions.jump.workbench.imagery.ReferencedImagesLayer;
import com.vividsolutions.jump.workbench.imagery.geoimg.GeoImageFactoryFileLayerLoader;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.registry.Registry;
import com.vividsolutions.jump.workbench.ui.DualPaneInputDialog;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.imagery.ImageryUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PerspectiveTransform;
import javax.media.jai.RenderedOp;
import javax.media.jai.WarpPerspective;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.openjump.core.rasterimage.WorldFileHandler;
import org.openjump.core.ui.io.file.FileLayerLoader;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;

public class AffineTransformationPlugIn
extends AbstractThreadedUiPlugIn {
    private DualPaneInputDialog dialog;
    private String layerName;
    private double originX = 0.0;
    private double originY = 0.0;
    private double transX = 0.0;
    private double transY = 0.0;
    private double scaleX = 1.0;
    private double scaleY = 1.0;
    private double shearX = 0.0;
    private double shearY = 0.0;
    private double rotationAngle = 0.0;
    private static final String FILE_CHOOSER_DIRECTORY_KEY = SaveFileDataSourceQueryChooser.class.getName() + " - FILE CHOOSER DIRECTORY";
    private static final String IMAGE_OPTIONS = I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.image-options");
    private static final String FORCE_IMAGEWARP = I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.force-image-warp");
    private static final String RESIZE_IMAGE = I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.resize-image");
    private static final String ALLOWED_IMAGES = I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.allowed-files");
    private static final String SAVE = I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.save");
    private static final String RESIZE_IMAGE_TOOLTIP = I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.resize-image-tooltip");
    JFileChooser fileChooser = GUIUtil.createJFileChooserWithOverwritePrompting();
    private String LAYER;
    private String ORIGIN_X;
    private String ORIGIN_Y;
    private String TRANS_DX;
    private String TRANS_DY;
    private String SCALE_X;
    private String SCALE_Y;
    private String ROTATE_ANGLE;
    private String SHEAR_X;
    private String SHEAR_Y;
    private String SRC_BASE_LAYER;
    private String DEST_BASE_LAYER;
    private JTextField originXField;
    private JTextField originYField;
    private JTextField transXField;
    private JTextField transYField;
    private JTextField scaleXField;
    private JTextField scaleYField;
    private JTextField shearXField;
    private JTextField shearYField;
    private JTextField rotateAngleField;

    @Override
    public String getName() {
        return I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Affine-Transformation");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_WARP}, this.getName() + "...", false, null, this.createEnableCheck(context.getWorkbenchContext()), -1);
    }

    public EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.dialog = new DualPaneInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow(this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    public void transform() {
        AffineTransformation trans = new AffineTransformation();
        trans.translate(-this.originX, -this.originY);
        if (this.scaleX != 1.0 || this.scaleY != 1.0) {
            trans.scale(this.scaleX, this.scaleY);
        }
        if (this.shearX != 0.0 || this.shearY != 0.0) {
            trans.shear(this.shearX, this.shearY);
        }
        if (this.rotationAngle != 0.0) {
            trans.rotate(Math.toRadians(this.rotationAngle));
        }
        AffineTransformation fromOriginTrans = AffineTransformation.translationInstance((double)this.originX, (double)this.originY);
        trans.compose(fromOriginTrans);
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        monitor.report("Transforming layer...");
        this.reportNothingToUndoYet(context);
        AffineTransformation trans = new AffineTransformation();
        trans.translate(-this.originX, -this.originY);
        if (this.scaleX != 1.0 || this.scaleY != 1.0) {
            trans.scale(this.scaleX, this.scaleY);
        }
        if (this.shearX != 0.0 || this.shearY != 0.0) {
            trans.shear(this.shearX, this.shearY);
        }
        if (this.rotationAngle != 0.0) {
            trans.rotate(Math.toRadians(this.rotationAngle));
        }
        AffineTransformation fromOriginTrans = AffineTransformation.translationInstance((double)this.originX, (double)this.originY);
        trans.compose(fromOriginTrans);
        trans.translate(this.transX, this.transY);
        Layer layer = context.getLayerManager().getLayer(this.layerName);
        if (this.dialog.getBoolean(FORCE_IMAGEWARP) & ReferencedImagesLayer.class.isInstance(layer)) {
            this.forceImageToWarp(context, trans);
        }
        FeatureCollectionWrapper fc = layer.getFeatureCollectionWrapper();
        FeatureDataset resultFC = new FeatureDataset(fc.getFeatureSchema());
        for (Feature f : fc) {
            Feature f2 = f.clone(true);
            f2.getGeometry().apply((CoordinateSequenceFilter)trans);
            f2.getGeometry().geometryChanged();
            resultFC.add(f2);
        }
        this.createLayers(context, resultFC);
    }

    private void createLayers(PlugInContext context, FeatureCollection transFC) {
        Layer lyr = context.addLayer(StandardCategoryNames.RESULT, I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Affine") + this.layerName, transFC);
        lyr.fireAppearanceChanged();
    }

    private void setDialogValues(DualPaneInputDialog dialog, PlugInContext context) {
        String ORIGIN = I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Anchor-Point");
        String ORIGIN_FROM_LL = I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Set-to-Lower-Left");
        String ORIGIN_FROM_MIDPOINT = I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Set-to-Midpoint");
        this.LAYER = GenericNames.LAYER;
        this.ORIGIN_X = "X";
        this.ORIGIN_Y = "Y";
        this.TRANS_DX = "DX";
        this.TRANS_DY = "DY";
        this.SCALE_X = I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.X-Factor");
        this.SCALE_Y = I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Y-Factor");
        this.ROTATE_ANGLE = GenericNames.ANGLE;
        this.SHEAR_X = I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.X-Shear");
        this.SHEAR_Y = I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Y-Shear");
        this.SRC_BASE_LAYER = GenericNames.SOURCE_LAYER;
        this.DEST_BASE_LAYER = GenericNames.TARGET_LAYER;
        String BASELINE_BUTTON = I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Compute-Parameters");
        dialog.setSideBarImage(new ImageIcon(this.getClass().getResource("AffineTransformation.png")));
        dialog.setSideBarDescription(I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Applies-an-Affine-Transformation-to-all-features-in-a-layer") + "  " + I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.The-transformation-is-specified-by-a-combination-of-scaling-rotation-shearing-and-translation") + "  " + I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Transformation-parameters-may-be-computed-from-two-layers-containing-baseline-vectors"));
        dialog.addLayerComboBox(this.LAYER, context.getCandidateLayer(0), context.getLayerManager());
        dialog.addLabel("<HTML><B>" + ORIGIN + "</B></HTML>");
        this.originXField = dialog.addDoubleField(this.ORIGIN_X, this.originX, 20, I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Anchor-Point-X-value"));
        this.originYField = dialog.addDoubleField(this.ORIGIN_Y, this.originY, 20, I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Anchor-Point-Y-value"));
        JButton buttonOriginLL = dialog.addButton(ORIGIN_FROM_LL);
        buttonOriginLL.addActionListener(new OriginLLListener(true));
        JButton buttonOriginMid = dialog.addButton(ORIGIN_FROM_MIDPOINT);
        buttonOriginMid.addActionListener(new OriginLLListener(false));
        dialog.addLabel("<HTML><B>" + I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Scaling") + "</B></HTML>");
        this.scaleXField = dialog.addDoubleField(this.SCALE_X, this.scaleX, 20, I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Scale-X-Factor"));
        this.scaleYField = dialog.addDoubleField(this.SCALE_Y, this.scaleY, 20, I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Scale-Y-Factor"));
        dialog.addLabel("<HTML><B>" + I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Rotation") + "</B></HTML>");
        this.rotateAngleField = dialog.addDoubleField(this.ROTATE_ANGLE, this.rotationAngle, 20, I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Rotation-Angle-in-degrees"));
        dialog.addLabel("<HTML><B>" + I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Shearing") + "</B></HTML>");
        this.shearXField = dialog.addDoubleField(this.SHEAR_X, this.shearX, 20, I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Shear-X-Factor"));
        this.shearYField = dialog.addDoubleField(this.SHEAR_Y, this.shearY, 20, I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Shear-Y-Factor"));
        dialog.addLabel("<HTML><B>" + I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Translation") + "</B></HTML>");
        this.transXField = dialog.addDoubleField(this.TRANS_DX, this.transX, 20, I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Translation-X-value"));
        this.transYField = dialog.addDoubleField(this.TRANS_DY, this.transY, 20, I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Translation-Y-value"));
        dialog.setRightPane();
        JButton setIdentityButton = dialog.addButton(I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Set-to-Identity"));
        setIdentityButton.addActionListener(new SetIdentityListener());
        dialog.addSeparator();
        dialog.addLabel("<HTML><B>" + I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Baseline-Vectors") + "</B></HTML>");
        dialog.addLayerComboBox(this.SRC_BASE_LAYER, context.getLayerManager().getLayer(0), context.getLayerManager());
        dialog.addLayerComboBox(this.DEST_BASE_LAYER, context.getLayerManager().getLayer(0), context.getLayerManager());
        JButton buttonParam = dialog.addButton(BASELINE_BUTTON);
        buttonParam.addActionListener(new UpdateParamListener());
        dialog.addSeparator();
        dialog.addLabel("<HTML><B>" + IMAGE_OPTIONS + "</B></HTML>");
        dialog.addCheckBox(FORCE_IMAGEWARP, false);
        dialog.getCheckBox(FORCE_IMAGEWARP).setToolTipText(ALLOWED_IMAGES);
        dialog.addCheckBox(RESIZE_IMAGE, false);
        dialog.getCheckBox(RESIZE_IMAGE).setToolTipText(RESIZE_IMAGE_TOOLTIP);
        dialog.addRow(new JPanel());
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layerName = dialog.getLayer(this.LAYER).getName();
        this.originX = dialog.getDouble(this.ORIGIN_X);
        this.originY = dialog.getDouble(this.ORIGIN_Y);
        this.transX = dialog.getDouble(this.TRANS_DX);
        this.transY = dialog.getDouble(this.TRANS_DY);
        this.scaleX = dialog.getDouble(this.SCALE_X);
        this.scaleY = dialog.getDouble(this.SCALE_Y);
        this.shearX = dialog.getDouble(this.SHEAR_X);
        this.shearY = dialog.getDouble(this.SHEAR_Y);
        this.rotationAngle = dialog.getDouble(this.ROTATE_ANGLE);
    }

    private void updateOriginLL(boolean isLowerLeft) {
        Layer lyr = this.dialog.getLayer(this.LAYER);
        FeatureCollectionWrapper fc = lyr.getFeatureCollectionWrapper();
        Envelope env = fc.getEnvelope();
        double x = env.getMinX();
        double y = env.getMinY();
        if (!isLowerLeft) {
            x = (env.getMinX() + env.getMaxX()) / 2.0;
            y = (env.getMinY() + env.getMaxY()) / 2.0;
        }
        this.originXField.setText(x + "");
        this.originYField.setText(y + "");
    }

    private String updateParams() {
        FeatureCollectionWrapper fcDest;
        Layer layerSrc = this.dialog.getLayer(this.SRC_BASE_LAYER);
        Layer layerDest = this.dialog.getLayer(this.DEST_BASE_LAYER);
        FeatureCollectionWrapper fcSrc = layerSrc.getFeatureCollectionWrapper();
        AffineTransControlPointExtracter controlPtExtracter = new AffineTransControlPointExtracter(fcSrc, fcDest = layerDest.getFeatureCollectionWrapper());
        if (controlPtExtracter.getInputType() == 0) {
            String parseErrMsg = controlPtExtracter.getParseErrorMessage();
            return parseErrMsg;
        }
        Coordinate[] srcPts = controlPtExtracter.getSrcControlPoints();
        Coordinate[] destPts = controlPtExtracter.getDestControlPoints();
        TransRotScaleBuilder trsBuilder = null;
        switch (srcPts.length) {
            case 2: {
                trsBuilder = new TwoPointTransRotScaleBuilder(srcPts, destPts);
                break;
            }
            case 3: {
                trsBuilder = new TriPointTransRotScaleBuilder(srcPts, destPts);
            }
        }
        if (trsBuilder != null) {
            this.updateParams(trsBuilder);
        }
        return null;
    }

    private void updateParams(TransRotScaleBuilder trsBuilder) {
        this.originXField.setText(trsBuilder.getOriginX() + "");
        this.originYField.setText(trsBuilder.getOriginY() + "");
        this.scaleXField.setText(trsBuilder.getScaleX() + "");
        this.scaleYField.setText(trsBuilder.getScaleY() + "");
        this.transXField.setText(trsBuilder.getTranslateX() + "");
        this.transYField.setText(trsBuilder.getTranslateY() + "");
        this.rotateAngleField.setText(trsBuilder.getRotationAngle() + "");
    }

    private void setToIdentity() {
        this.scaleXField.setText("1.0");
        this.scaleYField.setText("1.0");
        this.shearXField.setText("0.0");
        this.shearYField.setText("0.0");
        this.transXField.setText("0.0");
        this.transYField.setText("0.0");
        this.rotateAngleField.setText("0.0");
    }

    public void forceImageToWarp(PlugInContext context, AffineTransformation trans) throws Exception {
        try {
            this.fileChooser.setDialogTitle(SAVE);
            if (PersistentBlackboardPlugIn.get(context.getWorkbenchContext()).get(FILE_CHOOSER_DIRECTORY_KEY) != null) {
                this.fileChooser.setCurrentDirectory(new File((String)PersistentBlackboardPlugIn.get(context.getWorkbenchContext()).get(FILE_CHOOSER_DIRECTORY_KEY)));
            }
            File outFile = null;
            int option = this.fileChooser.showSaveDialog(context.getWorkbenchFrame());
            if (option == 0) {
                outFile = this.fileChooser.getSelectedFile();
                String filePath = outFile.getAbsolutePath();
                outFile = new File(filePath + ".png");
                Layer lyr = context.getLayerManager().getLayer(this.layerName);
                Envelope inEnvelope = new Envelope();
                BufferedImage InImageBuffer = ImageryUtils.getBufferFromReferenceImageLayer(lyr);
                InImageBuffer = ImageryUtils.addAlphaChannel(InImageBuffer);
                if (this.dialog.getBoolean(RESIZE_IMAGE)) {
                    InImageBuffer = ImageryUtils.resizeImage(InImageBuffer, InImageBuffer.getWidth() / 2, InImageBuffer.getHeight() / 2);
                }
                inEnvelope.expandToInclude(lyr.getFeatureCollectionWrapper().getEnvelope());
                Point P0 = new GeometryFactory().createPoint(new Coordinate(inEnvelope.getMinX(), inEnvelope.getMinY()));
                Point P1 = new GeometryFactory().createPoint(new Coordinate(inEnvelope.getMaxX(), inEnvelope.getMinY()));
                Point P2 = new GeometryFactory().createPoint(new Coordinate(inEnvelope.getMaxX(), inEnvelope.getMaxY()));
                Point P3 = new GeometryFactory().createPoint(new Coordinate(inEnvelope.getMinX(), inEnvelope.getMaxY()));
                Geometry P0_ = trans.transform((Geometry)P0);
                Geometry P1_ = trans.transform((Geometry)P1);
                Geometry P2_ = trans.transform((Geometry)P2);
                Geometry P3_ = trans.transform((Geometry)P3);
                WarpPerspective warp = new WarpPerspective(PerspectiveTransform.getQuadToQuad((double)P0.getCoordinate().x, (double)P0.getCoordinate().y, (double)P1.getCoordinate().x, (double)P1.getCoordinate().y, (double)P2.getCoordinate().x, (double)P2.getCoordinate().y, (double)P3.getCoordinate().x, (double)P3.getCoordinate().y, (double)P0_.getCoordinate().x, (double)P0_.getCoordinate().y, (double)P1_.getCoordinate().x, (double)P1_.getCoordinate().y, (double)P2_.getCoordinate().x, (double)P2_.getCoordinate().y, (double)P3_.getCoordinate().x, (double)P3_.getCoordinate().y));
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(InImageBuffer);
                pb.add(warp);
                pb.add(new InterpolationNearest());
                RenderedOp outputOp = JAI.create((String)"warp", (ParameterBlock)pb);
                BufferedImage outImageBuffer = outputOp.getAsBufferedImage();
                GeometryFactory gf = new GeometryFactory();
                Geometry outGeometry = trans.transform(gf.toGeometry(inEnvelope));
                Envelope outEnvelope = outGeometry.getEnvelope().getEnvelopeInternal();
                lyr.setVisible(false);
                ImageryUtils.saveToPng(outFile, outImageBuffer);
                WorldFileHandler worldFileHandler = new WorldFileHandler(outFile.getAbsolutePath(), false);
                worldFileHandler.writeWorldFile(outEnvelope, outImageBuffer.getWidth(), outImageBuffer.getHeight());
                Registry registry = context.getWorkbenchContext().getRegistry();
                List loaders = registry.getEntries(FileLayerLoader.KEY);
                FileLayerLoader loader = null;
                for (FileLayerLoader fileLayerLoader : loaders) {
                    if (!(fileLayerLoader instanceof GeoImageFactoryFileLayerLoader)) continue;
                    loader = fileLayerLoader;
                }
                URI uri = outFile.toURI();
                HashMap<String, Object> dp = new HashMap<String, Object>();
                dp.put("Uri", outFile.toURI().toString());
                dp.put("File", outFile);
                dp.put(ImageryLayerDataset.ATTR_TYPE, "png");
                loader.open(null, uri, dp);
            } else if (option == 1) {
                return;
            }
        }
        catch (RuntimeException localRuntimeException) {
            JOptionPane.showMessageDialog(null, ALLOWED_IMAGES, null, 1);
        }
    }

    private class SetIdentityListener
    implements ActionListener {
        private SetIdentityListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AffineTransformationPlugIn.this.setToIdentity();
        }
    }

    private class UpdateParamListener
    implements ActionListener {
        private UpdateParamListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String errMsg = AffineTransformationPlugIn.this.updateParams();
            if (errMsg != null) {
                JOptionPane.showMessageDialog(null, errMsg, I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.Control-Point-Error"), 0);
            }
        }
    }

    private class OriginLLListener
    implements ActionListener {
        private boolean isLowerLeft;

        OriginLLListener(boolean isLowerLeft) {
            this.isLowerLeft = isLowerLeft;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AffineTransformationPlugIn.this.updateOriginLL(this.isLowerLeft);
        }
    }
}

