/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.parameter;

import java.util.HashMap;
import java.util.Map;

public class ParameterListSchema {
    private String[] paramNames;
    private Class[] paramClasses;
    private Map<String, Integer> name2posMap = new HashMap<String, Integer>();

    public ParameterListSchema(String[] paramNames, Class[] paramClasses) {
        this.initialize(paramNames, paramClasses);
    }

    protected ParameterListSchema initialize(String[] paramNames, Class[] paramClasses) {
        this.paramNames = paramNames;
        this.paramClasses = paramClasses;
        for (int i = 0; i < paramNames.length; ++i) {
            this.name2posMap.put(paramNames[i], i);
        }
        return this;
    }

    public String[] getNames() {
        return this.paramNames;
    }

    public Class[] getClasses() {
        return this.paramClasses;
    }

    public boolean isValidName(String name) {
        return this.name2posMap.containsKey(name);
    }

    public boolean equals(Object obj) {
        return obj instanceof ParameterListSchema && this.equals((ParameterListSchema)obj);
    }

    private boolean equals(ParameterListSchema other) {
        int i;
        if (this.paramNames.length != other.paramNames.length) {
            return false;
        }
        for (i = 0; i < this.paramNames.length; ++i) {
            if (this.paramNames[i].equals(other.paramNames[i])) continue;
            return false;
        }
        for (i = 0; i < this.paramNames.length; ++i) {
            if (this.paramClasses[i] == other.paramClasses[i]) continue;
            return false;
        }
        return true;
    }

    public Class getClass(String name) {
        return this.paramClasses[this.name2posMap.get(name)];
    }
}

