/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.coordsys.CoordinateSystem;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.FlexibleFeature;
import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.GMLInputTemplate;
import com.vividsolutions.jump.io.IllegalParametersException;
import com.vividsolutions.jump.io.JUMPReader;
import com.vividsolutions.jump.io.ParseException;
import com.vividsolutions.jump.io.SAXCancelledException;
import com.vividsolutions.jump.task.DummyTaskMonitor;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.task.TaskMonitorSupport;
import com.vividsolutions.jump.task.TaskMonitorUtil;
import com.vividsolutions.jump.util.Timer;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.xerces.parsers.SAXParser;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class GMLReader
extends DefaultHandler
implements JUMPReader,
TaskMonitorSupport {
    private static int STATE_GET_COLUMNS = 3;
    private Collection<Exception> exceptions = new ArrayList<Exception>();
    private Locator locator;
    private static int STATE_INIT = 0;
    private static int STATE_PARSE_GEOM_NESTED = 1000;
    private static int STATE_PARSE_GEOM_SIMPLE = 4;
    private static int STATE_WAIT_COLLECTION_TAG = 1;
    private static int STATE_WAIT_FEATURE_TAG = 2;
    private static int STATE_WAIT_GMLBOX_TAG = 8;
    private static final List<String> simpleGeoms = new ArrayList<String>();
    private static final List<String> multiGeoms = new ArrayList<String>();
    private GMLInputTemplate GMLinput = null;
    private int STATE = STATE_INIT;
    private Point apoint;
    private Feature currentFeature;
    private FeatureCollection fc;
    private FeatureSchema fcmd;
    private Geometry finalGeometry;
    private String current_geom_qname = "";
    private ArrayList<Geometry> geometry;
    private GeometryFactory geometryFactory = new GeometryFactory();
    private ArrayList<LinearRing> innerBoundaries = new ArrayList();
    private Attributes lastStartTag_atts;
    private String lastStartTag_name;
    private String lastStartTag_qName;
    private String lastStartTag_uri;
    private LineString lineString;
    private LinearRing linearRing;
    private LinearRing outerBoundary;
    private ArrayList<Coordinate> pointList = new ArrayList();
    private Polygon polygon;
    private ArrayList<ArrayList> recursivegeometry = new ArrayList();
    private Coordinate singleCoordinate = new Coordinate();
    private String streamName;
    private StringBuffer tagBody;
    private XMLReader xr;
    private int SRID = 0;
    private boolean parseSRID = false;
    public boolean multiItemsAsLists = false;
    private static Pattern regex_geomMultiPoint;
    private static Pattern regex_geomMultiLineString;
    private static Pattern regex_geomMultiPolygon;
    private static Pattern regex_geomLinearRing;
    private TaskMonitor taskMonitor = new DummyTaskMonitor();
    private long milliSeconds = 0L;

    public GMLReader() {
        this.xr = new SAXParser();
        this.xr.setContentHandler(this);
        this.xr.setErrorHandler(this);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void acceptSRID(boolean parseTheSRID) {
        this.parseSRID = parseTheSRID;
    }

    public void processMultiItems(boolean accept) {
        this.multiItemsAsLists = accept;
    }

    public void setInputTemplate(GMLInputTemplate template) {
        this.GMLinput = template;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.tagBody.append(ch, start, length);
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
    }

    private boolean compareToIgnoreCaseWithOptionalGmlColonPrefix(String value1, String value2) {
        if (value1 == null || value2 == null) {
            throw new InvalidParameterException("no null values allowed. value1/" + value1 + ", value2/" + value2);
        }
        if (value1.equalsIgnoreCase(value2)) {
            return true;
        }
        String prefix = "gml:";
        if (!value1.toLowerCase().startsWith(prefix)) {
            value1 = prefix + value1;
        }
        if (!value2.toLowerCase().startsWith(prefix)) {
            value2 = prefix + value2;
        }
        return value1.equalsIgnoreCase(value2);
    }

    @Override
    public FeatureCollection read(DriverProperties dp) throws Exception {
        GMLInputTemplate gmlTemplate;
        boolean isCompressed_template = dp.getProperty("CompressedFileTemplate") != null;
        boolean isCompressed = dp.getProperty("CompressedFile") != null;
        String inputFname = dp.getProperty("File");
        if (inputFname == null) {
            inputFname = dp.getProperty("DefaultValue");
        }
        if (inputFname == null) {
            throw new IllegalParametersException("call to GMLReader.read() has DataProperties w/o a InputFile specified");
        }
        if (dp.getProperty("TemplateFile") == null) {
            if (isCompressed) {
                InputStream in = CompressedFile.openFile(inputFname, dp.getProperty("CompressedFile"));
                gmlTemplate = this.inputTemplateFromFile(in);
                in.close();
            } else {
                gmlTemplate = this.inputTemplateFromFile(inputFname);
            }
        } else if (isCompressed_template) {
            InputStream in = CompressedFile.openFile(dp.getProperty("TemplateFile"), dp.getProperty("CompressedFileTemplate"));
            gmlTemplate = this.inputTemplateFromFile(in);
            in.close();
        } else if (isCompressed) {
            if (dp.getProperty("CompressedFile").equals(dp.getProperty("TemplateFile"))) {
                InputStream in = CompressedFile.openFile(inputFname, dp.getProperty("CompressedFile"));
                gmlTemplate = this.inputTemplateFromFile(in);
                in.close();
            } else {
                gmlTemplate = this.inputTemplateFromFile(dp.getProperty("TemplateFile"));
            }
        } else {
            gmlTemplate = this.inputTemplateFromFile(dp.getProperty("TemplateFile"));
        }
        this.setInputTemplate(gmlTemplate);
        FeatureCollection fc = this.read(CompressedFile.openFile(inputFname, dp.getProperty("CompressedFile")), inputFname);
        return fc;
    }

    public FeatureCollection read(InputStream is) throws Exception {
        return this.read(is, "Unknown Stream");
    }

    public FeatureCollection read(Object o, String readerName) throws Exception {
        InputSource is;
        if (o instanceof Reader) {
            is = new InputSource((Reader)o);
        } else if (o instanceof InputStream) {
            is = new InputSource((InputStream)o);
        } else {
            throw new ParseException("need InputStream or Reader object!");
        }
        if (this.GMLinput == null) {
            throw new ParseException("you must set the GMLinput template first!");
        }
        this.streamName = readerName;
        this.fcmd = this.GMLinput.toFeatureSchema();
        this.fc = new FeatureDataset(this.fcmd);
        try {
            this.xr.parse(is);
        }
        catch (SAXCancelledException e) {
            this.fc = null;
        }
        catch (SAXParseException e) {
            throw new ParseException(e.getMessage() + "  Last Opened Tag: " + this.lastStartTag_qName + ".  Reader reports last line read as " + e.getLineNumber(), this.streamName + " - " + e.getPublicId() + " (" + e.getSystemId() + ") ", e.getLineNumber(), e.getColumnNumber());
        }
        catch (SAXException e) {
            throw new ParseException(e.getMessage() + "  Last Opened Tag: " + this.lastStartTag_qName, this.streamName, 0, 0);
        }
        return this.fc;
    }

    @Override
    public void startDocument() {
        this.tagBody = new StringBuffer();
        this.STATE = STATE_WAIT_COLLECTION_TAG;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) throws SAXException {
        if (this.getTaskMonitor().isCancelRequested()) {
            throw new SAXCancelledException();
        }
        try {
            int newSRID;
            this.tagBody = new StringBuffer();
            this.lastStartTag_uri = uri;
            this.lastStartTag_name = name;
            this.lastStartTag_qName = qName;
            this.lastStartTag_atts = atts;
            if (this.STATE == STATE_INIT) {
                return;
            }
            if (this.STATE == STATE_WAIT_COLLECTION_TAG && qName.compareToIgnoreCase(this.GMLinput.collectionTag) == 0) {
                this.STATE = STATE_WAIT_FEATURE_TAG;
                return;
            }
            if (this.STATE == STATE_WAIT_FEATURE_TAG && qName.compareToIgnoreCase(this.GMLinput.featureTag) == 0) {
                this.currentFeature = new FlexibleFeature(this.fcmd);
                this.STATE = STATE_GET_COLUMNS;
                return;
            }
            if (this.STATE == STATE_GET_COLUMNS && this.GMLinput.isGeometryElement(qName)) {
                this.recursivegeometry = new ArrayList();
                this.geometry = new ArrayList();
                this.recursivegeometry.add(this.geometry);
                this.finalGeometry = null;
                this.STATE = STATE_PARSE_GEOM_SIMPLE;
                return;
            }
            if (this.parseSRID && this.STATE >= STATE_PARSE_GEOM_SIMPLE && this.isGeometryTag(qName) && (newSRID = this.parseSRID(atts.getValue("srsName"))) != 0) {
                this.SRID = newSRID;
                if (this.geometryFactory.getSRID() != this.SRID) {
                    this.geometryFactory = new GeometryFactory(new PrecisionModel(), this.SRID);
                }
            }
            if (this.STATE >= STATE_PARSE_GEOM_SIMPLE && (qName.compareToIgnoreCase("coord") == 0 || qName.compareToIgnoreCase("gml:coord") == 0)) {
                this.singleCoordinate.x = Double.NaN;
                this.singleCoordinate.y = Double.NaN;
                this.singleCoordinate.z = Double.NaN;
            }
            if (this.STATE >= STATE_PARSE_GEOM_SIMPLE && qName.compareToIgnoreCase("X") != 0 && qName.compareToIgnoreCase("gml:x") != 0 && qName.compareToIgnoreCase("y") != 0 && qName.compareToIgnoreCase("gml:y") != 0 && qName.compareToIgnoreCase("z") != 0 && qName.compareToIgnoreCase("gml:z") != 0 && qName.compareToIgnoreCase("coord") != 0 && qName.compareToIgnoreCase("gml:coord") != 0) {
                this.pointList.clear();
            }
            if (this.STATE >= STATE_PARSE_GEOM_SIMPLE && (qName.compareToIgnoreCase("polygon") == 0 || qName.compareToIgnoreCase("gml:polygon") == 0)) {
                this.innerBoundaries.clear();
            }
            if (this.STATE > STATE_GET_COLUMNS && this.isMultiGeometryTag(qName)) {
                if (this.STATE == STATE_PARSE_GEOM_SIMPLE) {
                    this.STATE = STATE_PARSE_GEOM_NESTED;
                    this.current_geom_qname = qName;
                } else {
                    ++this.STATE;
                    this.geometry = new ArrayList();
                    this.recursivegeometry.add(this.geometry);
                }
            }
            if (this.STATE > STATE_GET_COLUMNS && this.isSimpleGeometryTag(qName) && this.current_geom_qname.isEmpty()) {
                this.current_geom_qname = qName;
            }
            if (this.STATE == STATE_WAIT_FEATURE_TAG && this.GMLinput.crsTag != null && this.compareToIgnoreCaseWithOptionalGmlColonPrefix(qName, this.GMLinput.crsTag)) {
                this.STATE = STATE_WAIT_GMLBOX_TAG;
                return;
            }
            if (this.STATE == STATE_WAIT_GMLBOX_TAG && this.compareToIgnoreCaseWithOptionalGmlColonPrefix(qName, "Box")) {
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attName = atts.getQName(i);
                    if (!attName.equalsIgnoreCase("srsName")) continue;
                    String attValue = atts.getValue(i);
                    String sridString = attValue.substring(attValue.lastIndexOf("#") + 1);
                    try {
                        this.SRID = Integer.valueOf(sridString);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.addParseException("srid '" + sridString + "'is not a number.", e);
                    }
                }
                this.STATE = STATE_WAIT_FEATURE_TAG;
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new SAXException(e.getMessage());
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXException {
        block47: {
            if (this.getTaskMonitor().isCancelRequested()) {
                throw new SAXCancelledException();
            }
            try {
                if (this.STATE == STATE_INIT) {
                    this.tagBody = new StringBuffer();
                    return;
                }
                if (this.STATE > STATE_GET_COLUMNS) {
                    Coordinate[] c;
                    if (this.isMultiGeometryTag(qName)) {
                        if (this.STATE == STATE_PARSE_GEOM_NESTED) {
                            this.STATE = STATE_PARSE_GEOM_SIMPLE;
                        } else {
                            Geometry g = this.geometryFactory.buildGeometry(this.geometry);
                            this.geometry = this.recursivegeometry.get(this.STATE - STATE_PARSE_GEOM_NESTED - 1);
                            this.geometry.add(g);
                            this.recursivegeometry.remove(this.STATE - STATE_PARSE_GEOM_NESTED);
                            g = null;
                            --this.STATE;
                        }
                    }
                    if (this.GMLinput.isGeometryElement(qName)) {
                        this.tagBody = new StringBuffer();
                        this.STATE = STATE_GET_COLUMNS;
                        if (this.linearRing != null) {
                            this.geometry.add((Geometry)this.linearRing);
                            this.linearRing = null;
                        }
                        this.finalGeometry = regex_geomMultiPoint.matcher(this.current_geom_qname).matches() ? this.geometryFactory.createMultiPoint(this.geometry.toArray(new Point[0])) : (regex_geomMultiLineString.matcher(this.current_geom_qname).matches() ? this.geometryFactory.createMultiLineString(this.geometry.toArray(new LineString[0])) : (regex_geomMultiPolygon.matcher(this.current_geom_qname).matches() ? this.geometryFactory.createMultiPolygon(this.geometry.toArray(new Polygon[0])) : this.geometryFactory.buildGeometry(this.geometry)));
                        this.currentFeature.setGeometry(this.finalGeometry);
                        this.current_geom_qname = "";
                        return;
                    }
                    if (qName.compareToIgnoreCase("X") == 0 || qName.compareToIgnoreCase("gml:X") == 0) {
                        this.singleCoordinate.x = Double.parseDouble(this.tagBody.toString());
                    } else if (qName.compareToIgnoreCase("Y") == 0 || qName.compareToIgnoreCase("gml:y") == 0) {
                        this.singleCoordinate.y = Double.parseDouble(this.tagBody.toString());
                    } else if (qName.compareToIgnoreCase("Z") == 0 || qName.compareToIgnoreCase("gml:z") == 0) {
                        this.singleCoordinate.z = Double.parseDouble(this.tagBody.toString());
                    } else if (qName.compareToIgnoreCase("COORD") == 0 || qName.compareToIgnoreCase("gml:coord") == 0) {
                        this.pointList.add(new Coordinate(this.singleCoordinate));
                    } else if (qName.compareToIgnoreCase("COORDINATES") == 0 || qName.compareToIgnoreCase("gml:coordinates") == 0) {
                        this.parsePoints(this.tagBody.toString(), this.geometryFactory);
                    } else if (qName.compareToIgnoreCase("linearring") == 0 || qName.compareToIgnoreCase("gml:linearring") == 0) {
                        c = new Coordinate[]{};
                        c = this.pointList.toArray(c);
                        this.linearRing = this.geometryFactory.createLinearRing(c);
                    } else if (qName.compareToIgnoreCase("outerBoundaryIs") == 0 || qName.compareToIgnoreCase("gml:outerBoundaryIs") == 0) {
                        this.outerBoundary = this.linearRing;
                        this.linearRing = null;
                    } else if (qName.compareToIgnoreCase("innerBoundaryIs") == 0 || qName.compareToIgnoreCase("gml:innerBoundaryIs") == 0) {
                        this.innerBoundaries.add(this.linearRing);
                        this.linearRing = null;
                    } else if (qName.compareToIgnoreCase("polygon") == 0 || qName.compareToIgnoreCase("gml:polygon") == 0) {
                        LinearRing[] lrs = new LinearRing[]{};
                        lrs = this.innerBoundaries.toArray(lrs);
                        this.polygon = this.geometryFactory.createPolygon(this.outerBoundary, lrs);
                        this.geometry.add((Geometry)this.polygon);
                    } else if (qName.compareToIgnoreCase("linestring") == 0 || qName.compareToIgnoreCase("gml:linestring") == 0) {
                        c = new Coordinate[]{};
                        c = this.pointList.toArray(c);
                        this.lineString = this.geometryFactory.createLineString(c);
                        this.geometry.add((Geometry)this.lineString);
                    } else if (qName.compareToIgnoreCase("point") == 0 || qName.compareToIgnoreCase("gml:point") == 0) {
                        this.apoint = this.geometryFactory.createPoint(this.pointList.size() > 0 ? this.pointList.get(0) : null);
                        this.geometry.add((Geometry)this.apoint);
                    }
                    break block47;
                }
                if (this.STATE == STATE_GET_COLUMNS) {
                    if (qName.compareToIgnoreCase(this.GMLinput.featureTag) == 0) {
                        this.tagBody = new StringBuffer();
                        this.STATE = STATE_WAIT_FEATURE_TAG;
                        if (this.currentFeature.getGeometry() == null) {
                            Geometry g = this.currentFeature.getGeometry();
                            if (g != null) {
                                // empty if block
                            }
                            throw new ParseException("no geometry specified in feature");
                        }
                        this.fc.add(this.currentFeature);
                        this.report(this.fc.size());
                        this.currentFeature = null;
                        return;
                    }
                    try {
                        int index = this.GMLinput.match(this.lastStartTag_qName, this.lastStartTag_atts);
                        if (index > -1 && this.lastStartTag_qName.equalsIgnoreCase(qName)) {
                            if (this.multiItemsAsLists && this.currentFeature.getAttribute(this.GMLinput.columnName(index)) != null && this.GMLinput.columnDefinitions.get((int)index).type == AttributeType.OBJECT) {
                                Object oldValue = this.currentFeature.getAttribute(this.GMLinput.columnName(index));
                                if (oldValue instanceof List) {
                                    ((List)oldValue).add(this.GMLinput.getColumnValue(index, this.tagBody.toString(), this.lastStartTag_atts));
                                } else {
                                    ArrayList<Object> l = new ArrayList<Object>();
                                    l.add(oldValue);
                                    l.add(this.GMLinput.getColumnValue(index, this.tagBody.toString(), this.lastStartTag_atts));
                                    this.currentFeature.setAttribute(this.GMLinput.columnName(index), l);
                                }
                            } else {
                                this.currentFeature.setAttribute(this.GMLinput.columnName(index), this.GMLinput.getColumnValue(index, this.tagBody.toString(), this.lastStartTag_atts));
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.tagBody = new StringBuffer();
                    break block47;
                }
                if (this.STATE == STATE_WAIT_FEATURE_TAG) {
                    if (qName.compareToIgnoreCase(this.GMLinput.collectionTag) == 0) {
                        this.STATE = STATE_INIT;
                        this.tagBody = new StringBuffer();
                        return;
                    }
                } else {
                    if (this.STATE == STATE_WAIT_COLLECTION_TAG) {
                        this.tagBody = new StringBuffer();
                        return;
                    }
                    if (this.STATE == STATE_WAIT_GMLBOX_TAG && this.compareToIgnoreCaseWithOptionalGmlColonPrefix(qName, "boundedBy")) {
                        this.STATE = STATE_WAIT_FEATURE_TAG;
                        return;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SAXException(e.getMessage());
            }
        }
    }

    @Override
    public void endDocument() {
        if (this.SRID > 0) {
            this.fc.getFeatureSchema().setCoordinateSystem(new CoordinateSystem("", this.SRID, null));
        }
        this.STATE = STATE_INIT;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.exceptions.add(exception);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.exceptions.add(exception);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    private boolean isGeometryTag(String s) {
        return simpleGeoms.contains(s = this.stripGmlColon(s).toLowerCase()) || multiGeoms.contains(s);
    }

    private boolean isSimpleGeometryTag(String s) {
        s = this.stripGmlColon(s).toLowerCase();
        return simpleGeoms.contains(s);
    }

    private boolean isMultiGeometryTag(String s) {
        s = this.stripGmlColon(s).toLowerCase();
        return multiGeoms.contains(s);
    }

    private String stripGmlColon(String s) {
        return s.replaceFirst("^(?i)gml:", "");
    }

    private GMLInputTemplate inputTemplateFromFile(InputStream in) throws ParseException, IOException {
        GMLInputTemplate result = this.inputTemplate(in);
        return result;
    }

    private GMLInputTemplate inputTemplateFromFile(String filename) throws ParseException, IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(filename));
        GMLInputTemplate result = this.inputTemplate(is);
        ((InputStream)is).close();
        return result;
    }

    private void parsePoints(String ptString, GeometryFactory geometryFactory) {
        Coordinate coord = new Coordinate();
        StringBuffer sb = new StringBuffer(ptString);
        for (int t = 0; t < sb.length(); ++t) {
            char ch = sb.charAt(t);
            if (ch != '\n' && ch != '\r') continue;
            sb.setCharAt(t, ' ');
        }
        StringTokenizer stokenizer = new StringTokenizer(new String(sb), " ", false);
        while (stokenizer.hasMoreElements()) {
            String aPoint = stokenizer.nextToken();
            StringTokenizer stokenizerPoint = new StringTokenizer(aPoint, ",", false);
            coord.z = Double.NaN;
            coord.y = Double.NaN;
            coord.x = Double.NaN;
            int dim = 0;
            while (stokenizerPoint.hasMoreElements()) {
                String numb = stokenizerPoint.nextToken();
                if (dim == 0) {
                    coord.x = Double.parseDouble(numb);
                } else if (dim == 1) {
                    coord.y = Double.parseDouble(numb);
                } else if (dim == 2) {
                    coord.z = Double.parseDouble(numb);
                }
                ++dim;
            }
            if (coord.x != coord.x || coord.y != coord.y) {
                throw new IllegalArgumentException("GML error - coordinate list isnt valid GML. Watch your spaces and commas!");
            }
            this.pointList.add(coord);
            coord = new Coordinate();
            stokenizerPoint = null;
        }
    }

    private GMLInputTemplate inputTemplate(InputStream is) throws IOException, ParseException {
        GMLInputTemplate gmlTemplate = new GMLInputTemplate();
        gmlTemplate.load(is);
        is.close();
        if (!gmlTemplate.loaded) {
            throw new ParseException("Failed to load GML input template");
        }
        return gmlTemplate;
    }

    private int parseSRID(String srsName) {
        try {
            int semicolonLoc = srsName.lastIndexOf(58);
            if (semicolonLoc == -1) {
                return 0;
            }
            return Integer.parseInt(srsName.substring(semicolonLoc + 1).trim());
        }
        catch (NumberFormatException e) {
            this.addParseException("srid '" + srsName + "'is not a number.", e);
            return 0;
        }
    }

    protected void addException(Exception e) {
        this.exceptions.add(e);
    }

    protected void addParseException(String message, Exception cause) {
        this.exceptions.add(new ParseException(message, this.streamName, this.locator.getLineNumber(), this.locator.getColumnNumber(), cause));
    }

    @Override
    public Collection<Exception> getExceptions() {
        return this.exceptions;
    }

    @Override
    public void setTaskMonitor(TaskMonitor taskMonitor) {
        this.taskMonitor = taskMonitor;
    }

    @Override
    public TaskMonitor getTaskMonitor() {
        return this.taskMonitor;
    }

    private void report(int num) {
        long now = Timer.milliSecondsSince(0L);
        if (now - 500L >= this.milliSeconds) {
            this.milliSeconds = now;
            TaskMonitorUtil.report(this.getTaskMonitor(), I18N.getInstance().get("Reader.parsed-{0}-features", String.format("%,10d", num)));
        }
    }

    static {
        multiGeoms.add("multipoint");
        multiGeoms.add("multilinestring");
        multiGeoms.add("multipolygon");
        multiGeoms.add("multigeometry");
        multiGeoms.add("geometrycollection");
        simpleGeoms.add("polygon");
        simpleGeoms.add("linestring");
        simpleGeoms.add("point");
        simpleGeoms.add("linearring");
        regex_geomMultiPoint = Pattern.compile("^(?i)(gml:)?multipoint$");
        regex_geomMultiLineString = Pattern.compile("^(?i)(gml:)?multilinestring$");
        regex_geomMultiPolygon = Pattern.compile("^(?i)(gml:)?multipolygon$");
        regex_geomLinearRing = Pattern.compile("^(?i)(gml:)?linearring$");
    }
}

