/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GMLGeometryWriter {
    private final int INDENT_SIZE = 2;
    private static final String coordinateSeparator = ",";
    private static final String tupleSeparator = " ";
    private String linePrefix = null;
    private int maxCoordinatesPerLine = 10;
    private String srsName = null;
    private String gid = null;

    private static String stringOfChar(char ch, int count) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            buf.append(ch);
        }
        return buf.toString();
    }

    void setLinePrefix(String linePrefix) {
        this.linePrefix = linePrefix;
    }

    public void setSRSName(String srsName) {
        this.srsName = srsName;
    }

    void setGID(String gid) {
        this.gid = gid;
    }

    void setMaximumCoordinatesPerLine(int maxCoordinatesPerLine) {
        if (maxCoordinatesPerLine <= 0) {
            this.maxCoordinatesPerLine = 1;
            return;
        }
        this.maxCoordinatesPerLine = maxCoordinatesPerLine;
    }

    public String write(Geometry geom) {
        try {
            StringWriter writer = new StringWriter();
            this.write(geom, writer);
            return writer.toString();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public void write(Geometry g, Writer writer) throws IOException {
        this.writeGeometry(g, this.attributeString(), 0, writer);
    }

    private void writeGeometry(Geometry g, String attributes, int level, Writer writer) throws IOException {
        if (g instanceof Point) {
            this.writePoint((Point)g, attributes, level, writer);
        } else if (g instanceof LinearRing) {
            this.writeLinearRing((LinearRing)g, attributes, level, writer);
        } else if (g instanceof LineString) {
            this.writeLineString((LineString)g, attributes, level, writer);
        } else if (g instanceof Polygon) {
            this.writePolygon((Polygon)g, attributes, level, writer);
        } else if (g instanceof MultiPoint) {
            this.writeMultiPoint((MultiPoint)g, attributes, level, writer);
        } else if (g instanceof MultiLineString) {
            this.writeMultiLineString((MultiLineString)g, attributes, level, writer);
        } else if (g instanceof MultiPolygon) {
            this.writeMultiPolygon((MultiPolygon)g, attributes, level, writer);
        } else if (g instanceof GeometryCollection) {
            this.writeGeometryCollection((GeometryCollection)g, attributes, level, writer);
        }
    }

    private void startLine(Writer writer, int level, String text) throws IOException {
        if (this.linePrefix != null) {
            writer.append(this.linePrefix);
        }
        writer.append(GMLGeometryWriter.stringOfChar(' ', 2 * level));
        writer.append(text);
    }

    private String geometryTag(String geometryName, String attributes) {
        StringBuilder buf = new StringBuilder();
        buf.append("<gml:");
        buf.append(geometryName);
        if (attributes != null && attributes.length() > 0) {
            buf.append(tupleSeparator);
            buf.append(attributes);
        }
        buf.append(">");
        return buf.toString();
    }

    private String attributeString() {
        StringBuilder buf = new StringBuilder();
        if (this.gid != null) {
            buf.append(" gid='");
            buf.append(this.gid);
            buf.append("'");
        }
        if (this.srsName != null) {
            buf.append(" srsName='");
            buf.append(this.srsName);
            buf.append("'");
        }
        return buf.toString();
    }

    private void writePoint(Point p, String attributes, int level, Writer writer) throws IOException {
        this.startLine(writer, level, this.geometryTag("Point", attributes) + "\n");
        if (!p.isEmpty()) {
            this.write(new Coordinate[]{p.getCoordinate()}, level + 1, writer);
        }
        this.startLine(writer, level, "</gml:Point>\n");
    }

    private void writeLineString(LineString ls, String attributes, int level, Writer writer) throws IOException {
        this.startLine(writer, level, this.geometryTag("LineString", attributes) + "\n");
        this.write(ls.getCoordinates(), level + 1, writer);
        this.startLine(writer, level, "</gml:LineString>\n");
    }

    private void writeLinearRing(LinearRing lr, String attributes, int level, Writer writer) throws IOException {
        this.startLine(writer, level, this.geometryTag("LinearRing", attributes) + "\n");
        this.write(lr.getCoordinates(), level + 1, writer);
        this.startLine(writer, level, "</gml:LinearRing>\n");
    }

    private void writePolygon(Polygon p, String attributes, int level, Writer writer) throws IOException {
        this.startLine(writer, level, this.geometryTag("Polygon", attributes) + "\n");
        this.startLine(writer, level, "  <gml:outerBoundaryIs>\n");
        this.writeLinearRing(p.getExteriorRing(), null, level + 1, writer);
        this.startLine(writer, level, "  </gml:outerBoundaryIs>\n");
        for (int t = 0; t < p.getNumInteriorRing(); ++t) {
            this.startLine(writer, level, "  <gml:innerBoundaryIs>\n");
            this.writeLinearRing(p.getInteriorRingN(t), null, level + 1, writer);
            this.startLine(writer, level, "  </gml:innerBoundaryIs>\n");
        }
        this.startLine(writer, level, "</gml:Polygon>\n");
    }

    private void writeMultiPoint(MultiPoint mp, String attributes, int level, Writer writer) throws IOException {
        this.startLine(writer, level, this.geometryTag("MultiPoint", attributes) + "\n");
        for (int t = 0; t < mp.getNumGeometries(); ++t) {
            this.startLine(writer, level, "  <gml:pointMember>\n");
            this.writePoint((Point)mp.getGeometryN(t), null, level + 1, writer);
            this.startLine(writer, level, "  </gml:pointMember>\n");
        }
        this.startLine(writer, level, "</gml:MultiPoint>\n");
    }

    private void writeMultiLineString(MultiLineString mls, String attributes, int level, Writer writer) throws IOException {
        this.startLine(writer, level, this.geometryTag("MultiLineString", attributes) + "\n");
        for (int t = 0; t < mls.getNumGeometries(); ++t) {
            this.startLine(writer, level, "  <gml:lineStringMember>\n");
            this.writeLineString((LineString)mls.getGeometryN(t), null, level + 1, writer);
            this.startLine(writer, level, "  </gml:lineStringMember>\n");
        }
        this.startLine(writer, level, "</gml:MultiLineString>\n");
    }

    private void writeMultiPolygon(MultiPolygon mp, String attributes, int level, Writer writer) throws IOException {
        this.startLine(writer, level, this.geometryTag("MultiPolygon", attributes) + "\n");
        for (int t = 0; t < mp.getNumGeometries(); ++t) {
            this.startLine(writer, level, "  <gml:polygonMember>\n");
            this.writePolygon((Polygon)mp.getGeometryN(t), null, level + 1, writer);
            this.startLine(writer, level, "  </gml:polygonMember>\n");
        }
        this.startLine(writer, level, "</gml:MultiPolygon>\n");
    }

    private void writeGeometryCollection(GeometryCollection gc, String attributes, int level, Writer writer) throws IOException {
        this.startLine(writer, level, this.geometryTag("MultiGeometry", attributes) + "\n");
        for (int t = 0; t < gc.getNumGeometries(); ++t) {
            this.startLine(writer, level, "  <gml:geometryMember>\n");
            this.writeGeometry(gc.getGeometryN(t), null, level + 1, writer);
            this.startLine(writer, level, "  </gml:geometryMember>\n");
        }
        this.startLine(writer, level, "</gml:MultiGeometry>\n");
    }

    private void write(Coordinate[] coords, int level, Writer writer) throws IOException {
        this.startLine(writer, level, "<gml:coordinates>\n");
        int dim = 2;
        for (Coordinate c : coords) {
            if (Double.isNaN(c.z)) continue;
            dim = 3;
            break;
        }
        boolean isNewLine = true;
        for (int i = 0; i < coords.length; ++i) {
            if (isNewLine) {
                this.startLine(writer, level, "  ");
                isNewLine = false;
            }
            if (dim == 2) {
                writer.append("" + coords[i].x);
                writer.append(coordinateSeparator);
                writer.append("" + coords[i].y);
            } else if (dim == 3) {
                writer.append("" + coords[i].x);
                writer.append(coordinateSeparator);
                writer.append("" + coords[i].y);
                writer.append(coordinateSeparator);
                writer.append("" + coords[i].z);
            }
            writer.append(tupleSeparator);
            if ((i + 1) % this.maxCoordinatesPerLine != 0 || i >= coords.length - 1) continue;
            writer.append("\n");
            isNewLine = true;
        }
        writer.append("\n");
        this.startLine(writer, level, "</gml:coordinates>\n");
    }
}

