/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.feature;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.util.Assert;

public abstract class FeatureCollectionWrapper
implements FeatureCollection {
    private FeatureCollection fc;

    public FeatureCollectionWrapper(FeatureCollection fc) {
        this.fc = fc;
    }

    public FeatureCollection getUltimateWrappee() {
        FeatureCollection currentWrappee = this.fc;
        while (currentWrappee instanceof FeatureCollectionWrapper) {
            currentWrappee = ((FeatureCollectionWrapper)currentWrappee).fc;
        }
        return currentWrappee;
    }

    public void checkNotWrappingSameClass() {
        Assert.isTrue((!(this.fc instanceof FeatureCollectionWrapper) || !((FeatureCollectionWrapper)this.fc).hasWrapper(this.getClass()) ? 1 : 0) != 0);
    }

    @Override
    public Collection<Feature> remove(Envelope env) {
        return this.fc.remove(env);
    }

    public boolean hasWrapper(Class c) {
        Assert.isTrue((boolean)FeatureCollectionWrapper.class.isAssignableFrom(c));
        if (c.isInstance(this)) {
            return true;
        }
        return this.fc instanceof FeatureCollectionWrapper && ((FeatureCollectionWrapper)this.fc).hasWrapper(c);
    }

    public FeatureCollection getWrappee(Class c) {
        Assert.isTrue((boolean)FeatureCollectionWrapper.class.isAssignableFrom(c));
        if (c.isInstance(this)) {
            return this;
        }
        if (this.fc instanceof FeatureCollectionWrapper) {
            return ((FeatureCollectionWrapper)this.fc).getWrappee(c);
        }
        return null;
    }

    public FeatureCollection getWrappee() {
        return this.fc;
    }

    @Override
    public FeatureSchema getFeatureSchema() {
        return this.fc.getFeatureSchema();
    }

    @Override
    public Envelope getEnvelope() {
        return this.fc.getEnvelope();
    }

    @Override
    public int size() {
        return this.fc.size();
    }

    @Override
    public boolean isEmpty() {
        return this.fc.isEmpty();
    }

    @Override
    public List<Feature> getFeatures() {
        return this.fc.getFeatures();
    }

    @Override
    public Iterator<Feature> iterator() {
        return this.fc.iterator();
    }

    @Override
    public List<Feature> query(Envelope envelope) {
        return this.fc.query(envelope);
    }

    @Override
    public void add(Feature feature) {
        this.fc.add(feature);
    }

    @Override
    public void remove(Feature feature) {
        this.fc.remove(feature);
    }

    @Override
    public void addAll(Collection<Feature> features) {
        this.fc.addAll(features);
    }

    @Override
    public void removeAll(Collection<Feature> features) {
        this.fc.removeAll(features);
    }

    @Override
    public void clear() {
        this.removeAll(new ArrayList<Feature>(this.getFeatures()));
    }

    protected FeatureCollection getFeatureCollection() {
        return this.fc;
    }

    protected void setFeatureCollection(FeatureCollection featureCollection) {
        this.fc = featureCollection;
    }
}

