/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.spatialdatabases;

import com.vividsolutions.jump.datastore.jdbc.ValueConverter;
import com.vividsolutions.jump.feature.AttributeType;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTReader;

public class SpatialDatabasesValueConverterFactory {
    protected final ValueConverter WKT_GEOMETRY_MAPPER = new WKTGeometryValueConverter();
    protected final ValueConverter WKB_GEOMETRY_MAPPER = new WKBGeometryValueConverter();
    public final ValueConverter WKB_OBJECT_MAPPER = new WKBObjectValueConverter();
    protected final WKBReader wkbReader = new WKBReader();
    protected final WKTReader wktReader = new WKTReader();
    protected final Connection conn;

    public SpatialDatabasesValueConverterFactory(Connection conn) {
        this.conn = conn;
    }

    public ValueConverter getConverter(ResultSetMetaData rsm, int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    class WKBObjectValueConverter
    implements ValueConverter {
        WKBObjectValueConverter() {
        }

        @Override
        public AttributeType getType() {
            return AttributeType.OBJECT;
        }

        @Override
        public Object getValue(ResultSet rs, int columnIndex) throws IOException, SQLException, ParseException {
            Geometry geometry;
            byte[] bytes = rs.getBytes(columnIndex);
            if (bytes == null || bytes.length == 0) {
                geometry = null;
            } else {
                byte[] realWkbBytes = bytes;
                if (bytes[0] >= 48) {
                    String hexString = new String(bytes);
                    realWkbBytes = WKBReader.hexToBytes((String)hexString);
                }
                geometry = SpatialDatabasesValueConverterFactory.this.wkbReader.read(realWkbBytes);
            }
            return geometry;
        }
    }

    class WKBGeometryValueConverter
    implements ValueConverter {
        WKBGeometryValueConverter() {
        }

        @Override
        public AttributeType getType() {
            return AttributeType.GEOMETRY;
        }

        @Override
        public Object getValue(ResultSet rs, int columnIndex) throws IOException, SQLException, ParseException {
            Geometry geometry;
            byte[] bytes = rs.getBytes(columnIndex);
            if (bytes == null || bytes.length == 0) {
                geometry = null;
            } else if (new String(new byte[]{bytes[0]}).matches("[GLMP]")) {
                geometry = SpatialDatabasesValueConverterFactory.this.wktReader.read(new String(bytes));
            } else {
                byte[] realWkbBytes = bytes;
                if (bytes[0] >= 48) {
                    String hexString = new String(bytes);
                    realWkbBytes = WKBReader.hexToBytes((String)hexString);
                }
                geometry = SpatialDatabasesValueConverterFactory.this.wkbReader.read(realWkbBytes);
            }
            return geometry;
        }
    }

    class WKTGeometryValueConverter
    implements ValueConverter {
        WKTGeometryValueConverter() {
        }

        @Override
        public AttributeType getType() {
            return AttributeType.GEOMETRY;
        }

        @Override
        public Object getValue(ResultSet rs, int columnIndex) throws IOException, SQLException, ParseException {
            Object valObj = rs.getObject(columnIndex);
            if (valObj == null) {
                return null;
            }
            return SpatialDatabasesValueConverterFactory.this.wktReader.read(valObj.toString());
        }
    }
}

