/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.postgis;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.AdhocQuery;
import com.vividsolutions.jump.datastore.FilterQuery;
import com.vividsolutions.jump.datastore.SpatialReferenceSystemID;
import com.vividsolutions.jump.datastore.postgis.PostgisDSMetadata;
import com.vividsolutions.jump.datastore.postgis.PostgisFeatureInputStream;
import com.vividsolutions.jump.datastore.postgis.PostgisSQLBuilder;
import com.vividsolutions.jump.datastore.postgis.PostgisValueConverterFactory;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesDSConnection;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesSQLBuilder;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.FeatureInputStream;
import java.sql.Connection;
import java.sql.SQLException;

public class PostgisDSConnection
extends SpatialDatabasesDSConnection {
    public PostgisDSConnection(Connection con) {
        super(con);
        this.dbMetadata = new PostgisDSMetadata(this);
    }

    @Override
    public SpatialDatabasesSQLBuilder getSqlBuilder(SpatialReferenceSystemID srid, String[] colNames) {
        return new PostgisSQLBuilder(this.dbMetadata, srid, colNames);
    }

    @Override
    public FeatureInputStream executeFilterQuery(FilterQuery query) throws SQLException {
        SpatialReferenceSystemID srid = this.dbMetadata.getSRID(query.getDatasetName(), query.getGeometryAttributeName());
        String[] colNames = this.dbMetadata.getColumnNames(query.getDatasetName());
        PostgisSQLBuilder builder = (PostgisSQLBuilder)this.getSqlBuilder(srid, colNames);
        String queryString = builder.getSQL(query);
        return new PostgisFeatureInputStream(this.connection, queryString, query.getPrimaryKey());
    }

    @Override
    public FeatureInputStream executeAdhocQuery(AdhocQuery query) throws Exception {
        FeatureSchema fs;
        String queryString = query.getQuery();
        PostgisFeatureInputStream ifs = new PostgisFeatureInputStream(this.connection, queryString, query.getPrimaryKey());
        try {
            fs = ifs.getFeatureSchema();
        }
        catch (Exception e) {
            throw new Exception(I18N.getInstance().get(SpatialDatabasesDSConnection.class.getName() + ".SQL-error") + e.getMessage());
        }
        if (fs.getGeometryIndex() < 0) {
            throw new Exception(I18N.getInstance().get(SpatialDatabasesDSConnection.class.getName() + ".resultset-must-have-a-geometry-column"));
        }
        return ifs;
    }

    @Override
    public PostgisValueConverterFactory getValueConverterFactory() {
        return new PostgisValueConverterFactory(this.connection);
    }
}

