/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.oracle;

import com.vividsolutions.jump.datastore.DataStoreLayer;
import com.vividsolutions.jump.datastore.FilterQuery;
import com.vividsolutions.jump.datastore.SpatialReferenceSystemID;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesDSMetadata;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesSQLBuilder;
import com.vividsolutions.jump.workbench.Logger;
import java.sql.SQLException;
import org.locationtech.jts.geom.Envelope;

public class OracleSQLBuilder
extends SpatialDatabasesSQLBuilder {
    public OracleSQLBuilder(SpatialDatabasesDSMetadata dbMetadata, SpatialReferenceSystemID defaultSRID, String[] colNames) {
        super(dbMetadata, defaultSRID, colNames);
    }

    @Override
    public String getSQL(FilterQuery query) {
        StringBuilder qs = new StringBuilder();
        qs.append("SELECT ROWNUM, ").append(this.getColumnListSpecifier(this.colNames, query.getGeometryAttributeName()));
        qs.append(" FROM ( ");
        qs.append("SELECT ");
        qs.append(this.getColumnListSpecifier(this.colNames, query.getGeometryAttributeName()));
        qs.append(" FROM ");
        qs.append("\"").append(query.getDatasetName().replaceAll("\\.", "\".\"")).append("\"");
        qs.append(" t WHERE ");
        qs.append(this.buildBoxFilter(query));
        String whereCond = query.getCondition();
        if (whereCond != null) {
            qs.append(" AND ");
            qs.append(whereCond);
        }
        qs.append(")");
        int limit = query.getLimit();
        if (limit != 0 && limit != Integer.MAX_VALUE) {
            qs.append(" where ROWNUM <= ").append(limit);
        }
        return qs.toString();
    }

    @Override
    public String getCheckSQL(DataStoreLayer dsLayer) {
        String s = "select ROWNUM FROM (select * FROM %s %s) where ROWNUM <=0";
        String wc = dsLayer.getWhereClause();
        wc = wc != null && !wc.isEmpty() ? " WHERE " + wc : "";
        return String.format(s, dsLayer.getFullName(), wc);
    }

    @Override
    protected String getColumnListSpecifier(String[] colNames, String geomColName) {
        StringBuilder buf = new StringBuilder();
        buf.append(geomColName).append(" as ").append("\"").append(geomColName).append("\"");
        for (String colName : colNames) {
            if (geomColName.equalsIgnoreCase(colName)) continue;
            buf.append(", \"").append(colName).append("\"");
        }
        return buf.toString();
    }

    @Override
    protected String buildBoxFilter(FilterQuery query) {
        StringBuilder buf = new StringBuilder("1=1");
        try {
            if (super.getDbMetadata().isIndexed(query.getDatasetName(), query.getGeometryAttributeName())) {
                buf = new StringBuilder();
                Envelope env = query.getFilterGeometry().getEnvelopeInternal();
                String srid = this.getSRID(query.getSRSName()) == null ? "null" : this.getSRID(query.getSRSName());
                buf.append("sdo_filter(\"").append(query.getGeometryAttributeName()).append("\" , SDO_geometry(");
                buf.append("2003,").append(srid).append(",NULL,SDO_elem_info_array(1,1003,3),SDO_ordinate_array(");
                buf.append(env.getMinX()).append(", ").append(env.getMinY()).append(", ").append(env.getMaxX()).append(", ").append(env.getMaxY());
                buf.append(srid).append(")))='TRUE'");
                Logger.info("SQL query fragment to get spatial table BBOX filter:\n\t" + buf.toString());
            }
        }
        catch (SQLException ex) {
            Logger.warn("cannot guess if geo column is indexed, error: " + ex.getMessage(), ex);
        }
        return buf.toString();
    }
}

