/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.jdbc;

import com.vividsolutions.jump.datastore.jdbc.ValueConverter;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.util.FlexibleDateParser;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;

public class ValueConverterFactory {
    public static final ValueConverter DOUBLE_MAPPER = new DoubleConverter();
    public static final ValueConverter INTEGER_MAPPER = new IntegerConverter();
    public static final ValueConverter DATE_MAPPER = new DateConverter();
    public static final ValueConverter STRING_MAPPER = new StringConverter();
    public static final ValueConverter LONG_MAPPER = new LongConverter();
    public static final ValueConverter BOOLEAN_MAPPER = new BooleanConverter();
    public static final ValueConverter OBJECT_MAPPER = new ObjectConverter();

    public static ValueConverter getConverter(ResultSetMetaData rsm, int columnIndex) throws SQLException {
        int sqlType = rsm.getColumnType(columnIndex);
        if (sqlType == 4 || sqlType == 5 || sqlType == -6) {
            return INTEGER_MAPPER;
        }
        if (sqlType == 3 || sqlType == 8 || sqlType == 6 || sqlType == 2 || sqlType == 7) {
            return DOUBLE_MAPPER;
        }
        if (sqlType == 91 || sqlType == 92 || sqlType == 93) {
            return DATE_MAPPER;
        }
        if (sqlType == -5 || sqlType == -8) {
            return LONG_MAPPER;
        }
        if (sqlType == 12 || sqlType == 1 || sqlType == 2005 || sqlType == -16 || sqlType == -1 || sqlType == -15 || sqlType == 2011 || sqlType == -9 || sqlType == 2009) {
            return STRING_MAPPER;
        }
        if (sqlType == -7 || sqlType == 16) {
            return BOOLEAN_MAPPER;
        }
        if (sqlType == -2 || sqlType == -3 || sqlType == 2004 || sqlType == 2003 || sqlType == 2000 || sqlType == -4) {
            return OBJECT_MAPPER;
        }
        return null;
    }

    public static class ObjectConverter
    implements ValueConverter {
        @Override
        public AttributeType getType() {
            return AttributeType.OBJECT;
        }

        @Override
        public Object getValue(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getBytes(columnIndex);
        }
    }

    public static class BooleanConverter
    implements ValueConverter {
        @Override
        public AttributeType getType() {
            return AttributeType.BOOLEAN;
        }

        @Override
        public Object getValue(ResultSet rs, int columnIndex) throws SQLException {
            boolean value = rs.getBoolean(columnIndex);
            return rs.wasNull() ? null : Boolean.valueOf(value);
        }
    }

    public static class LongConverter
    implements ValueConverter {
        @Override
        public AttributeType getType() {
            return AttributeType.LONG;
        }

        @Override
        public Object getValue(ResultSet rs, int columnIndex) throws SQLException {
            long value = rs.getLong(columnIndex);
            return rs.wasNull() ? null : Long.valueOf(value);
        }
    }

    public static class DateConverter
    implements ValueConverter {
        FlexibleDateParser parser = new FlexibleDateParser();

        public DateConverter() {
            this.parser.cachingEnabled(true);
        }

        @Override
        public AttributeType getType() {
            return AttributeType.DATE;
        }

        @Override
        public Object getValue(ResultSet rs, int columnIndex) throws SQLException {
            Date ret = null;
            try {
                ret = rs.getTimestamp(columnIndex);
                if (rs.wasNull()) {
                    return null;
                }
            }
            catch (Exception e) {
                try {
                    ret = this.parser.parse(rs.getString(columnIndex), false);
                }
                catch (Exception ee) {
                    System.err.println("cannot parse date value: \"" + rs.getString(columnIndex) + "\" Defaulting to null.\n" + ee.getMessage());
                }
            }
            return ret;
        }
    }

    public static class StringConverter
    implements ValueConverter {
        @Override
        public AttributeType getType() {
            return AttributeType.STRING;
        }

        @Override
        public Object getValue(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getString(columnIndex);
        }
    }

    public static class DoubleConverter
    implements ValueConverter {
        @Override
        public AttributeType getType() {
            return AttributeType.DOUBLE;
        }

        @Override
        public Object getValue(ResultSet rs, int columnIndex) throws SQLException {
            double value = rs.getDouble(columnIndex);
            return rs.wasNull() ? null : Double.valueOf(value);
        }
    }

    public static class IntegerConverter
    implements ValueConverter {
        @Override
        public AttributeType getType() {
            return AttributeType.INTEGER;
        }

        @Override
        public Object getValue(ResultSet rs, int columnIndex) throws SQLException {
            int value = rs.getInt(columnIndex);
            return rs.wasNull() ? null : Integer.valueOf(value);
        }
    }
}

