/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore;

import com.vividsolutions.jump.feature.AttributeType;
import java.text.Normalizer;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBWriter;

public class SQLUtil {
    private static final WKBWriter WRITER2D = new WKBWriter(2, false);
    private static final WKBWriter WRITER3D = new WKBWriter(3, false);
    private static final WKBWriter WRITER2D_SRID = new WKBWriter(2, true);
    private static final WKBWriter WRITER3D_SRID = new WKBWriter(3, true);

    public static String[] splitTableName(String fullName) {
        if (SQLUtil.isQuoted(fullName)) {
            return SQLUtil.splitQuotedTableName(fullName);
        }
        int index = fullName.indexOf(".");
        if (index == -1) {
            if (fullName.matches("(?i)^[A-Z_].*")) {
                return new String[]{null, fullName};
            }
            return new String[]{null, "\"" + fullName + "\""};
        }
        String dbSchema = fullName.substring(0, index);
        String dbTable = fullName.substring(index + 1, fullName.length());
        return new String[]{dbSchema, dbTable};
    }

    private static String[] splitQuotedTableName(String fullName) {
        int index = fullName.indexOf("\".\"");
        if (index > -1) {
            return new String[]{SQLUtil.unquote(fullName.substring(0, index)), SQLUtil.unquote(fullName.substring(index + 1, fullName.length()))};
        }
        return new String[]{null, SQLUtil.unquote(fullName)};
    }

    private static boolean isQuoted(String s) {
        return s.startsWith("\"") && s.endsWith("\"");
    }

    public static String quote(String s) {
        if (s == null) {
            return null;
        }
        if (SQLUtil.isQuoted(s)) {
            return s;
        }
        return "\"" + s + "\"";
    }

    public static String unquote(String s) {
        if (s == null) {
            return null;
        }
        if (!SQLUtil.isQuoted(s)) {
            return s;
        }
        return s.substring(1, s.length() - 1);
    }

    public static String escapeSingleQuote(String identifier) {
        return identifier == null ? null : identifier.replaceAll("'", "''");
    }

    public static String compose(String schemaName, String tableName) {
        return schemaName == null ? "\"" + tableName + "\"" : "\"" + schemaName + "\".\"" + tableName + "\"";
    }

    public static String normalize(String name) {
        if (name == null) {
            return null;
        }
        name = Normalizer.normalize(name, Normalizer.Form.NFKD);
        name = name.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        StringBuilder sb = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i == 0) {
                if (Character.isDigit(c)) {
                    sb.append("_").append(Character.toLowerCase(c));
                    continue;
                }
                if (c < '\u0080' && (Character.isLetter(c) || c == '_')) {
                    sb.append(Character.toLowerCase(c));
                    continue;
                }
                sb.append('_');
                continue;
            }
            if (c < '\u0080' && Character.isLetterOrDigit(c) || c == '_') {
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    public static byte[] getByteArrayFromGeometry(Geometry geom, int srid, int dimension) {
        WKBWriter writer;
        if (srid > 0) {
            geom.setSRID(srid);
            writer = dimension == 3 ? WRITER3D_SRID : WRITER2D_SRID;
        } else {
            writer = dimension == 3 ? WRITER3D : WRITER2D;
        }
        return writer.write(geom);
    }

    public static AttributeType getAttributeType(int sqlType, String dataTypeName) {
        if (sqlType == -5) {
            return AttributeType.LONG;
        }
        if (sqlType == -2 && dataTypeName != null && dataTypeName.toLowerCase().equals("geometry")) {
            return AttributeType.GEOMETRY;
        }
        if (sqlType == -2) {
            return AttributeType.OBJECT;
        }
        if (sqlType == -7) {
            return AttributeType.BOOLEAN;
        }
        if (sqlType == 2004) {
            return AttributeType.OBJECT;
        }
        if (sqlType == 16) {
            return AttributeType.BOOLEAN;
        }
        if (sqlType == 1) {
            return AttributeType.STRING;
        }
        if (sqlType == 2005) {
            return AttributeType.STRING;
        }
        if (sqlType == 70) {
            return AttributeType.OBJECT;
        }
        if (sqlType == 91) {
            return AttributeType.DATE;
        }
        if (sqlType == 3) {
            return AttributeType.DOUBLE;
        }
        if (sqlType == 2001) {
            return AttributeType.OBJECT;
        }
        if (sqlType == 8) {
            return AttributeType.DOUBLE;
        }
        if (sqlType == 6) {
            return AttributeType.DOUBLE;
        }
        if (sqlType == 4) {
            return AttributeType.INTEGER;
        }
        if (sqlType == 2000) {
            return AttributeType.OBJECT;
        }
        if (sqlType == -16) {
            return AttributeType.STRING;
        }
        if (sqlType == -4) {
            return AttributeType.OBJECT;
        }
        if (sqlType == -1) {
            return AttributeType.STRING;
        }
        if (sqlType == -15) {
            return AttributeType.STRING;
        }
        if (sqlType == 2011) {
            return AttributeType.STRING;
        }
        if (sqlType == 0) {
            return AttributeType.OBJECT;
        }
        if (sqlType == 2) {
            return AttributeType.DOUBLE;
        }
        if (sqlType == -9) {
            return AttributeType.STRING;
        }
        if (sqlType == 1111 && dataTypeName != null && dataTypeName.toLowerCase().equals("geometry")) {
            return AttributeType.GEOMETRY;
        }
        if (sqlType == 1111) {
            return AttributeType.OBJECT;
        }
        if (sqlType == 7) {
            return AttributeType.DOUBLE;
        }
        if (sqlType == 2006) {
            return AttributeType.OBJECT;
        }
        if (sqlType == -8) {
            return AttributeType.INTEGER;
        }
        if (sqlType == 5) {
            return AttributeType.INTEGER;
        }
        if (sqlType == 2009) {
            return AttributeType.STRING;
        }
        if (sqlType == 2002) {
            return AttributeType.OBJECT;
        }
        if (sqlType == 92) {
            return AttributeType.DATE;
        }
        if (sqlType == 93) {
            return AttributeType.DATE;
        }
        if (sqlType == -6) {
            return AttributeType.INTEGER;
        }
        if (sqlType == -3) {
            return AttributeType.OBJECT;
        }
        if (sqlType == 12) {
            return AttributeType.STRING;
        }
        throw new IllegalArgumentException("" + sqlType + " is an unknown SQLType");
    }
}

