/*
 * Created on 08.02.2005 for PIROL
 *
 * SVN header information:
 *  $Author$
 *  $Rev$
 *  $Date$
 *  $Id$
 */
package org.openjump.core.apitools;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.openjump.core.apitools.objecttyperoles.FeatureCollectionRole;
import org.openjump.core.apitools.objecttyperoles.PirolFeatureCollection;
import org.openjump.core.apitools.objecttyperoles.RoleTriangularIrregularNet;

import org.locationtech.jts.geom.Geometry;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;

import de.fho.jump.pirol.utilities.settings.PirolPlugInSettings;

/**
 * Class for more convenient use of Layer objects. Offers methods e.g. to get features that reside within
 * a given geometry or to easily add a result layer to the map.
 * 
 * @author Ole Rahn
 * 
 * FH Osnabr&uuml;ck - University of Applied Sciences Osnabr&uuml;ck
 * Project PIROL 2005
 * Daten- und Wissensmanagement
 * [sstein] - 22.Feb.2009 - modified to work in OpenJUMP
 */
public class LayerTools extends ToolToMakeYourLifeEasier {

    protected PlugInContext context;
    
    public LayerTools(PlugInContext context) {
        super();
        this.context = context;
    }
    
    public Layer[] getSelectedLayers(){
        return this.context.getSelectedLayers();
    }
    
    public List getSelectedFeatures(){
        return SelectionTools.getSelectedFeatures(this.context);
    }
    
    public Geometry getFenceGeometry(){
        return SelectionTools.getFenceGeometry(this.context);
    }
    
    public List getFeaturesInFence(){
        SelectionTools st = new SelectionTools(this.context);
        return st.getFeaturesInFence();
    }
    
    public Feature[] getFeaturesInFenceInLayer( Layer layer, Geometry fenceGeometry ){
		return SelectionTools.getFeaturesInFenceInLayer(layer, fenceGeometry);
    }
    
    public Feature[] getFeaturesInFenceInLayer( Feature[] featArray, Geometry fenceGeometry ){
		return SelectionTools.getFeaturesInFenceInLayer(featArray, fenceGeometry);
    }
    
    public int getNumSelectedLayers(){
        return LayerTools.getNumSelectedLayers(this.context);
    }
    
    public static int getNumSelectedLayers( PlugInContext context ){
        return context.getSelectedLayers().length;
    }
    
    public static Layer addStandardResultLayer( String title, FeatureCollection featCollection, PlugInContext context, FeatureCollectionRole role  ){
        return LayerTools.addStandardResultLayer(title, featCollection, Color.yellow, context, role);
    }
    
    public static Layer addAndSelectStandardResultLayer( String title, FeatureCollection featCollection, Color color,  PlugInContext context, FeatureCollectionRole role  ){
        return LayerTools.addStandardResultLayer(title, featCollection, color, context, true, role);
    }
    
    public static Layer addAndSelectStandardResultLayer( String title, FeatureCollection featCollection, PlugInContext context, FeatureCollectionRole role  ){
        return LayerTools.addStandardResultLayer(title, featCollection, Color.YELLOW, context, true, role);
    }
    
    public static Layer addStandardResultLayer( String title, FeatureCollection featCollection, Color color,  PlugInContext context, FeatureCollectionRole role  ){
        return LayerTools.addStandardResultLayer(title, featCollection, color, context, false, role);
    }
    
    public static Layer addStandardResultLayer( String title, FeatureCollection featCollection, Color color,  PlugInContext context, boolean select, FeatureCollectionRole role ){
    	//-- [sstein] 28.Feb.2009 : not needed since replace with StandardCategoryNames.RESULT
    	//if (featCollection==null || context==null || LayerTools.getResultCategory(context)==null) return null;
     	if (featCollection==null || context==null) return null;     
  
     	Layer newLayer = null;
     	//[sstein] 28.Feb.2009 - removed ! as i think it should be the other way around and I obtain an error 
        //if (!FeatureCollection.class.isInstance(featCollection)) {
        if (FeatureCollection.class.isInstance(featCollection)) {
            newLayer = new Layer( title, color, new PirolFeatureCollection(featCollection, role), context.getLayerManager());
        } else {
        	if (role != null)
        		((PirolFeatureCollection)featCollection).addRole(role);
            newLayer = new Layer( title, color, featCollection, context.getLayerManager());
        }
        
		context.getLayerManager().addLayer(StandardCategoryNames.RESULT, newLayer);
		
		if (select){
		    SelectionTools.selectLayer(context, newLayer);
		}
		
		return newLayer;
    }
    
    public Layer addStandardResultLayer( String title, FeatureCollection featCollection, FeatureCollectionRole role ){
        return LayerTools.addStandardResultLayer(title,featCollection,this.context, role);
    }
    
    public Map getLayer2FeatureMap(List features){
        return LayerTools.getLayer2FeatureMap(features, this.context);
    }
    
    public static Layer putGeometryArrayIntoMap(Geometry[] geometryArray, PlugInContext context){
        FeatureSchema fs = new FeatureSchema();
        fs.addAttribute("geometry", AttributeType.GEOMETRY);
        FeatureCollection fc = new FeatureDataset(fs);
        
        Feature f;
        for (int i=0; i<geometryArray.length; i++){
            f = new BasicFeature(fs);
            f.setGeometry(geometryArray[i]);
            fc.add(f);
        }
        
        return LayerTools.addStandardResultLayer("triangles", fc, context, new RoleTriangularIrregularNet());
    }
    
    public static Map<Layer,List<Feature>> getLayer2FeatureMap(List<Feature> features, PlugInContext context){
        List<Layer> layers = context.getLayerManager().getVisibleLayers(false);
        
        Map<Layer,List<Feature>> layer2FeatList = new HashMap<>();
        List<Feature> layerFeats;

        for (Layer layer : layers){
            layerFeats = layer.getFeatureCollectionWrapper().getUltimateWrappee().getFeatures();
            for (Feature feat : features){

                if (layerFeats.contains(feat)){
                    if (!layer2FeatList.containsKey(layer)){
                        layer2FeatList.put(layer, new ArrayList<Feature>());
                    }
                    layer2FeatList.get(layer).add(feat);
                }
            }
        }
        return layer2FeatList;
    }
    
    public Category getResultCategory(){
        return LayerTools.getResultCategory(this.context);
    }
    
    public static Category getResultCategory( PlugInContext context ){
        Category category = context.getLayerManager().getCategory(PirolPlugInSettings.resultLayerCategory());
		
		if ( category == null ){
			context.getLayerManager().addCategory(PirolPlugInSettings.resultLayerCategory(), 0);
			category = context.getLayerManager().getCategory(PirolPlugInSettings.resultLayerCategory());
		}
		
		return category;
    } 
    
    /**
	 * Get a given number of selected Layers.
	 * @param context the current PlugInContext
	 * @param num max. number of layers to return, -1 returns all selected layers
	 * @return a given number of selected Layers, null if no Layers are selected
	 */
	public static Layer[] getSelectedLayers(PlugInContext context, int num){
	    Layer[] selLayers = context.getSelectedLayers();

	    if (selLayers.length==0){
		    return null;
		} else if (num <= 0){
		    return selLayers;
		} else {
		    Layer[] result = new Layer[num];
		    
		    for ( int i=0; i<selLayers.length && i<result.length; i++ ){
		        result[i] = selLayers[i];
		    }
		    
		    return result;
		}
	}
	
	/**
	 * get one Layer that is selected
	 * @param context the current PlugInContext
	 * @return one selected Layer, null if no Layers are selected
	 */
	public static Layer getSelectedLayer(PlugInContext context){
	    Layer[] selLayers = LayerTools.getSelectedLayers(context, 1);
	    
	    if (selLayers==null || selLayers.length==0){
	        return null;
	    }
	    return selLayers[0];
	}
    
    /**
     * get one Layer that is selected
     * @param context the current PlugInContext
     * @return one selected Layer, null if no Layers are selected
     */
    public static Layerable getSelectedLayerable(PlugInContext context, Class layerableClass){
        
        Collection selLayers = context.getLayerNamePanel().selectedNodes(layerableClass);
        
        if (selLayers==null || selLayers.size() == 0){
            return null;
        }
        
        return ((Layerable[])selLayers.toArray(new Layerable[0]))[0];
    }
    
    /**
     * get one Layer that is selected
     * @param context the current WorkbenchContext
     * @return one selected Layer, null if no Layers are selected
     */
    public static Layerable getSelectedLayerable(WorkbenchContext context, Class layerableClass){
        
        Collection selLayers = context.getLayerableNamePanel().selectedNodes(layerableClass);
        
        if (selLayers==null || selLayers.size() == 0){
            return null;
        }
        
        return ((Layerable[])selLayers.toArray(new Layerable[0]))[0];
    }
    
    /**
     * returns a layername, that is not yet used in the layername panel
     */
    public static String getUniqueLayerName(PlugInContext context, String name){
        
        return context.getLayerManager().uniqueLayerName(name);
    }
    
}
