/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.util;

import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.workbench.Logger;
import java.lang.reflect.Constructor;
import java.security.InvalidParameterException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class GeometryUtils {
    public static void scaleGeometry(Geometry geometry, final double scale) {
        final Coordinate center = geometry.getCentroid().getCoordinate();
        geometry.apply(new CoordinateFilter(){

            public void filter(Coordinate coordinate) {
                coordinate.x = center.x + scale / 100.0 * (coordinate.x - center.x);
                coordinate.y = center.y + scale / 100.0 * (coordinate.y - center.y);
            }
        });
    }

    public static void rotateGeometry(Geometry geometry, final double angle) {
        final Coordinate center = geometry.getCentroid().getCoordinate();
        geometry.apply(new CoordinateFilter(){

            public void filter(Coordinate coordinate) {
                double cosAngle = Math.cos(angle);
                double sinAngle = Math.sin(angle);
                double x = coordinate.x - center.x;
                double y = coordinate.y - center.y;
                coordinate.x = center.x + x * cosAngle - y * sinAngle;
                coordinate.y = center.y + y * cosAngle + x * sinAngle;
            }
        });
    }

    public static void rotateGeometry(Geometry geometry, int angle) {
        final Coordinate center = geometry.getCentroid().getCoordinate();
        double Deg2Rad = 0.0174532925199432;
        double radiansAngle = 0.0;
        radiansAngle = Deg2Rad * (double)(-angle);
        final double cosAngle = Math.cos(radiansAngle);
        final double sinAngle = Math.sin(radiansAngle);
        geometry.apply(new CoordinateFilter(){

            public void filter(Coordinate coordinate) {
                double x = coordinate.x - center.x;
                double y = coordinate.y - center.y;
                coordinate.x = center.x + x * cosAngle - y * sinAngle;
                coordinate.y = center.y + y * cosAngle + x * sinAngle;
            }
        });
    }

    public static void centerGeometry(Geometry geometry, final Coordinate displacement) {
        geometry.apply(new CoordinateFilter(){

            public void filter(Coordinate coordinate) {
                coordinate.setCoordinate(CoordUtil.add(coordinate, displacement));
            }
        });
    }

    public static Geometry createEmptyGeometry(Class geometryClass, GeometryFactory geometryFactory) {
        if (geometryClass == null) {
            throw new InvalidParameterException("Class must not be null");
        }
        if (geometryFactory == null) {
            geometryFactory = new GeometryFactory();
        }
        try {
            for (Constructor<?> c : geometryClass.getConstructors()) {
                Class<?>[] paramTypes = c.getParameterTypes();
                int paramCount = paramTypes.length;
                if (paramCount <= 0 || paramTypes[paramCount - 1] != GeometryFactory.class) continue;
                Object[] params = new Object[paramCount];
                params[paramCount - 1] = geometryFactory;
                return (Geometry)c.newInstance(params);
            }
        }
        catch (Exception e) {
            Logger.debug(e);
        }
        return null;
    }

    public static Geometry createEmptyGeometry(String geometryName, GeometryFactory geometryFactory) throws ClassNotFoundException {
        Class<?> geometryClass = Class.forName("org.locationtech.jts.geom." + geometryName);
        return GeometryUtils.createEmptyGeometry(geometryClass, geometryFactory);
    }
}

