/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.wms.BoundingBox;
import com.vividsolutions.wms.Capabilities;
import com.vividsolutions.wms.MapLayer;
import com.vividsolutions.wms.WMService;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class ZoomToWMSPlugIn
extends AbstractPlugIn {
    private PlugInContext context;
    private String[] columnNames = null;
    private Object[][] values = null;
    private JTable infoTable = null;
    private TableColumnModel tcm = null;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.context = context;
        EnableCheckFactory enableCheckFactory = context.getCheckFactory();
        MultiEnableCheck enableCheck = new MultiEnableCheck().add(enableCheckFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(enableCheckFactory.createWindowWithLayerManagerMustBeActiveCheck());
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.VIEW}, I18N.getInstance().get("org.openjump.core.ui.plugin.wms.ZoomToWMSPlugIn.zoom-to-wms-layer") + "{pos:8}", false, null, enableCheck);
        context.getFeatureInstaller().addPopupMenuPlugin(context.getWorkbenchFrame().getWMSLayerNamePopupMenu(), this, I18N.getInstance().get("org.openjump.core.ui.plugin.wms.ZoomToWMSPlugIn.zoom-to-wms-layer"), false, null, enableCheck);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.context = context;
        List<MapLayer> mapLayerOfChoosenLayers = this.getMapLayerOfChoosenLayers(context);
        if (mapLayerOfChoosenLayers == null) {
            return false;
        }
        String selectedSRS = this.getSelectedSRS(context);
        Map<String, BoundingBox> boundingBoxesForSRS = this.getBoundingBoxesForSRS(mapLayerOfChoosenLayers, selectedSRS);
        this.zoomToBoundingBox(context, boundingBoxesForSRS, selectedSRS);
        return true;
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.wms.ZoomToWMSPlugIn.zoom-to-wms-layer");
    }

    private WMSLayer[] getSelectedWMSLayer(PlugInContext context) {
        Collection<WMSLayer> listWMS = context.getLayerNamePanel().selectedNodes(WMSLayer.class);
        Object[] obWMSLayer = listWMS.toArray();
        int selectionSize = obWMSLayer.length;
        if (selectionSize <= 0) {
            return null;
        }
        WMSLayer[] wmsLayer = new WMSLayer[selectionSize];
        for (int i = 0; i < selectionSize; ++i) {
            wmsLayer[i] = (WMSLayer)obWMSLayer[i];
        }
        return wmsLayer;
    }

    private String[] getSelectedWMSLayerNames(PlugInContext context) {
        WMSLayer[] wmsLayers = this.getSelectedWMSLayer(context);
        if (wmsLayers == null) {
            return new String[0];
        }
        int size = wmsLayers.length;
        String[] selectedWMSLayerNames = new String[size];
        for (int i = 0; i < size; ++i) {
            selectedWMSLayerNames[i] = wmsLayers[i].getName();
        }
        return selectedWMSLayerNames;
    }

    private List<MapLayer> getMapLayerOfChoosenLayers(PlugInContext context) throws Exception {
        ArrayList<MapLayer> mapLayerOfChoosenLayers = new ArrayList<MapLayer>();
        ArrayList<String> wmsLayerNames = new ArrayList<String>();
        WMSLayer[] wmsLayers = this.getSelectedWMSLayer(context);
        if (wmsLayers == null) {
            JOptionPane.showMessageDialog(context.getWorkbenchFrame(), I18N.getInstance().get("org.openjump.core.ui.plugin.wms.ZoomToWMSPlugIn.no-wms-layer-selected"));
            return null;
        }
        for (WMSLayer wmsLayer : wmsLayers) {
            wmsLayerNames.addAll(wmsLayer.getLayerNames());
        }
        List<MapLayer> allLayers = this.getAllMapLayer(context);
        for (String wmsLayerName : wmsLayerNames) {
            for (MapLayer mapLayer : allLayers) {
                String mapLayerTitle = mapLayer.getTitle();
                String mapLayerName = mapLayer.getName();
                if (mapLayerTitle != null && mapLayerName != null) {
                    if (!mapLayerTitle.contains(wmsLayerName) && !mapLayerName.contains(wmsLayerName)) continue;
                    mapLayerOfChoosenLayers.add(mapLayer);
                    continue;
                }
                if (mapLayerTitle != null) {
                    if (!mapLayerTitle.contains(wmsLayerName)) continue;
                    mapLayerOfChoosenLayers.add(mapLayer);
                    continue;
                }
                if (mapLayerName == null || !mapLayerName.contains(wmsLayerName)) continue;
                mapLayerOfChoosenLayers.add(mapLayer);
            }
        }
        return mapLayerOfChoosenLayers;
    }

    private String getSelectedSRS(PlugInContext context) {
        String selectedSRS = "0";
        WMSLayer[] wmsLayers = this.getSelectedWMSLayer(context);
        if (wmsLayers != null) {
            for (WMSLayer wmsLayer : wmsLayers) {
                selectedSRS = wmsLayer.getSRS().toLowerCase();
            }
        }
        return selectedSRS;
    }

    private Map<String, BoundingBox> getBoundingBoxesForSRS(List<MapLayer> mapLayerList, String srs) {
        HashMap<String, BoundingBox> boundingBoxesForSRS = new HashMap<String, BoundingBox>();
        for (MapLayer mapLayer : mapLayerList) {
            int anzBB;
            List<BoundingBox> boundingBoxList = mapLayer.getAllBoundingBoxList();
            BoundingBox latLonBoundingBox = mapLayer.getLatLonBoundingBox();
            if (latLonBoundingBox != null) {
                boundingBoxList.add(latLonBoundingBox);
            }
            if ((anzBB = boundingBoxList.size()) == 0) {
                System.out.println(I18N.getInstance().get("org.openjump.core.ui.plugin.wms.ZoomToWMSPlugIn.no-bounding-box") + mapLayer.getTitle());
                continue;
            }
            HashSet<String> doppelt = new HashSet<String>();
            int zaehler = 0;
            for (BoundingBox bbox : boundingBoxList) {
                String tmpSRS = bbox.getSRS().toLowerCase();
                if (tmpSRS.contains("latlon")) {
                    tmpSRS = "epsg:4326";
                }
                if (!tmpSRS.equals(srs.toLowerCase())) continue;
                String key = mapLayer.getTitle();
                if (!doppelt.add(key)) {
                    key = key + " (" + ++zaehler + ")";
                }
                boundingBoxesForSRS.put(key, bbox);
            }
        }
        return boundingBoxesForSRS;
    }

    private JComboBox<String> makeComboBox(Map<String, BoundingBox> boundingBoxesForSRS) {
        JComboBox<Object> comboBox = new JComboBox<String>();
        if (boundingBoxesForSRS.size() > 0) {
            Object[] keys = boundingBoxesForSRS.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            comboBox = new JComboBox<Object>(keys);
        } else {
            comboBox.addItem(I18N.getInstance().get("org.openjump.core.ui.plugin.wms.ZoomToWMSPlugIn.no-bounding-boxes-available"));
        }
        return comboBox;
    }

    private void zoomToBoundingBox(PlugInContext context, Map<String, BoundingBox> boundingBoxesForSRS, String selectedSRS) throws Exception {
        JComboBox<String> comboBox = this.makeComboBox(boundingBoxesForSRS);
        JPanel jp = new JPanel();
        JButton jb = new JButton("?");
        jb.setActionCommand("showInfoTable");
        jb.addActionListener(new AL());
        String tmpLatLon = "";
        if (selectedSRS.contains("4326")) {
            tmpLatLon = " (LatLon)";
        }
        jp.add(comboBox);
        jp.add(jb);
        int back = JOptionPane.showConfirmDialog(context.getWorkbenchFrame(), jp, I18N.getInstance().get("org.openjump.core.ui.plugin.wms.ZoomToWMSPlugIn.bounding-box-for") + " " + selectedSRS + tmpLatLon, 2, 1);
        if (back == 2 || back < 0) {
            return;
        }
        BoundingBox selectedBB = boundingBoxesForSRS.get(comboBox.getSelectedItem());
        if (selectedBB == null) {
            return;
        }
        String message = selectedBB.toString();
        context.getWorkbenchFrame().setStatusMessage(message);
        Coordinate min = new Coordinate(selectedBB.getWestBound(), selectedBB.getSouthBound());
        Coordinate max = new Coordinate(selectedBB.getEastBound(), selectedBB.getNorthBound());
        Envelope env = new Envelope(min, max);
        context.getLayerViewPanel().getViewport().zoom(env);
        context.getLayerViewPanel().fireSelectionChanged();
        JInternalFrame intFrame = context.getActiveInternalFrame();
        intFrame.updateUI();
    }

    private List<MapLayer> getAllMapLayer(PlugInContext context) throws Exception {
        WMSLayer[] wmsLayers = this.getSelectedWMSLayer(context);
        if (wmsLayers == null || wmsLayers.length == 0) {
            return new ArrayList<MapLayer>();
        }
        WMService wmService = wmsLayers[0].getService();
        Capabilities cap = wmService.getCapabilities();
        MapLayer topLayer = cap.getTopLayer();
        return topLayer.getLayerList();
    }

    private void showInformationTable(PlugInContext context) throws Exception {
        this.values = this.getMapLayerInformationForTable(context);
        this.columnNames = MapLayerAttributes.getColumnNames();
        InfoTableModel itm = new InfoTableModel();
        this.infoTable = new JTable(itm);
        JTableHeader th = this.infoTable.getTableHeader();
        th.setReorderingAllowed(false);
        th.addMouseListener(new MASort());
        this.tcm = this.infoTable.getColumnModel();
        TableColumn tc0 = this.tcm.getColumn(0);
        TableColumn tc1 = this.tcm.getColumn(1);
        TableColumn tc2 = this.tcm.getColumn(2);
        TableColumn tc3 = this.tcm.getColumn(3);
        TableColumn tc4 = this.tcm.getColumn(4);
        TableColumn tc5 = this.tcm.getColumn(5);
        TableColumn tc6 = this.tcm.getColumn(6);
        tc0.setMinWidth(160);
        tc1.setMinWidth(120);
        tc2.setMinWidth(70);
        tc3.setMinWidth(90);
        tc4.setMinWidth(90);
        tc5.setMinWidth(90);
        tc6.setMinWidth(90);
        th.setResizingAllowed(true);
        this.infoTable.setAutoResizeMode(0);
        JScrollPane infoTableSc = new JScrollPane(this.infoTable);
        infoTableSc.setPreferredSize(new Dimension(735, 300));
        JOptionPane.showMessageDialog(context.getWorkbenchFrame(), infoTableSc, "InfoTable", 1);
    }

    private void sortTable(int sortAfter) {
        Object[] mapLayerAttributes = this.toMapLayerAttributesArray(this.values);
        MapLayerAttributes.setSortAfter(sortAfter);
        Arrays.sort(mapLayerAttributes);
        this.getMapLayerInformationForTable((MapLayerAttributes[])mapLayerAttributes);
        this.infoTable.updateUI();
    }

    private Object[][] getMapLayerInformationForTable(PlugInContext context) throws Exception {
        MapLayerAttributes mapLayerAttr = new MapLayerAttributes();
        ArrayList<MapLayerAttributes> mapLayerRows = new ArrayList<MapLayerAttributes>();
        List<MapLayer> mapLayerList = this.getAllMapLayer(context);
        if (mapLayerList == null) {
            return null;
        }
        int anzLayer = mapLayerList.size();
        if (anzLayer == 0) {
            return null;
        }
        for (MapLayer mapLayer : mapLayerList) {
            mapLayerRows.addAll(mapLayerAttr.getMapLayerRows(mapLayer));
        }
        int anzRows = mapLayerRows.size();
        int anzColumns = MapLayerAttributes.getColumnNames().length;
        Object[][] mapLayerInformationForTable = new Object[anzRows][anzColumns];
        for (int k = 0; k < anzRows; ++k) {
            MapLayerAttributes mLA = (MapLayerAttributes)mapLayerRows.get(k);
            Object[] attrib = mLA.toObjectArray();
            mapLayerInformationForTable[k] = attrib;
        }
        return mapLayerInformationForTable;
    }

    private void getMapLayerInformationForTable(MapLayerAttributes[] mapLayerAttributesArray) {
        for (MapLayerAttributes mLA : mapLayerAttributesArray) {
            Object[] attrib = mLA.toObjectArray();
            this.values[k] = attrib;
        }
    }

    private MapLayerAttributes[] toMapLayerAttributesArray(Object[][] m) {
        if (m == null) {
            return null;
        }
        int numRows = m.length;
        MapLayerAttributes[] mapLayerAttributesArray = new MapLayerAttributes[numRows];
        for (int i = 0; i < numRows; ++i) {
            String title = (String)m[i][0];
            String name = (String)m[i][1];
            String srs = (String)m[i][2];
            double minx = (Double)m[i][3];
            double miny = (Double)m[i][4];
            double maxx = (Double)m[i][5];
            double maxy = (Double)m[i][6];
            mapLayerAttributesArray[i] = new MapLayerAttributes(title, name, srs, minx, miny, maxx, maxy);
        }
        return mapLayerAttributesArray;
    }

    private Envelope envelopeOfSelectedLayers(PlugInContext context) {
        Envelope envelope = new Envelope();
        Iterator<WMSLayer> iterator = context.getLayerNamePanel().selectedNodes(WMSLayer.class).iterator();
        while (iterator.hasNext()) {
            WMSLayer object;
            WMSLayer layer = object = iterator.next();
            Envelope env = layer.getEnvelope();
            boolean goodEnv = true;
            if (env == null) {
                goodEnv = false;
            }
            if (goodEnv) {
                boolean bl = goodEnv = env.getHeight() > 0.0 && env.getWidth() > 0.0;
            }
            if (goodEnv) {
                envelope.expandToInclude(layer.getEnvelope());
                continue;
            }
            context.getWorkbenchFrame().getOutputFrame().createNewDocument();
            context.getWorkbenchFrame().getOutputFrame().addText("Could not determine zoom envelope for layer: " + layer.getName());
        }
        return envelope;
    }

    class MASort
    extends MouseAdapter {
        MASort() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.getButton() == 3) {
                int viewColumn = ZoomToWMSPlugIn.this.tcm.getColumnIndexAtX(me.getX());
                int column = ZoomToWMSPlugIn.this.infoTable.convertColumnIndexToModel(viewColumn);
                if (column == 0) {
                    ZoomToWMSPlugIn.this.sortTable(1);
                } else if (column == 1) {
                    ZoomToWMSPlugIn.this.sortTable(2);
                } else if (column == 2) {
                    ZoomToWMSPlugIn.this.sortTable(3);
                } else if (column == 3) {
                    ZoomToWMSPlugIn.this.sortTable(4);
                } else if (column == 4) {
                    ZoomToWMSPlugIn.this.sortTable(5);
                } else if (column == 5) {
                    ZoomToWMSPlugIn.this.sortTable(6);
                } else if (column == 6) {
                    ZoomToWMSPlugIn.this.sortTable(7);
                }
            }
        }
    }

    class InfoTableModel
    extends AbstractTableModel {
        InfoTableModel() {
        }

        @Override
        public int getColumnCount() {
            return ZoomToWMSPlugIn.this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return ZoomToWMSPlugIn.this.values.length;
        }

        @Override
        public String getColumnName(int col) {
            return ZoomToWMSPlugIn.this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return ZoomToWMSPlugIn.this.values[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    public static class MapLayerAttributes
    implements Comparable {
        public static final int SORT_UP = 1;
        public static final int SORT_DOWN = -1;
        public static final int SORT_AFTER_TITLE = 1;
        public static final int SORT_AFTER_NAME = 2;
        public static final int SORT_AFTER_SRS = 3;
        public static final int SORT_AFTER_MINX = 4;
        public static final int SORT_AFTER_MINY = 5;
        public static final int SORT_AFTER_MAXX = 6;
        public static final int SORT_AFTER_MAXY = 7;
        public static int[] sortUpDown = new int[]{-1, -1, -1, -1, -1, -1, -1};
        public static int sortAfter;
        String srs;
        String name;
        String title;
        double minx;
        double miny;
        double maxx;
        double maxy;

        MapLayerAttributes() {
            this.srs = " ";
            this.name = "Unknown";
            this.title = "Unknown";
            this.minx = 0.0;
            this.miny = 0.0;
            this.maxx = 0.0;
            this.maxy = 0.0;
        }

        MapLayerAttributes(String title, String name, String srs, double minx, double miny, double maxx, double maxy) {
            this.title = title;
            this.name = name;
            this.srs = srs;
            this.minx = minx;
            this.miny = miny;
            this.maxx = maxx;
            this.maxy = maxy;
        }

        public int compareTo(Object object) {
            int ret = 1;
            MapLayerAttributes mla = (MapLayerAttributes)object;
            if (sortAfter == 1) {
                ret = this.title.compareTo(mla.title) * sortUpDown[0];
            } else if (sortAfter == 2) {
                ret = this.name.compareTo(mla.name) * sortUpDown[1];
            } else if (sortAfter == 3) {
                ret = this.srs.compareTo(mla.srs) * sortUpDown[2];
            } else if (sortAfter == 4) {
                ret = this.minx > mla.minx ? 1 * sortUpDown[3] : -1 * sortUpDown[3];
            } else if (sortAfter == 5) {
                ret = this.miny > mla.miny ? 1 * sortUpDown[4] : -1 * sortUpDown[4];
            } else if (sortAfter == 6) {
                ret = this.maxx > mla.maxx ? 1 * sortUpDown[5] : -1 * sortUpDown[5];
            } else if (sortAfter == 7) {
                ret = this.maxy > mla.maxy ? 1 * sortUpDown[6] : -1 * sortUpDown[6];
            }
            return ret;
        }

        double cutDouble(double value, int afterComma) {
            double mulQuot = Math.pow(10.0, afterComma);
            long tmp = (long)(value * mulQuot);
            return (double)tmp / mulQuot;
        }

        public static String[] getColumnNames() {
            return new String[]{"Title", "Name", "SRS", "MinX", "MinY", "MaxX", "MaxY"};
        }

        List<MapLayerAttributes> getMapLayerRows(MapLayer mapLayer) {
            String title;
            String unknown = "Unknown";
            ArrayList<MapLayerAttributes> mapLayerRows = new ArrayList<MapLayerAttributes>();
            String name = mapLayer.getName();
            if (name == null) {
                name = unknown;
            }
            if ((title = mapLayer.getTitle()) == null) {
                title = unknown;
            }
            List<BoundingBox> boundingBoxList = mapLayer.getAllBoundingBoxList();
            for (BoundingBox bbox : boundingBoxList) {
                double maxY;
                double maxX;
                double minY;
                double minX;
                String srs;
                if (bbox == null) {
                    srs = unknown;
                    minX = 0.0;
                    minY = 0.0;
                    maxX = 400.0;
                    maxY = 400.0;
                } else {
                    srs = bbox.getSRS().toLowerCase();
                    minX = bbox.getWestBound();
                    minY = bbox.getSouthBound();
                    maxX = bbox.getEastBound();
                    maxY = bbox.getNorthBound();
                }
                mapLayerRows.add(new MapLayerAttributes(title, name, srs, minX, minY, maxX, maxY));
            }
            return mapLayerRows;
        }

        String getName() {
            return this.name;
        }

        String getTitle() {
            return this.title;
        }

        String getSRS() {
            return this.srs;
        }

        double getMinx() {
            return this.minx;
        }

        double getMiny() {
            return this.miny;
        }

        double getMaxx() {
            return this.maxx;
        }

        double getMaxy() {
            return this.maxy;
        }

        Object[] toObjectArray() {
            int anzColumns = MapLayerAttributes.getColumnNames().length;
            Object[] objectArray = new Object[anzColumns];
            objectArray[0] = this.getTitle();
            objectArray[1] = this.getName();
            objectArray[2] = this.getSRS();
            objectArray[3] = Double.valueOf(String.valueOf(this.getMinx()));
            objectArray[4] = Double.valueOf(String.valueOf(this.getMiny()));
            objectArray[5] = Double.valueOf(String.valueOf(this.getMaxx()));
            objectArray[6] = Double.valueOf(String.valueOf(this.getMaxy()));
            return objectArray;
        }

        public static void setSortAfter(int sortAfter) {
            if (sortAfter == 1) {
                MapLayerAttributes.sortUpDown[0] = -1 * sortUpDown[0];
            }
            if (sortAfter == 2) {
                MapLayerAttributes.sortUpDown[1] = -1 * sortUpDown[1];
            }
            if (sortAfter == 3) {
                MapLayerAttributes.sortUpDown[2] = -1 * sortUpDown[2];
            }
            if (sortAfter == 4) {
                MapLayerAttributes.sortUpDown[3] = -1 * sortUpDown[3];
            }
            if (sortAfter == 5) {
                MapLayerAttributes.sortUpDown[4] = -1 * sortUpDown[4];
            }
            if (sortAfter == 6) {
                MapLayerAttributes.sortUpDown[5] = -1 * sortUpDown[5];
            }
            if (sortAfter == 7) {
                MapLayerAttributes.sortUpDown[6] = -1 * sortUpDown[6];
            }
            MapLayerAttributes.sortAfter = sortAfter;
        }
    }

    public class AL
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getActionCommand().equals("showInfoTable")) {
                try {
                    ZoomToWMSPlugIn.this.showInformationTable(ZoomToWMSPlugIn.this.context);
                }
                catch (Exception e) {
                    System.out.println("Error in AL");
                }
            }
        }
    }
}

