/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.view;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.InfoFrame;
import com.vividsolutions.jump.workbench.ui.OptionsDialog;
import com.vividsolutions.jump.workbench.ui.OptionsPanel;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.ViewAttributesPlugIn;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.SimpleDateFormat;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ViewOptionsPlugIn
extends AbstractPlugIn {
    public static final String DATE_FORMAT_KEY = ViewOptionsPlugIn.class.getName() + " - DATE_FORMAT_KEY";
    public static final String SELECTION_SYNC_KEY = ViewOptionsPlugIn.class.getName() + " - SELECTION_SYNCHRONIZATION";
    private static final String VIEW_OPTIONS = I18N.getInstance().get("org.openjump.core.ui.plugin.view.ViewOptionsPlugIn");
    private static final String ATTRIBUTES_FORMAT = I18N.getInstance().get("org.openjump.core.ui.plugin.view.ViewOptionsPlugIn.Attributes-format-in-attribute-table");
    private static final String DATE_FORMAT = I18N.getInstance().get("org.openjump.core.ui.plugin.view.ViewOptionsPlugIn.Date-format");
    private JComboBox dateFormatChooser;
    private static final String SELECTION_SYNCHRONIZATION = I18N.getInstance().get("org.openjump.core.ui.plugin.view.ViewOptionsPlugIn.Selection-synchronization");
    private static final String SYNC = I18N.getInstance().get("org.openjump.core.ui.plugin.view.ViewOptionsPlugIn.Synchronize");
    private JCheckBox synchronizationCheckBox;
    private Blackboard blackBoard;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.blackBoard = PersistentBlackboardPlugIn.get(context.getWorkbenchContext());
        ViewOptionsPanel viewOptionsPanel = new ViewOptionsPanel(context);
        viewOptionsPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.dateFormatChooser = new JComboBox<String>(new String[]{"yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd", "hh:mm:ss", "dd/MM/yyyy", "dd/MM/yyyy HH:mm:ss"});
        this.dateFormatChooser.setEnabled(true);
        this.dateFormatChooser.setEditable(true);
        this.synchronizationCheckBox = new JCheckBox();
        c.gridx = 0;
        c.gridy = 0;
        c.ipadx = 10;
        c.ipady = 10;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridwidth = 2;
        viewOptionsPanel.add((Component)new JPanel(), c);
        ++c.gridy;
        c.gridwidth = 2;
        c.anchor = 17;
        viewOptionsPanel.add((Component)new JLabel(ATTRIBUTES_FORMAT), c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.anchor = 13;
        viewOptionsPanel.add((Component)new JLabel(DATE_FORMAT), c);
        c.gridx = 1;
        c.anchor = 17;
        viewOptionsPanel.add((Component)this.dateFormatChooser, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        viewOptionsPanel.add((Component)new JPanel(), c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.anchor = 17;
        viewOptionsPanel.add((Component)new JLabel(SELECTION_SYNCHRONIZATION), c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.anchor = 13;
        viewOptionsPanel.add((Component)new JLabel(SYNC), c);
        c.gridx = 1;
        c.anchor = 17;
        viewOptionsPanel.add((Component)this.synchronizationCheckBox, c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 1.0;
        c.fill = 3;
        viewOptionsPanel.add((Component)new JPanel(), c);
        OptionsDialog.instance(context.getWorkbenchContext().getWorkbench()).addTab(VIEW_OPTIONS, viewOptionsPanel);
    }

    class ViewOptionsPanel
    extends JPanel
    implements OptionsPanel {
        PlugInContext context;

        ViewOptionsPanel(PlugInContext context) {
            this.context = context;
        }

        @Override
        public String validateInput() {
            try {
                new SimpleDateFormat(ViewOptionsPlugIn.this.dateFormatChooser.getSelectedItem().toString());
                return null;
            }
            catch (IllegalArgumentException e) {
                return e.getMessage();
            }
        }

        @Override
        public void okPressed() {
            JInternalFrame[] frames;
            ViewOptionsPlugIn.this.blackBoard.put(DATE_FORMAT_KEY, ViewOptionsPlugIn.this.dateFormatChooser.getSelectedItem().toString());
            for (JInternalFrame frame : frames = this.context.getWorkbenchFrame().getInternalFrames()) {
                if (!(frame instanceof InfoFrame) && !(frame instanceof ViewAttributesPlugIn.ViewAttributesFrame)) continue;
                frame.repaint();
            }
            ViewOptionsPlugIn.this.blackBoard.put(SELECTION_SYNC_KEY, ViewOptionsPlugIn.this.synchronizationCheckBox.isSelected());
        }

        @Override
        public void init() {
            Object persistedFormat = ViewOptionsPlugIn.this.blackBoard.get(DATE_FORMAT_KEY);
            if (persistedFormat != null) {
                ViewOptionsPlugIn.this.dateFormatChooser.setSelectedItem(PersistentBlackboardPlugIn.get(this.context.getWorkbenchContext()).get(DATE_FORMAT_KEY));
            } else {
                ViewOptionsPlugIn.this.dateFormatChooser.setSelectedIndex(0);
            }
            Object sync = ViewOptionsPlugIn.this.blackBoard.get(SELECTION_SYNC_KEY);
            if (sync != null) {
                ViewOptionsPlugIn.this.synchronizationCheckBox.setSelected(Boolean.parseBoolean(sync.toString()));
            } else {
                ViewOptionsPlugIn.this.synchronizationCheckBox.setSelected(true);
            }
        }
    }
}

