/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.view;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelListener;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelListener;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class ShowFullPathPlugIn
extends AbstractPlugIn {
    PlugInContext gContext;
    static final String sErrorSeeOutputWindow = I18N.getInstance().get("org.openjump.core.ui.plugin.view.ShowFullPathPlugIn.Error-See-Output-Window");
    static final String sNumberSelected = I18N.getInstance().get("org.openjump.core.ui.plugin.view.ShowFullPathPlugIn.NumberSelected");
    private LayerNamePanelListener layerNamePanelListener = new LayerNamePanelListener(){

        @Override
        public void layerSelectionChanged() {
            List<Layer> layerCollection = ShowFullPathPlugIn.this.gContext.getWorkbenchContext().getLayerNamePanel().getLayerManager().getLayers();
            for (Layer layer : layerCollection) {
                if (!layer.hasReadableDataSource()) continue;
                DataSourceQuery dsq = layer.getDataSourceQuery();
                String fname = "";
                Object fnameObj = dsq.getDataSource().getProperties().get("File");
                if (fnameObj != null) {
                    fname = fnameObj.toString();
                }
                Object object = layer.getBlackboard().get("ArchiveFileName");
            }
        }
    };
    private LayerViewPanelListener layerViewPanelListener = new LayerViewPanelListener(){

        @Override
        public void selectionChanged() {
            LayerViewPanel panel = ShowFullPathPlugIn.this.gContext.getWorkbenchContext().getLayerViewPanel();
            if (panel == null) {
                return;
            }
            Collection<Geometry> selectedFeatures = panel.getSelectionManager().getSelectedItems();
            int numSel = selectedFeatures.size();
            int numPts = 0;
            Iterator<Geometry> i = selectedFeatures.iterator();
            while (i.hasNext()) {
                numPts += i.next().getNumPoints();
            }
            Envelope env = ShowFullPathPlugIn.this.envelope(panel.getSelectionManager().getSelectedItems());
            String sx = panel.format(env.getWidth());
            String sy = panel.format(env.getHeight());
            ShowFullPathPlugIn.this.gContext.getWorkbenchFrame().setTimeMessage(sNumberSelected + " " + numSel + " [" + numPts + " pts]");
        }

        @Override
        public void cursorPositionChanged(String x, String y) {
        }

        @Override
        public void painted(Graphics graphics) {
        }
    };

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.gContext = context;
        context.getWorkbenchFrame().getDesktopPane().addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component child = e.getChild();
                if (child.getClass().getName().equals("com.vividsolutions.jump.workbench.ui.TaskFrame")) {
                    ((TaskFrame)child).getLayerNamePanel().addListener(ShowFullPathPlugIn.this.layerNamePanelListener);
                    ((TaskFrame)child).getLayerViewPanel().addListener(ShowFullPathPlugIn.this.layerViewPanelListener);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component child = e.getChild();
                if (child.getClass().getName().equals("com.vividsolutions.jump.workbench.ui.TaskFrame")) {
                    ((TaskFrame)child).getLayerNamePanel().removeListener(ShowFullPathPlugIn.this.layerNamePanelListener);
                    ((TaskFrame)child).getLayerViewPanel().removeListener(ShowFullPathPlugIn.this.layerViewPanelListener);
                }
            }
        });
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        try {
            return true;
        }
        catch (Exception e) {
            context.getWorkbenchFrame().warnUser(I18N.getInstance().get("org.openjump.core.ui.plugin.layer.AddSIDLayerPlugIn.Error-See-Output-Window"));
            context.getWorkbenchFrame().getOutputFrame().createNewDocument();
            context.getWorkbenchFrame().getOutputFrame().addText("ShowFullPathPlugIn Exception:" + e.toString());
            return false;
        }
    }

    private Envelope envelope(Collection geometries) {
        Envelope envelope = new Envelope();
        for (Geometry geometry : geometries) {
            envelope.expandToInclude(geometry.getEnvelopeInternal());
        }
        return envelope;
    }
}

