/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.view;

import com.vividsolutions.jump.util.MathUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.SimpleRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;

public class NorthArrowRenderer
extends SimpleRenderer {
    public static final String CONTENT_ID = "NORTH_ARROW";
    private static final String ENABLED_KEY = NorthArrowRenderer.class + " - ENABLED";
    private int ARROW_SIZE = 100;
    private Color FILL2 = Color.white;
    private Color FILL1 = new Color(255, 204, 204);
    private int HORIZONTAL_MARGIN = 8;
    private int VERTICAL_MARGIN = 15;
    private Color LINE_COLOR = Color.black;
    private int TEXT_BOTTOM_MARGIN = 3;
    private Color TEXT_COLOR = Color.blue;
    private int TEXT_FONT_SIZE = 15;
    private Font FONT = new Font("Dialog", 1, this.TEXT_FONT_SIZE);
    private Stroke stroke = new BasicStroke();
    private final int ALIGN_BOTTOM_RIGHT = 0;
    private final int ALIGN_TOP_RIGHT = 1;
    private final int ALIGN_TOP_LEFT = 2;
    private final int ALIGN_BOTTOM_LEFT = 3;
    private int alignment = 1;
    private int style = 1;

    public NorthArrowRenderer(LayerViewPanel panel) {
        super(CONTENT_ID, panel);
    }

    public static boolean isEnabled(LayerViewPanel panel) {
        return panel.getBlackboard().get(ENABLED_KEY, false);
    }

    public static void setEnabled(boolean enabled, LayerViewPanel panel) {
        panel.getBlackboard().put(ENABLED_KEY, enabled);
    }

    @Override
    protected void paint(Graphics2D g) {
        this.paint(g, this.panel.getViewport().getScale());
    }

    public void paint(Graphics2D g, double scale) {
        if (!NorthArrowRenderer.isEnabled(this.panel)) {
            return;
        }
        g.setStroke(this.stroke);
        int x1 = this.arrowRight() - this.ARROW_SIZE / 5;
        int x2 = this.arrowRight();
        int y1 = this.arrowTop();
        int y2 = this.arrowBottom();
        int x3 = (int)((double)x1 + 0.5 * (double)(x2 - x1));
        int y3 = (int)((double)y1 + 0.8 * (double)(y2 - y1));
        switch (this.style) {
            case 1: {
                x1 = this.arrowRight() - this.ARROW_SIZE;
                x2 = this.arrowRight();
                y1 = this.arrowTop();
                y2 = this.arrowBottom();
                x3 = (int)((double)x1 + 0.5 * (double)(x2 - x1));
                y3 = (int)((double)y1 + 0.5 * (double)(y2 - y1));
                int width = this.ARROW_SIZE / 10;
                int x4 = x3 - width;
                int x5 = x3 + width;
                int y4 = y3 - width;
                int y5 = y3 + width;
                int s = 4;
                int[] xPoints0 = new int[]{x3 + s, x4 + s, x1 + s, x4 + s, x3 + s, x5 + s, x2 + s, x5 + s, x3 + s};
                int[] yPoints0 = new int[]{y2 + s, y5 + s, y3 + s, y4 + s, y1 + s, y4 + s, y3 + s, y5 + s, y2 + s};
                this.drawShape(g, Color.LIGHT_GRAY, Color.LIGHT_GRAY, xPoints0, yPoints0, true, false);
                int[] xPoints = new int[]{x3, x4, x3, x1, x4, x3, x3, x5, x3, x2, x5, x3, x3};
                int[] yPoints = new int[]{y2, y5, y3, y3, y4, y3, y1, y4, y3, y3, y5, y3, y2};
                this.drawShape(g, Color.black, this.LINE_COLOR, xPoints, yPoints, true, false);
                int[] xPoints2 = new int[]{x3, x3, x4, x1, x3, x4, x3, x3, x5, x2, x3, x5, x3};
                int[] yPoints2 = new int[]{y2, y3, y5, y3, y3, y4, y1, y3, y4, y3, y3, y5, y2};
                this.drawShape(g, Color.white, this.LINE_COLOR, xPoints2, yPoints2, true, false);
                int[] xPoints3 = new int[]{x3, x4, x1, x4, x3, x5, x2, x5, x3};
                int[] yPoints3 = new int[]{y2, y5, y3, y4, y1, y4, y3, y5, y2};
                this.drawShape(g, Color.white, this.LINE_COLOR, xPoints3, yPoints3, false, true);
                this.drawText(g, "N", this.TEXT_COLOR, MathUtil.avg(x1, x2), this.arrowTop() - this.TEXT_BOTTOM_MARGIN);
                break;
            }
            case 2: {
                int[] xPoints = new int[]{x2, x1, x1, x2};
                int[] yPoints = new int[]{y2, y3, y1, y2};
                this.drawShape(g, Color.black, this.LINE_COLOR, xPoints, yPoints, true, true);
                int x0 = x1 - this.ARROW_SIZE / 5;
                int[] xPoints2 = new int[]{x0, x1, x1, x0};
                int[] yPoints2 = new int[]{y2, y3, y1, y2};
                this.drawShape(g, Color.white, this.LINE_COLOR, xPoints2, yPoints2, true, true);
                this.drawText(g, "N", this.TEXT_COLOR, MathUtil.avg(x0, x2), this.arrowTop() - this.TEXT_BOTTOM_MARGIN);
                break;
            }
            case 3: {
                x1 = this.arrowRight() - this.ARROW_SIZE / 3;
                int[] xPoints = new int[]{x2, x1, x1, x2};
                int[] yPoints = new int[]{y2, y3, y1, y2};
                this.drawShape(g, Color.black, this.LINE_COLOR, xPoints, yPoints, true, true);
                int x0 = x1 - this.ARROW_SIZE / 3;
                int[] xPoints2 = new int[]{x0, x1, x1, x0};
                int[] yPoints2 = new int[]{y2, y3, y1, y2};
                this.drawShape(g, Color.white, this.LINE_COLOR, xPoints2, yPoints2, true, true);
                this.drawText(g, "N", this.TEXT_COLOR, MathUtil.avg(x0, x2), this.arrowTop() - this.TEXT_BOTTOM_MARGIN);
                break;
            }
            default: {
                y3 = (int)((double)y1 + 0.6 * (double)(y2 - y1));
                int[] xPoints = new int[]{x1, x1, x2, x1, x1};
                int[] yPoints = new int[]{y2, y3, y3, y1, y2};
                this.drawShape(g, this.FILL1, this.LINE_COLOR, xPoints, yPoints, true, true);
                this.drawText(g, "N", this.TEXT_COLOR, MathUtil.avg(x1, x2), this.arrowBottom() - this.TEXT_BOTTOM_MARGIN);
            }
        }
    }

    private void drawText(Graphics2D g, String text, Color textColor, double xCenter, double yBaseline) {
        TextLayout layout = this.createTextLayout(text, this.FONT, g);
        layout.draw(g, (float)(xCenter - (double)(layout.getAdvance() / 2.0f)), (float)yBaseline);
    }

    private void drawShape(Graphics2D g, Color fillColor, Color lineColor, int[] xPoints, int[] yPoints, boolean fill, boolean stroke) {
        GeneralPath polygon = new GeneralPath(0, xPoints.length);
        polygon.moveTo(xPoints[0], yPoints[0]);
        for (int index = 1; index < xPoints.length; ++index) {
            polygon.lineTo(xPoints[index], yPoints[index]);
        }
        polygon.closePath();
        if (fill) {
            g.setColor(fillColor);
            g.fill(polygon);
        }
        if (stroke) {
            g.setColor(lineColor);
            g.draw(polygon);
        }
    }

    private int arrowBottom() {
        int position = 0;
        switch (this.alignment) {
            case 1: 
            case 2: {
                position = this.VERTICAL_MARGIN + this.ARROW_SIZE + this.TEXT_FONT_SIZE + this.TEXT_BOTTOM_MARGIN;
                break;
            }
            default: {
                position = this.panel.getHeight() - this.VERTICAL_MARGIN;
            }
        }
        return position;
    }

    private int arrowTop() {
        return this.arrowBottom() - this.ARROW_SIZE;
    }

    private int arrowRight() {
        int position = 0;
        switch (this.alignment) {
            case 2: 
            case 3: {
                position = this.ARROW_SIZE / 2 + this.HORIZONTAL_MARGIN;
                break;
            }
            default: {
                position = this.panel.getWidth() - this.HORIZONTAL_MARGIN;
            }
        }
        return position;
    }

    private TextLayout createTextLayout(String text, Font font, Graphics2D g) {
        return new TextLayout(text, font, g.getFontRenderContext());
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getARROW_SIZE() {
        return this.ARROW_SIZE;
    }

    public void setARROW_SIZE(int arrow_size) {
        this.ARROW_SIZE = arrow_size;
    }

    public Color getFILL1() {
        return this.FILL1;
    }

    public void setFILL1(Color fill1) {
        this.FILL1 = fill1;
    }

    public Color getFILL2() {
        return this.FILL2;
    }

    public void setFILL2(Color fill2) {
        this.FILL2 = fill2;
    }

    public Color getLINE_COLOR() {
        return this.LINE_COLOR;
    }

    public void setLINE_COLOR(Color line_color) {
        this.LINE_COLOR = line_color;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public int getTEXT_BOTTOM_MARGIN() {
        return this.TEXT_BOTTOM_MARGIN;
    }

    public void setTEXT_BOTTOM_MARGIN(int text_bottom_margin) {
        this.TEXT_BOTTOM_MARGIN = text_bottom_margin;
    }

    public Color getTEXT_COLOR() {
        return this.TEXT_COLOR;
    }

    public void setTEXT_COLOR(Color text_color) {
        this.TEXT_COLOR = text_color;
    }

    public int getTEXT_FONT_SIZE() {
        return this.TEXT_FONT_SIZE;
    }

    public void setTEXT_FONT_SIZE(int text_font_size) {
        this.TEXT_FONT_SIZE = text_font_size;
        this.FONT = new Font("Dialog", 1, this.TEXT_FONT_SIZE);
    }

    public int getVERTICAL_MARGIN() {
        return this.VERTICAL_MARGIN;
    }

    public void setVERTICAL_MARGIN(int vertical_margin) {
        this.VERTICAL_MARGIN = vertical_margin;
    }
}

