/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.generalization;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.tools.AttributeMapping;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.operation.polygonize.Polygonizer;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;
import org.openjump.core.geomutils.algorithm.IntersectGeometries;
import org.openjump.core.graph.polygongraph.PolygonGraph;

public class SimplifyPolygonCoveragePlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private String sSidebar = "Simplifies the outlines of polygons that have adjacent polygons.";
    private String note = "Note, if the simplification destroys the topology, then try to simplify iteratively.";
    private String sCreateGraph = "create graph";
    private String sSimplify = "simplify";
    private String LAYERREGIONS = "select layer with polygons";
    private static String T3 = "Maximum point displacement in model units";
    private String sSimplificationFinalized = "simplification finalized";
    private String sPolygonize = "Polygonization";
    private String sLayerMustBePolygonal = "Layer must be a polygonal coverage";
    private String sAttributeTransferNotExhaustive = "Attribute transfer is not exhaustive";
    private FeatureCollection regions = null;
    private Layer input = null;
    private MultiInputDialog dialog;
    private double tolerance = 1.0;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.note = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generalization.SimplifyPolygonCoveragePlugIn.note");
        this.sSidebar = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generalization.SimplifyPolygonCoveragePlugIn.Simplifies-the-outlines-of-polygons-that-have-adjacent-polygons");
        this.sCreateGraph = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.geometrychange.ExtractCommonBoundaryBetweenPolysPlugIn.create-graph");
        this.LAYERREGIONS = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.geometrychange.ExtractCommonBoundaryBetweenPolysPlugIn.select-layer-with-polygons");
        this.sSimplify = I18N.getInstance().get("ui.plugin.analysis.GeometryFunction.Simplify-(D-P)");
        T3 = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.SimplifyWithJTSAlgorithmPlugIn.Maximum-point-displacement-in-model-units");
        this.sSimplificationFinalized = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.SimplifyWithJTSAlgorithmPlugIn.simplification-finalized");
        this.sPolygonize = I18N.getInstance().get("jump.plugin.edit.PolygonizerPlugIn.Polygonization");
        this.sLayerMustBePolygonal = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generalization.SimplifyPolygonCoveragePlugIn.Layer-Must-Be-Polygonal");
        this.sAttributeTransferNotExhaustive = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.generalization.SimplifyPolygonCoveragePlugIn.Attribute-Transfer-Not-Exhaustive");
        this.sSidebar = this.sSidebar + "\n" + this.note;
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_GENERALIZATION}, this.getName() + "...", false, null, SimplifyPolygonCoveragePlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.initDialog(context);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.input = this.dialog.getLayer(this.LAYERREGIONS);
        this.regions = this.input.getFeatureCollectionWrapper();
        this.tolerance = this.dialog.getDouble(T3);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        System.gc();
        monitor.allowCancellationRequests();
        List<Feature> features = this.regions.getFeatures();
        Feature firstFeature = (Feature)features.iterator().next();
        if (firstFeature.getGeometry().getDimension() == 2) {
            monitor.report(this.sCreateGraph);
            PolygonGraph pg = new PolygonGraph(features, monitor);
            FeatureCollection boundaries = pg.getSharedBoundaries();
            boundaries.addAll(pg.getNonSharedBoundaries().getFeatures());
            STRtree index = new STRtree();
            Iterator<Feature> iterator = boundaries.iterator();
            while (iterator.hasNext()) {
                Geometry geom = iterator.next().getGeometry();
                index.insert(geom.getEnvelopeInternal(), (Object)geom);
            }
            if (monitor.isCancelRequested()) {
                return;
            }
            monitor.report(this.sSimplify);
            int count = 0;
            int noItems = boundaries.size();
            Iterator<Feature> iterator2 = boundaries.iterator();
            while (iterator2.hasNext()) {
                ++count;
                Feature edge = iterator2.next();
                Geometry resultgeom = TopologyPreservingSimplifier.simplify((Geometry)edge.getGeometry(), (double)Math.abs(this.tolerance));
                Envelope env = edge.getGeometry().getEnvelopeInternal();
                env.expandBy(Math.abs(this.tolerance));
                List neighbours = index.query(env);
                boolean simplify = true;
                for (Object object : neighbours) {
                    Geometry neighbour;
                    IntersectionMatrix im;
                    if (object == edge.getGeometry() || !(im = resultgeom.relate(neighbour = TopologyPreservingSimplifier.simplify((Geometry)((Geometry)object), (double)Math.abs(this.tolerance)))).matches("0********") && !im.matches("1********")) continue;
                    simplify = false;
                    break;
                }
                if (!simplify) {
                    resultgeom = edge.getGeometry();
                }
                edge.setGeometry(resultgeom);
                String mytext = count + " / " + noItems + " : " + this.sSimplificationFinalized;
                monitor.report(mytext);
                if (!monitor.isCancelRequested()) continue;
                return;
            }
            monitor.report(this.sPolygonize);
            ArrayList<Geometry> lines = new ArrayList<Geometry>();
            for (Feature edge : boundaries) {
                lines.add(edge.getGeometry());
            }
            Collection nodedLines = IntersectGeometries.nodeLines(lines);
            Polygonizer polygonizer = new Polygonizer();
            for (Geometry g : nodedLines) {
                polygonizer.add(g);
                if (!monitor.isCancelRequested()) continue;
                return;
            }
            Collection withoutIntersection = polygonizer.getPolygons();
            FeatureCollection resultD = this.transferAttributesFromPolysToPolys(this.regions, withoutIntersection, context, monitor);
            context.addLayer(StandardCategoryNames.RESULT, this.input + "-" + this.sSimplify, resultD);
        } else {
            context.getWorkbenchFrame().warnUser(this.sLayerMustBePolygonal);
        }
    }

    private void initDialog(PlugInContext context) {
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.dialog.setSideBarDescription(this.sSidebar);
        try {
            JComboBox<Layer> jComboBox = this.dialog.addLayerComboBox(this.LAYERREGIONS, context.getCandidateLayer(0), null, context.getLayerManager());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.dialog.addDoubleField(T3, this.tolerance, 5);
        GUIUtil.centreOnWindow(this.dialog);
    }

    public FeatureCollection transferAttributesFromPolysToPolys(FeatureCollection fcA, Collection<Geometry> geometries, PlugInContext context, TaskMonitor monitor) {
        STRtree indexB = new STRtree();
        for (Geometry geom : geometries) {
            indexB.insert(geom.getEnvelopeInternal(), (Object)geom);
        }
        AttributeMapping mapping = new AttributeMapping(fcA.getFeatureSchema(), new FeatureSchema());
        FeatureDataset fd = new FeatureDataset(mapping.createSchema("Geometry"));
        for (Feature featureA : fcA) {
            Geometry geometryA = featureA.getGeometry();
            int numGeometries = geometryA.getNumGeometries();
            for (int i = 0; i < numGeometries; ++i) {
                Geometry componentA = geometryA.getGeometryN(i);
                if (!(componentA instanceof Polygon)) continue;
                List candidates = indexB.query(componentA.getEnvelopeInternal());
                Geometry geomB = null;
                boolean match = false;
                int minCountCommonCoordinates = -1;
                double bestSimilarity = 0.0;
                for (Geometry gB : candidates) {
                    int countCommonCoordinates = this.commonCoordinates((Polygon)componentA, (Polygon)gB);
                    if (countCommonCoordinates < minCountCommonCoordinates) continue;
                    if (countCommonCoordinates == minCountCommonCoordinates) {
                        double areaRatio = componentA.getEnvelope().getArea() / gB.getEnvelope().getArea();
                        double similarity = Math.min(areaRatio, 1.0 / areaRatio);
                        if (similarity > bestSimilarity && gB.buffer(Math.abs(this.tolerance) * 1.1).contains(componentA) && componentA.buffer(Math.abs(this.tolerance) * 1.1).contains(gB)) {
                            geomB = gB;
                            bestSimilarity = similarity;
                        }
                    } else {
                        geomB = gB;
                    }
                    minCountCommonCoordinates = countCommonCoordinates;
                    match = true;
                }
                if (match) {
                    BasicFeature f = new BasicFeature(fd.getFeatureSchema());
                    mapping.transferAttributes(featureA, null, f);
                    f.setGeometry(geomB);
                    fd.add(f);
                } else {
                    context.getWorkbenchFrame().warnUser(this.sAttributeTransferNotExhaustive);
                }
                if (monitor == null || !monitor.isCancelRequested()) continue;
                return fd;
            }
        }
        return fd;
    }

    private int commonCoordinates(Polygon a, Polygon b) {
        Coordinate[] cca = ((Polygon)a.norm()).getExteriorRing().getCoordinates();
        Coordinate[] ccb = ((Polygon)b.norm()).getExteriorRing().getCoordinates();
        int count = 0;
        int orientation = 1;
        block0: for (int i = 0; i < cca.length - 1; ++i) {
            for (int j = 0; j < ccb.length - 1; ++j) {
                if (!cca[i].equals((Object)ccb[j])) continue;
                ++count;
                if (i > 0 && cca[i - 1].equals((Object)ccb[j + 1])) {
                    orientation = -1;
                }
                if (j <= 0 || !ccb[j - 1].equals((Object)cca[i + 1])) continue block0;
                orientation = -1;
                continue block0;
            }
        }
        return count * orientation;
    }
}

