/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.renderer.style.RingVertexStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.VertexStyle;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.algorithm.distance.DistanceToPoint;
import org.locationtech.jts.algorithm.distance.PointPairDistance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;

public class RemoveSpikePlugIn
extends AbstractThreadedUiPlugIn {
    public static String SOURCE_LAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.RemoveSpikePlugIn.source-layer");
    public static String DESCRIPTION = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.RemoveSpikePlugIn.description");
    public static String RESULT_LAYER_SUFFIX = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.RemoveSpikePlugIn.result-layer-suffix");
    public static String DIST_TOLERANCE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.RemoveSpikePlugIn.dist-tolerance");
    public static String DIST_TOLERANCE_TOOLTIP = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.RemoveSpikePlugIn.dist-tolerance-tooltip");
    public static String ANGLE_TOLERANCE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.RemoveSpikePlugIn.angle-tolerance");
    public static String ANGLE_TOLERANCE_TOOLTIP = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.RemoveSpikePlugIn.angle-tolerance-tooltip");
    public static String SPIKES_LOCALIZATION = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.RemoveSpikePlugIn.spikes-localisation");
    public static String ATTRIBUTE_TRANSFER = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.RemoveSpikePlugIn.attribute-transfer");
    public static String NONE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.RemoveSpikePlugIn.none");
    public static String ALL = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.RemoveSpikePlugIn.all");
    public static String REMOVE_THIN_POLYGONS = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.RemoveSpikePlugIn.remove-thin-polygons");
    public static String REMOVE_THIN_HOLES = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.RemoveSpikePlugIn.remove-thin-holes");
    public static String SKIP_MICRO_SEGMENTS = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.RemoveSpikePlugIn.skip-micro-segments");
    public static String LOCATION_TYPE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.RemoveSpikePlugIn.spike-location_type");
    public static String AS_LINESTRING = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.RemoveSpikePlugIn.as-linestring");
    public static String ON_SPIKE_TIP = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.RemoveSpikePlugIn.spike-tip");
    public static String ON_SPIKE_BASE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.RemoveSpikePlugIn.spike-base");
    private Layer layerA;
    private double distTolerance = 1.0;
    private double angleTolerance = 5.0;
    private boolean removeThinPolygons = false;
    private boolean removeThinHoles = false;
    private boolean skipMicroSegment = false;
    private String attributeName = NONE;
    private boolean asLineString = false;
    private boolean onSpikeTip = true;
    private boolean onSpikeBase = false;

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.tools.RemoveSpikePlugIn");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_QA}, this.getName() + "...", false, null, RemoveSpikePlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.initDialog(dialog, context);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    private void initDialog(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(DESCRIPTION);
        Layer candidateA = this.layerA == null ? context.getCandidateLayer(0) : this.layerA;
        JComboBox<Layer> layerComboBoxA = dialog.addLayerComboBox(SOURCE_LAYER, candidateA, context.getLayerManager());
        dialog.addDoubleField(DIST_TOLERANCE, this.distTolerance, 8, DIST_TOLERANCE_TOOLTIP);
        dialog.addDoubleField(ANGLE_TOLERANCE, this.angleTolerance, 8, ANGLE_TOLERANCE_TOOLTIP);
        dialog.addCheckBox(REMOVE_THIN_HOLES, this.removeThinHoles, REMOVE_THIN_HOLES);
        dialog.addCheckBox(SKIP_MICRO_SEGMENTS, this.skipMicroSegment, SKIP_MICRO_SEGMENTS);
        List<String> attributes = Arrays.asList(this.getAttributes(candidateA));
        JComboBox<String> attributeTransferJCB = dialog.addComboBox(ATTRIBUTE_TRANSFER, NONE, attributes, ATTRIBUTE_TRANSFER);
        attributeTransferJCB.setRenderer(new BasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (index < 2 && value instanceof String && (ALL.equals(value) || NONE.equals(value))) {
                    this.setText("__" + value.toString().toUpperCase() + "__");
                }
                return this;
            }
        });
        dialog.addSubTitle(LOCATION_TYPE);
        dialog.addRadioButton(AS_LINESTRING, LOCATION_TYPE, this.asLineString, AS_LINESTRING);
        dialog.addRadioButton(ON_SPIKE_TIP, LOCATION_TYPE, this.onSpikeTip, ON_SPIKE_TIP);
        dialog.addRadioButton(ON_SPIKE_BASE, LOCATION_TYPE, this.onSpikeBase, ON_SPIKE_BASE);
        GUIUtil.centreOnWindow(dialog);
        layerComboBoxA.addItemListener(e -> attributeTransferJCB.setModel(new DefaultComboBoxModel<String>(this.getAttributes(dialog.getLayer(SOURCE_LAYER)))));
    }

    private String[] getAttributes(Layer layer) {
        if (layer != null) {
            FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
            ArrayList<String> attributes = new ArrayList<String>(schema.getAttributeNames());
            String geomName = schema.getAttributeName(schema.getGeometryIndex());
            attributes.remove(geomName);
            attributes.add(0, ALL);
            attributes.add(0, NONE);
            return attributes.toArray(new String[0]);
        }
        return new String[]{NONE};
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layerA = dialog.getLayer(SOURCE_LAYER);
        this.distTolerance = dialog.getDouble(DIST_TOLERANCE);
        this.angleTolerance = dialog.getDouble(ANGLE_TOLERANCE);
        this.removeThinHoles = dialog.getBoolean(REMOVE_THIN_HOLES);
        this.skipMicroSegment = dialog.getBoolean(SKIP_MICRO_SEGMENTS);
        this.attributeName = dialog.getText(ATTRIBUTE_TRANSFER);
        this.asLineString = dialog.getBoolean(AS_LINESTRING);
        this.onSpikeTip = dialog.getBoolean(ON_SPIKE_TIP);
        this.onSpikeBase = dialog.getBoolean(ON_SPIKE_BASE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        FeatureSchema srcSchema = this.layerA.getFeatureCollectionWrapper().getFeatureSchema();
        FeatureDataset result1 = new FeatureDataset(srcSchema.clone());
        FeatureSchema spikeSchema = new FeatureSchema();
        if (this.attributeName.equals(ALL)) {
            spikeSchema = srcSchema.clone();
            spikeSchema.addAttribute("status", AttributeType.STRING);
        } else if (this.attributeName.equals(NONE)) {
            spikeSchema.addAttribute("geometry", AttributeType.GEOMETRY);
            spikeSchema.addAttribute("status", AttributeType.STRING);
        } else {
            spikeSchema.addAttribute("geometry", AttributeType.GEOMETRY);
            spikeSchema.addAttribute(this.attributeName, srcSchema.getAttributeType(srcSchema.getAttributeIndex(this.attributeName)));
            spikeSchema.addAttribute("status", AttributeType.STRING);
        }
        FeatureDataset result2 = new FeatureDataset(spikeSchema);
        for (Feature f : this.layerA.getFeatureCollectionWrapper().getFeatures()) {
            Feature feature = f.clone(true, true);
            List<Object> spikes = new ArrayList<Geometry>();
            Geometry newGeom = null;
            if (feature.getGeometry() instanceof GeometryCollection) {
                newGeom = this.removeSpike((GeometryCollection)feature.getGeometry(), this.distTolerance, this.angleTolerance, spikes);
            } else if (feature.getGeometry() instanceof Polygon) {
                newGeom = this.removeSpike((Polygon)feature.getGeometry(), this.distTolerance, this.angleTolerance, spikes);
            }
            boolean isValid = false;
            if (newGeom != null && newGeom.isValid()) {
                feature.setGeometry(newGeom);
                isValid = true;
            }
            if (spikes.size() > 0) {
                BasicFeature spikesFeature = new BasicFeature(spikeSchema);
                for (int i = 0; i < spikeSchema.getAttributeCount(); ++i) {
                    if (spikeSchema.getAttributeType(i) == AttributeType.GEOMETRY) {
                        if (this.onSpikeTip) {
                            spikes = spikes.stream().map(Geometry::getInteriorPoint).collect(Collectors.toList());
                        } else if (this.onSpikeBase) {
                            spikes = spikes.stream().map(g -> g.getFactory().createPoint(g.getCoordinates()[0])).collect(Collectors.toList());
                        }
                        spikesFeature.setGeometry(f.getGeometry().getFactory().buildGeometry(spikes));
                        continue;
                    }
                    if (spikeSchema.getAttributeName(i).equals("status")) {
                        spikesFeature.setAttribute("status", (Object)(isValid ? "Fixed" : "Not fixed"));
                        continue;
                    }
                    spikesFeature.setAttribute(i, f.getAttribute(spikeSchema.getAttributeName(i)));
                }
                result2.add(spikesFeature);
            }
            result1.add(feature);
        }
        this.workbenchContext.getLayerManager().addLayer(StandardCategoryNames.RESULT, this.layerA.getName() + " - " + RESULT_LAYER_SUFFIX, result1);
        Layer locationLayer = this.workbenchContext.getLayerManager().addLayer(StandardCategoryNames.RESULT, SPIKES_LOCALIZATION, result2);
        if (locationLayer != null) {
            boolean firingEvents = locationLayer.getLayerManager().isFiringEvents();
            locationLayer.getLayerManager().setFiringEvents(false);
            try {
                if (this.asLineString) {
                    locationLayer.getBasicStyle().setLineWidth(3);
                    locationLayer.getBasicStyle().setLineColor(Color.RED);
                    locationLayer.getVertexStyle().setEnabled(false);
                } else if (this.onSpikeTip) {
                    locationLayer.getBasicStyle().setFillColor(Color.RED);
                    locationLayer.getBasicStyle().setLineColor(Color.RED);
                    locationLayer.getBasicStyle().setEnabled(false);
                    this.changeVertexToRing(locationLayer);
                    locationLayer.getVertexStyle().setEnabled(true);
                } else if (this.onSpikeBase) {
                    locationLayer.getBasicStyle().setFillColor(Color.RED);
                    locationLayer.getBasicStyle().setLineColor(Color.RED);
                    locationLayer.getBasicStyle().setEnabled(false);
                    this.changeVertexToRing(locationLayer);
                    locationLayer.getVertexStyle().setEnabled(true);
                }
            }
            finally {
                locationLayer.getLayerManager().setFiringEvents(firingEvents);
            }
            locationLayer.fireAppearanceChanged();
        }
    }

    private Geometry removeSpike(GeometryCollection geomCollection, double distTolerance, double angleTolerance, List<Geometry> spikes) {
        ArrayList<Object> geometries = new ArrayList<Object>();
        for (int i = 0; i < geomCollection.getNumGeometries(); ++i) {
            Geometry g = geomCollection.getGeometryN(i);
            if (g instanceof GeometryCollection) {
                geometries.add(this.removeSpike((GeometryCollection)g, distTolerance, angleTolerance, spikes));
                continue;
            }
            if (g instanceof Polygon) {
                geometries.add(this.removeSpike((Polygon)g, distTolerance, angleTolerance, spikes));
                continue;
            }
            geometries.add(g);
        }
        return geomCollection.getFactory().buildGeometry(geometries);
    }

    private Polygon removeSpike(Polygon poly, double distTolerance, double angleTolerance, List<Geometry> spikes) {
        LinearRing shell = this.removeSpike(poly.getExteriorRing(), distTolerance, angleTolerance, spikes);
        if (shell == null) {
            shell = poly.getExteriorRing();
        }
        ArrayList<LinearRing> newHoles = new ArrayList<LinearRing>();
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            LinearRing h = this.removeSpike(poly.getInteriorRingN(i), distTolerance, angleTolerance, spikes);
            if (h == null) continue;
            newHoles.add(h);
        }
        return poly.getFactory().createPolygon(shell, newHoles.toArray(new LinearRing[0]));
    }

    private LinearRing removeSpike(LinearRing ring, double distTolerance, double angleTolerance, List<Geometry> spikes) {
        CoordinateList cl = new CoordinateList(ring.getCoordinates(), false);
        double length = ring.getLength();
        CoordinateList newCl = new CoordinateList();
        int size = cl.size();
        boolean vertexRemoved = false;
        ArrayList<Coordinate> close_coordinates = new ArrayList<Coordinate>();
        int i = 0;
        int j = 1;
        int k = 2;
        while (i < size) {
            Coordinate a = (Coordinate)cl.get(i);
            Coordinate b = (Coordinate)cl.get(j % (size - 1));
            Coordinate c = (Coordinate)cl.get(k % (size - 1));
            close_coordinates.clear();
            if (this.skipMicroSegment) {
                double dist = b.distance(c);
                while (dist < distTolerance && k < size + 2 && dist < length / 4.0) {
                    close_coordinates.add(c);
                    c = (Coordinate)cl.get(++k % (size - 1));
                    dist = b.distance(c);
                }
                i = k - 2;
                j = k - 1;
            }
            PointPairDistance ppd = new PointPairDistance();
            DistanceToPoint.computeDistance((LineSegment)new LineSegment(a, b), (Coordinate)c, (PointPairDistance)ppd);
            double d1 = ppd.getDistance();
            DistanceToPoint.computeDistance((LineSegment)new LineSegment(b, c), (Coordinate)a, (PointPairDistance)ppd);
            double d2 = ppd.getDistance();
            if (!a.equals((Object)c) && d1 > distTolerance && d2 > distTolerance || Angle.angleBetween((Coordinate)a, (Coordinate)b, (Coordinate)c) * 180.0 / Math.PI > angleTolerance) {
                newCl.add(b, false);
                for (Coordinate coord : close_coordinates) {
                    newCl.add(coord, false);
                }
                ++i;
                ++j;
                ++k;
                continue;
            }
            if (a.distance(b) < c.distance(b)) {
                spikes.add((Geometry)ring.getFactory().createLineString(new Coordinate[]{a, b, c}));
            } else {
                spikes.add((Geometry)ring.getFactory().createLineString(new Coordinate[]{c, b, a}));
            }
            i = j++;
            ++k;
            vertexRemoved = true;
        }
        if (newCl.size() == size) {
            return ring;
        }
        if (newCl.size() < 4) {
            if (this.removeThinHoles) {
                return null;
            }
            return ring;
        }
        newCl.closeRing();
        LinearRing newLinearRing = ring.getFactory().createLinearRing(newCl.toCoordinateArray());
        if (vertexRemoved) {
            newLinearRing = this.removeSpike(newLinearRing, distTolerance, angleTolerance, spikes);
        }
        return newLinearRing;
    }

    private void changeVertexToRing(Layer errorLayer) {
        errorLayer.removeStyle(errorLayer.getStyle(VertexStyle.class));
        RingVertexStyle rvStyle = new RingVertexStyle();
        rvStyle.setLineColor(Color.RED);
        rvStyle.setLineWidth(3);
        rvStyle.setSize(24);
        errorLayer.addStyle(rvStyle);
    }
}

