/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.IndexedFeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.tools.AttributeMapping;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.operation.polygonize.Polygonizer;
import org.locationtech.jts.operation.union.UnaryUnionOp;
import org.openjump.sigle.utilities.geom.FeatureCollectionUtil;

public class PlanarGraphPlugIn
extends ThreadedBasePlugIn {
    private static final String EDGE = I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Edge");
    private static final String FACE = I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Face");
    private static final String NODE = I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Node");
    private static final String CATEGORY = I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Graph");
    private static final String MAPPING = I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Mapping");
    private static final String TITLE = I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Topologic-Analysis");
    private static final String SELECT_LAYER = I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Select-layer-to-analyse");
    private static final String CALCULATE_NODES = I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Calculate-nodes");
    private static final String CALCULATE_FACES = I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Calculate-faces");
    private static final String CALCULATE_RELATIONS = I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Calculate-the-relations-arcs-nodes-and-/or-arcs-faces");
    private static final String KEEP_ATTRIBUTES = I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Keep-attributes");
    private static final Integer MINUS_ONE = -1;
    private GeometryFactory gf = new GeometryFactory();
    private static boolean nodeb = true;
    private static boolean faceb = true;
    private static boolean relb = true;
    private static boolean attributesb = true;
    private static String LEFT_FACE = "LeftFace";
    private static String RIGHT_FACE = "RightFace";
    private static String INITIAL_NODE = "StartNode";
    private static String FINAL_NODE = "EndNode";
    private String layerName;
    public Collection edges;
    private MultiInputDialog mid;

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        Layer layer = this.mid.getLayer(SELECT_LAYER);
        FeatureCollectionWrapper fcSource = layer.getFeatureCollectionWrapper();
        this.layerName = layer.getName();
        nodeb = this.mid.getBoolean(CALCULATE_NODES);
        faceb = this.mid.getBoolean(CALCULATE_FACES);
        relb = this.mid.getBoolean(CALCULATE_RELATIONS);
        attributesb = this.mid.getBoolean(KEEP_ATTRIBUTES);
        monitor.report(I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Searching-for-linear-elements"));
        List list = this.getLines(fcSource);
        monitor.report(I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Number-of-found-elements") + ": " + list.size());
        monitor.report(I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Generate-layer-of-arcs"));
        FeatureCollection fcEdge = this.createEdgeLayer(layer.getFeatureCollectionWrapper(), nodeb, faceb, relb);
        if (fcEdge.size() > 0) {
            context.getLayerManager().addLayer(CATEGORY, this.layerName + "_" + EDGE, fcEdge);
        } else {
            context.getWorkbenchFrame().warnUser("No edge found");
        }
        monitor.report(I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Arc-layer-generated"));
        monitor.report(I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Create-nodes"));
        if (nodeb) {
            FeatureCollection fcNode = this.createNodeLayer(fcEdge, relb);
            if (fcNode.size() > 0) {
                context.getLayerManager().addLayer(CATEGORY, this.layerName + "_" + NODE, fcNode);
            } else {
                context.getWorkbenchFrame().warnUser("No node found");
            }
        }
        monitor.report(I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Layer-with-nodes-generated"));
        monitor.report(I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Create-faces"));
        monitor.report(I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Layer-of-faces-generated"));
        if (faceb) {
            FeatureCollection fcFace = this.createFaceLayer(fcEdge, relb);
            Feature fWithin = null;
            if (attributesb) {
                AttributeMapping mapping = new AttributeMapping(new FeatureSchema(), new FeatureSchema());
                List<Object> aFeatures = new ArrayList();
                monitor.report(I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Transfer-of-attributes"));
                if (FeatureCollectionUtil.getFeatureCollectionDimension(fcSource) == 2) {
                    mapping = new AttributeMapping(fcSource.getFeatureSchema(), fcFace.getFeatureSchema());
                    aFeatures = fcFace.getFeatures();
                } else if (FeatureCollectionUtil.getFeatureCollectionDimension(fcSource) == 1) {
                    mapping = new AttributeMapping(fcSource.getFeatureSchema(), fcFace.getFeatureSchema());
                    aFeatures = fcEdge.getFeatures();
                } else {
                    context.getWorkbenchFrame().warnUser(I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Cannot-transfer-attributes"));
                }
                FeatureDataset fcRecup = new FeatureDataset(mapping.createSchema("GEOMETRY"));
                IndexedFeatureCollection indexedB = new IndexedFeatureCollection(fcSource);
                for (Feature feature : aFeatures) {
                    BasicFeature feature2 = new BasicFeature(fcRecup.getFeatureSchema());
                    int nbFeatureWithin = 0;
                    Iterator<Feature> j = indexedB.query(feature.getGeometry().getEnvelopeInternal()).iterator();
                    while (j.hasNext() && !monitor.isCancelRequested()) {
                        Feature bFeature = j.next();
                        if (!feature.getGeometry().within(bFeature.getGeometry())) continue;
                        ++nbFeatureWithin;
                        fWithin = bFeature;
                    }
                    if (nbFeatureWithin == 1 && attributesb) {
                        mapping.transferAttributes(fWithin, feature, feature2);
                    }
                    feature2.setGeometry((Geometry)feature.getGeometry().clone());
                    fcRecup.add(feature2);
                }
                if (fcRecup.size() > 0) {
                    context.getLayerManager().addLayer(CATEGORY, this.layerName + "_" + MAPPING, fcRecup);
                }
            }
            context.getLayerManager().addLayer(CATEGORY, this.layerName + "_" + FACE, fcFace);
        }
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY, MenuNames.CONVERT}, this.getName(), false, null, new MultiEnableCheck().add(EnableCheckFactory.getInstance(context.getWorkbenchContext()).createTaskWindowMustBeActiveCheck()).add(EnableCheckFactory.getInstance(context.getWorkbenchContext()).createAtLeastNLayersMustExistCheck(1)));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.initDialog(context);
        this.mid.setVisible(true);
        this.mid.wasOKPressed();
        return this.mid.wasOKPressed();
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Planar-Graph") + "...";
    }

    private void initDialog(PlugInContext context) {
        this.mid = new MultiInputDialog(context.getWorkbenchFrame(), TITLE, true);
        Layer src_layer = this.layerName == null || context.getLayerManager().getLayer(this.layerName) == null ? context.getCandidateLayer(0) : context.getLayerManager().getLayer(this.layerName);
        this.mid.addLayerComboBox(SELECT_LAYER, src_layer, context.getLayerManager());
        this.mid.addLabel(I18N.getInstance().get("org.openjump.sigle.plugin.PlanarGraphPlugIn.The-layer-of-arcs-is-always-generated"));
        this.mid.addCheckBox(CALCULATE_NODES, nodeb);
        this.mid.addCheckBox(CALCULATE_FACES, faceb);
        this.mid.addCheckBox(CALCULATE_RELATIONS, relb);
        this.mid.addCheckBox(KEEP_ATTRIBUTES, attributesb);
        this.mid.pack();
        GUIUtil.centreOnWindow(this.mid);
    }

    private List getLines(FeatureCollection fc) {
        ArrayList linesList = new ArrayList();
        LinearComponentExtracter filter = new LinearComponentExtracter(linesList);
        for (Feature feature : fc.getFeatures()) {
            Geometry g = feature.getGeometry();
            g.apply((GeometryComponentFilter)filter);
        }
        return linesList;
    }

    public FeatureCollection createEdgeLayer(FeatureCollection fc, boolean nodeb, boolean faceb, boolean relations) {
        FeatureSchema fsEdge = new FeatureSchema();
        fsEdge.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        fsEdge.addAttribute("ID", AttributeType.INTEGER);
        if (nodeb && relations) {
            fsEdge.addAttribute(INITIAL_NODE, AttributeType.INTEGER);
            fsEdge.addAttribute(FINAL_NODE, AttributeType.INTEGER);
        }
        if (faceb && relations) {
            fsEdge.addAttribute(RIGHT_FACE, AttributeType.INTEGER);
            fsEdge.addAttribute(LEFT_FACE, AttributeType.INTEGER);
        }
        FeatureDataset fcEdge = new FeatureDataset(fsEdge);
        List list = this.getLines(fc);
        Geometry gc = new UnaryUnionOp((Collection)list).union();
        if (!(gc instanceof GeometryCollection)) {
            gc = this.gf.createGeometryCollection(new Geometry[]{gc});
        }
        LineMerger lineMerger = new LineMerger();
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            lineMerger.add(gc.getGeometryN(i));
        }
        this.edges = lineMerger.getMergedLineStrings();
        int no = 0;
        Iterator it = this.edges.iterator();
        while (it.hasNext()) {
            BasicFeature f = new BasicFeature(fsEdge);
            f.setGeometry((Geometry)it.next());
            f.setAttribute("ID", (Object)(++no));
            fcEdge.add(f);
        }
        return fcEdge;
    }

    public FeatureCollection createNodeLayer(FeatureCollection fcEdge, boolean relations) {
        FeatureSchema fsNode = new FeatureSchema();
        fsNode.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        fsNode.addAttribute("ID", AttributeType.INTEGER);
        FeatureDataset fcNode = new FeatureDataset(fsNode);
        HashMap<Coordinate, Point> gNodes = new HashMap<Coordinate, Point>();
        Iterator it = this.edges.iterator();
        while (it.hasNext()) {
            Coordinate[] cc = ((Geometry)it.next()).getCoordinates();
            gNodes.put(cc[0], this.gf.createPoint(cc[0]));
            gNodes.put(cc[cc.length - 1], this.gf.createPoint(cc[cc.length - 1]));
        }
        int no = 0;
        HashMap<Coordinate, BasicFeature> fNodes = new HashMap<Coordinate, BasicFeature>();
        for (Geometry point : gNodes.values()) {
            BasicFeature f = new BasicFeature(fsNode);
            f.setGeometry(point);
            f.setAttribute("ID", (Object)(++no));
            fNodes.put(f.getGeometry().getCoordinate(), f);
            fcNode.add(f);
        }
        if (relations) {
            for (Feature f : fcEdge.getFeatures()) {
                Coordinate[] cc = f.getGeometry().getCoordinates();
                f.setAttribute(INITIAL_NODE, ((Feature)fNodes.get(cc[0])).getAttribute("ID"));
                f.setAttribute(FINAL_NODE, ((Feature)fNodes.get(cc[cc.length - 1])).getAttribute("ID"));
            }
        }
        return fcNode;
    }

    public FeatureCollection createFaceLayer(FeatureCollection fcEdge, boolean relations) {
        FeatureSchema fsFace = new FeatureSchema();
        fsFace.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        fsFace.addAttribute("ID", AttributeType.INTEGER);
        FeatureDataset fcFace = new FeatureDataset(fsFace);
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add(this.edges);
        int no = 0;
        Iterator it = polygonizer.getPolygons().iterator();
        while (it.hasNext()) {
            BasicFeature f = new BasicFeature(fsFace);
            Geometry face = (Geometry)it.next();
            face.normalize();
            f.setGeometry(face);
            f.setAttribute("ID", (Object)(++no));
            fcFace.add(f);
        }
        if (relations) {
            for (Feature edge : fcEdge.getFeatures()) {
                edge.setAttribute(RIGHT_FACE, (Object)MINUS_ONE);
                edge.setAttribute(LEFT_FACE, (Object)MINUS_ONE);
                Geometry g1 = edge.getGeometry();
                List<Feature> list = fcFace.query(g1.getEnvelopeInternal());
                for (int i = 0; i < list.size(); ++i) {
                    Feature face = list.get(i);
                    this.labelEdge(edge, face);
                }
            }
        }
        return fcFace;
    }

    private void labelEdge(Feature edge, Feature face) {
        IntersectionMatrix im = edge.getGeometry().relate(face.getGeometry());
        if (im.matches("*1*******")) {
            Coordinate c1;
            Coordinate c0 = edge.getGeometry().getCoordinates()[0];
            if (this.hasSameOrientation(c0, c1 = edge.getGeometry().getCoordinates()[1], face.getGeometry())) {
                edge.setAttribute(RIGHT_FACE, face.getAttribute("ID"));
            } else {
                edge.setAttribute(LEFT_FACE, face.getAttribute("ID"));
            }
        } else if (im.matches("1********")) {
            edge.setAttribute(RIGHT_FACE, face.getAttribute("ID"));
            edge.setAttribute(LEFT_FACE, face.getAttribute("ID"));
        }
    }

    private boolean hasSameOrientation(Coordinate c0, Coordinate c1, Geometry g) {
        int i;
        assert (g instanceof Polygon);
        assert (!c0.equals((Object)c1));
        int index0 = -1;
        int index1 = -1;
        LinearRing ring = ((Polygon)g).getExteriorRing();
        Coordinate[] cc = ring.getCoordinates();
        for (i = 0; i < cc.length; ++i) {
            if (index0 == -1 && cc[i].equals((Object)c0)) {
                index0 = i;
            }
            if (index1 == -1 && cc[i].equals((Object)c1)) {
                index1 = i;
            }
            if (index0 <= -1 || index1 <= -1) continue;
            if (Math.abs(index1 - index0) == 1) {
                return index1 > index0;
            }
            return index0 > index1;
        }
        for (i = 0; i < ((Polygon)g).getNumInteriorRing(); ++i) {
            LinearRing hole = ((Polygon)g).getInteriorRingN(i);
            index0 = -1;
            index1 = -1;
            cc = hole.getCoordinates();
            for (int j = 0; j < cc.length; ++j) {
                if (index0 == -1 && cc[j].equals((Object)c0)) {
                    index0 = j;
                }
                if (index1 == -1 && cc[j].equals((Object)c1)) {
                    index1 = j;
                }
                if (index0 <= -1 || index1 <= -1) continue;
                if (Math.abs(index1 - index0) == 1) {
                    return index1 > index0;
                }
                return index0 > index1;
            }
        }
        return false;
    }
}

