/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.MultiClickTool;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Coordinate;

public class MeasureM_FTool
extends MultiClickTool {
    private static final String sDistance = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.MeasureM_FTool.Distance");
    private static final String sMeters = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.MeasureM_FTool.meters");
    private static final String sFeet = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.MeasureM_FTool.feet");
    private List savedCoordinates = new ArrayList();
    private Coordinate currCoord;

    public MeasureM_FTool(WorkbenchContext context) {
        super(context);
        this.allowSnapping();
    }

    @Override
    public Icon getIcon() {
        return new ImageIcon(this.getClass().getResource("RulerM_F.gif"));
    }

    @Override
    public Cursor getCursor() {
        for (int i = 0; i < this.savedCoordinates.size(); ++i) {
            this.add((Coordinate)this.savedCoordinates.get(i));
        }
        return MeasureM_FTool.createCursor(new ImageIcon(this.getClass().getResource("RulerCursorM_F.gif")).getImage());
    }

    @Override
    public void mouseLocationChanged(MouseEvent e) {
        try {
            if (this.isShapeOnScreen()) {
                ArrayList<Coordinate> currentCoordinates = new ArrayList<Coordinate>(this.getCoordinates());
                currentCoordinates.add(this.getPanel().getViewport().toModelCoordinate(e.getPoint()));
                this.display(currentCoordinates, this.getPanel());
            }
            this.currCoord = this.snap(e.getPoint());
            super.mouseLocationChanged(e);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.savedCoordinates = new ArrayList<Coordinate>(this.getCoordinates());
    }

    @Override
    protected void gestureFinished() throws NoninvertibleTransformException {
        this.reportNothingToUndoYet();
        this.savedCoordinates.clear();
        this.display(this.getCoordinates(), this.getPanel());
    }

    private void display(List coordinates, LayerViewPanel panel) throws NoninvertibleTransformException {
        this.display(this.distance(coordinates), panel);
    }

    private void display(double distance, LayerViewPanel panel) {
        DecimalFormat df3 = new DecimalFormat("###,###,##0.0##");
        String distString = df3.format(distance / 0.3048);
        panel.getContext().setStatusMessage(sDistance + ": " + panel.format(distance) + " " + sMeters + "  = " + distString + " feet");
    }

    private double distance(List coordinates) {
        double distance = 0.0;
        for (int i = 1; i < coordinates.size(); ++i) {
            distance += ((Coordinate)coordinates.get(i - 1)).distance((Coordinate)coordinates.get(i));
        }
        if (this.currCoord != null && coordinates.size() > 1) {
            distance -= ((Coordinate)coordinates.get(coordinates.size() - 2)).distance((Coordinate)coordinates.get(coordinates.size() - 1));
            distance += ((Coordinate)coordinates.get(coordinates.size() - 2)).distance(this.currCoord);
        }
        return distance;
    }
}

