/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.util.LineStringExtracter;
import org.locationtech.jts.geom.util.PointExtracter;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.operation.overlayng.OverlayNGRobust;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;

public class EraseLayerAWithLayerBPlugIn
extends AbstractThreadedUiPlugIn {
    public static String LAYER_A = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.EraseLayerAWithLayerBPlugIn.source-layer");
    public static String LAYER_B = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.EraseLayerAWithLayerBPlugIn.eraser-layer");
    public static String DESCRIPTION = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.EraseLayerAWithLayerBPlugIn.description");
    public static String SHOW_NEW_VERTICES = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.EraseLayerAWithLayerBPlugIn.show-new-vertices");
    public static String DECOMPOSE_MULTI = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.EraseLayerAWithLayerBPlugIn.decompose-multi");
    public static String MINUS = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.EraseLayerAWithLayerBPlugIn.minus");
    public static String VERTEX_LAYER_SUFFIX = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.EraseLayerAWithLayerBPlugIn.vertex-layer-suffix");
    private static String UPDATE_SRC = I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.Update-Source-features-with-result");
    private static String CREATE_LYR = I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.Create-new-layer-for-result");
    private static String OVERLAY_NG = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.EraseLayerAWithLayerBPlugIn.use-overlay-ng");
    private static String OVERLAY_NG_TT = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.EraseLayerAWithLayerBPlugIn.use-overlay-ng-tt");
    private static String sFeatures = I18N.getInstance().get("jump.features-processed");
    private Layer layerA;
    private Layer layerB;
    private boolean updateMode = false;
    private boolean showNewVertices;
    private boolean decomposeMulti;
    private boolean useOverlayNG;

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.tools.EraseLayerAWithLayerBPlugIn");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY}, this.getName() + "...", false, null, EraseLayerAWithLayerBPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(2));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.initDialog(dialog, context);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    private void initDialog(final MultiInputDialog dialog, PlugInContext context) {
        boolean layerAEditable;
        dialog.setSideBarDescription(DESCRIPTION);
        Layer candidateA = this.layerA == null ? context.getCandidateLayer(0) : this.layerA;
        Layer candidateB = this.layerB == null ? context.getCandidateLayer(1) : this.layerB;
        JComboBox<Layer> layerComboBoxA = dialog.addLayerComboBox(LAYER_A, candidateA, context.getLayerManager());
        JComboBox<Layer> layerComboBoxB = dialog.addLayerComboBox(LAYER_B, candidateB, context.getLayerManager());
        String OUTPUT_GROUP = I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.Match-Type");
        final JRadioButton createNewLayerRB = dialog.addRadioButton(CREATE_LYR, OUTPUT_GROUP, !this.updateMode, I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.Create-a-new-layer-for-the-results"));
        final JRadioButton updateSourceRB = dialog.addRadioButton(UPDATE_SRC, OUTPUT_GROUP, this.updateMode, I18N.getInstance().get("ui.plugin.analysis.GeometryFunctionPlugIn.Replace-the-geometry-of-Source-features-with-the-result-geometry") + "  ");
        final JCheckBox showNewVerticesCB = dialog.addCheckBox(SHOW_NEW_VERTICES, this.showNewVertices, SHOW_NEW_VERTICES);
        final JCheckBox decomposeMultiCB = dialog.addCheckBox(DECOMPOSE_MULTI, this.decomposeMulti, DECOMPOSE_MULTI);
        JCheckBox useOverlayNGCB = dialog.addCheckBox(OVERLAY_NG, this.useOverlayNG, OVERLAY_NG_TT);
        this.updateMode = layerAEditable = dialog.getLayer(LAYER_A).isEditable();
        createNewLayerRB.setSelected(!layerAEditable);
        createNewLayerRB.setEnabled(true);
        updateSourceRB.setSelected(layerAEditable);
        updateSourceRB.setEnabled(layerAEditable);
        showNewVerticesCB.setEnabled(createNewLayerRB.isSelected());
        decomposeMultiCB.setEnabled(createNewLayerRB.isSelected());
        layerComboBoxA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean layerAEditable = dialog.getLayer(LAYER_A).isEditable();
                EraseLayerAWithLayerBPlugIn.this.updateMode = layerAEditable;
                createNewLayerRB.setSelected(!layerAEditable);
                createNewLayerRB.setEnabled(true);
                updateSourceRB.setSelected(layerAEditable);
                updateSourceRB.setEnabled(layerAEditable);
                showNewVerticesCB.setEnabled(createNewLayerRB.isSelected());
                decomposeMultiCB.setEnabled(createNewLayerRB.isSelected());
            }
        });
        createNewLayerRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                showNewVerticesCB.setEnabled(createNewLayerRB.isSelected());
                decomposeMultiCB.setEnabled(createNewLayerRB.isSelected());
            }
        });
        GUIUtil.centreOnWindow(dialog);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layerA = dialog.getLayer(LAYER_A);
        this.layerB = dialog.getLayer(LAYER_B);
        this.updateMode = dialog.getBoolean(UPDATE_SRC);
        this.showNewVertices = dialog.getBoolean(SHOW_NEW_VERTICES);
        this.decomposeMulti = dialog.getBoolean(DECOMPOSE_MULTI);
        this.useOverlayNG = dialog.getBoolean(OVERLAY_NG);
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        STRtree index = new STRtree();
        for (Feature o : this.layerB.getFeatureCollectionWrapper().getFeatures()) {
            Geometry g = o.getGeometry();
            index.insert(g.getEnvelopeInternal(), (Object)g);
        }
        EditTransaction transaction = new EditTransaction(new LinkedHashSet<Feature>(), "Erase A With B", this.layerA, true, true, context.getLayerViewPanel().getContext());
        Collection<Feature> result = this.processCollection(monitor, this.layerA.getFeatureCollectionWrapper().getFeatures(), index, transaction);
        if (this.updateMode) {
            transaction.commit();
        } else {
            FeatureDataset result1 = new FeatureDataset(this.layerA.getFeatureCollectionWrapper().getFeatureSchema());
            for (Feature feature : this.layerA.getFeatureCollectionWrapper().getFeatures()) {
                Feature feature2 = feature.clone(false, true);
                feature2.setGeometry(this.getHomogeneousGeometry(feature2.getGeometry()));
                result1.add(feature2);
            }
            Iterator<Feature> iterator = result1.getFeatures().iterator();
            while (iterator.hasNext()) {
                Feature feature;
                Feature feature3 = feature = iterator.next();
                List candidates = index.query(feature3.getGeometry().getEnvelopeInternal());
                for (Geometry b : candidates) {
                    feature3.setGeometry(this.getHomogeneousGeometry(this.erase(feature3.getGeometry(), this.getHomogeneousGeometry(b))));
                }
            }
            FeatureDataset result2 = new FeatureDataset(result1.getFeatureSchema());
            for (Feature feature : result1.getFeatures()) {
                Geometry geometry = feature.getGeometry();
                if (geometry.isEmpty()) continue;
                if (geometry instanceof GeometryCollection && this.decomposeMulti) {
                    for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                        Feature f = feature.clone(false, false);
                        f.setGeometry(geometry.getGeometryN(i));
                        result2.add(f);
                    }
                    continue;
                }
                result2.add(feature);
            }
            this.workbenchContext.getLayerManager().addLayer(StandardCategoryNames.RESULT, this.layerA.getName() + " " + MINUS + " " + this.layerB.getName(), result2);
            if (this.showNewVertices) {
                FeatureSchema featureSchema = new FeatureSchema();
                featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
                featureSchema.addAttribute("fid", AttributeType.INTEGER);
                FeatureDataset featureDataset = new FeatureDataset(featureSchema);
                ArrayList<Coordinate> cList = new ArrayList<Coordinate>();
                for (Feature o : this.layerA.getFeatureCollectionWrapper().getFeatures()) {
                    Geometry g = o.getGeometry();
                    for (Coordinate c : g.getCoordinates()) {
                        cList.add(c);
                    }
                }
                Collections.sort(cList);
                GeometryFactory gf = new GeometryFactory();
                for (Feature o : result2.getFeatures()) {
                    Geometry g = o.getGeometry();
                    for (Coordinate c : g.getCoordinates()) {
                        if (Collections.binarySearch(cList, c) >= 0) continue;
                        BasicFeature f = new BasicFeature(featureSchema);
                        f.setGeometry((Geometry)gf.createPoint(c));
                        f.setAttribute("fid", (Object)o.getID());
                        featureDataset.add(f);
                    }
                }
                this.workbenchContext.getLayerManager().addLayer(StandardCategoryNames.RESULT, this.layerA.getName() + " - " + VERTEX_LAYER_SUFFIX, featureDataset);
            }
            this.layerA.setVisible(false);
        }
    }

    private Collection<Feature> processCollection(TaskMonitor monitor, Collection<Feature> fcA, STRtree index, EditTransaction transaction) {
        ArrayList<Feature> resultColl = new ArrayList<Feature>();
        int total = fcA.size();
        int count = 0;
        for (Feature fSrc : fcA) {
            monitor.report(count++, total, sFeatures);
            if (monitor.isCancelRequested()) {
                return null;
            }
            Geometry gSrc = fSrc.getGeometry();
            if (gSrc == null) continue;
            List candidates = index.query(fSrc.getGeometry().getEnvelopeInternal());
            Geometry resultGeom = this.getHomogeneousGeometry(fSrc.getGeometry());
            for (Geometry b : candidates) {
                resultGeom = this.getHomogeneousGeometry(this.erase(resultGeom, this.getHomogeneousGeometry(b)));
            }
            if (resultGeom.isEmpty() && this.updateMode) {
                transaction.deleteFeature(fSrc);
                continue;
            }
            if (this.updateMode && !fSrc.getGeometry().equals(resultGeom)) {
                transaction.modifyFeatureGeometry(fSrc, resultGeom);
                continue;
            }
            resultColl.add(fSrc);
        }
        return resultColl;
    }

    private Geometry erase(Geometry a, Geometry b) {
        if (this.useOverlayNG) {
            return OverlayNGRobust.overlay((Geometry)a, (Geometry)b, (int)3);
        }
        return a.difference(b);
    }

    private Geometry getHomogeneousGeometry(Geometry geom) {
        if (geom.isEmpty()) {
            return geom;
        }
        if (!geom.getGeometryType().equals("GeometryCollection")) {
            return geom;
        }
        int dim = geom.getDimension();
        ArrayList list = new ArrayList();
        switch (dim) {
            case 0: {
                PointExtracter.getPoints((Geometry)geom, list);
                break;
            }
            case 1: {
                LineStringExtracter.getLines((Geometry)geom, list);
                break;
            }
            case 2: {
                PolygonExtracter.getPolygons((Geometry)geom, list);
                break;
            }
            default: {
                return geom;
            }
        }
        return geom.getFactory().buildGeometry(list);
    }
}

