/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.task;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.util.java2xml.XML2Java;
import com.vividsolutions.jump.workbench.imagery.ImageryLayerDataset;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.PlugInManager;
import java.awt.Component;
import java.awt.Container;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.openjump.core.ccordsys.utils.ProjUtils;
import org.openjump.core.ccordsys.utils.SRSInfo;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.TiffTags;

public class Utils {
    public static List<String> getNamesOfLayerableList(PlugInContext context) {
        ArrayList<String> ListImageLayerNames = new ArrayList<String>();
        List<Layerable> layerables = context.getTask().getLayerManager().getLayerables(Layerable.class);
        for (Layerable layerable : layerables) {
            ListImageLayerNames.add(layerable.getName());
        }
        return ListImageLayerNames;
    }

    public static String getLayerableType(Layerable layer) {
        String sclass = "";
        sclass = layer.getClass().getSimpleName();
        return sclass;
    }

    public static String getLayerableSRS(Layerable layer) {
        String name = "";
        String sclass = layer.getClass().getSimpleName();
        if (sclass.equals("WMSLayer")) {
            WMSLayer wlyr = (WMSLayer)layer;
            name = StringUtils.remove((String)wlyr.getSRS(), (String)"EPSG:");
        } else if (sclass.equals("RasterImageLayer")) {
            RasterImageLayer wlyr = (RasterImageLayer)layer;
            try {
                name = Utils.rasterProjection(wlyr);
            }
            catch (Exception e) {
                name = "0";
                e.printStackTrace();
            }
        } else {
            Layer wlyr = (Layer)layer;
            try {
                SRSInfo srsInfo = ProjUtils.getSRSInfoFromLayerStyleOrSource(wlyr);
                name = srsInfo.getCode();
            }
            catch (Exception e) {
                name = "0";
                e.printStackTrace();
            }
        }
        return name;
    }

    public static String rasterProjection(RasterImageLayer layer) throws Exception {
        TiffTags.TiffMetadata metadata;
        String fileSourcePath = layer.getImageFileName();
        String extension = FileUtil.getExtension(fileSourcePath).toLowerCase();
        SRSInfo srsInfo = extension.equals("tif") || extension.equals("tiff") ? ((metadata = TiffTags.readMetadata(new File(fileSourcePath))).isGeoTiff() ? metadata.getSRSInfo() : ProjUtils.getSRSInfoFromAuxiliaryFile(fileSourcePath)) : ProjUtils.getSRSInfoFromAuxiliaryFile(fileSourcePath);
        String proj_coordinate = srsInfo.getCode();
        return proj_coordinate;
    }

    public static boolean isTable(Layer layer) {
        FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
        List<Feature> featureList = featureCollection.getFeatures();
        Geometry nextGeo = null;
        for (Feature feature : featureList) {
            nextGeo = feature.getGeometry();
        }
        return !featureCollection.isEmpty() && nextGeo.isEmpty();
    }

    public static boolean checkTemporaryLayerables(PlugInContext context) {
        ArrayList<String> temporalLayerables = new ArrayList<String>();
        List<RasterImageLayer> rlayers = context.getLayerManager().getLayerables(RasterImageLayer.class);
        for (RasterImageLayer rLayer : rlayers) {
            if (!rLayer.getImageFileName().contains(System.getProperty("java.io.tmpdir"))) continue;
            temporalLayerables.add(rLayer.getName());
        }
        List<Layer> layers = context.getLayerManager().getLayers();
        for (Layer layer : layers) {
            if (layer.hasReadableDataSource() && !Utils.getLayerablePath(layer).contains(System.getProperty("java.io.tmpdir")) && layer.getDataSourceQuery() != null) continue;
            temporalLayerables.add(layer.getName());
        }
        return !temporalLayerables.isEmpty();
    }

    public static boolean checkModifiedLayers(PlugInContext context) {
        ArrayList<String> modifiedLayers = new ArrayList<String>();
        List<Layer> layers = context.getLayerManager().getLayers();
        for (Layer layer : layers) {
            if (!(layer.hasReadableDataSource() & !Utils.getLayerablePath(layer).contains(System.getProperty("java.io.tmpdir")) & layer.isFeatureCollectionModified())) continue;
            modifiedLayers.add(layer.getName());
        }
        return !modifiedLayers.isEmpty();
    }

    public static boolean checkTempAndModLayerables(PlugInContext context) {
        ArrayList<String> temporalLayerables = new ArrayList<String>();
        List<RasterImageLayer> rlayers = context.getLayerManager().getLayerables(RasterImageLayer.class);
        for (RasterImageLayer currentLayer : rlayers) {
            if (!currentLayer.getImageFileName().contains(System.getProperty("java.io.tmpdir"))) continue;
            temporalLayerables.add(currentLayer.getName());
        }
        List<Layer> layers = context.getLayerManager().getLayers();
        for (Layer currentLayer : layers) {
            if (currentLayer.hasReadableDataSource() && !Utils.getLayerablePath(currentLayer).contains(System.getProperty("java.io.tmpdir")) && currentLayer.getDataSourceQuery() != null) continue;
            temporalLayerables.add(currentLayer.getName());
        }
        for (Layer currentLayer : context.getLayerManager().getLayersWithModifiedFeatureCollections()) {
            if (Utils.checkTemporaryLayerables(context)) continue;
            temporalLayerables.add(currentLayer.getName());
        }
        return !temporalLayerables.isEmpty();
    }

    public static String getLayerableName(Layerable layer) {
        String name = "";
        String sclass = layer.getClass().getSimpleName();
        if (sclass.equals("RasterImageLayer")) {
            RasterImageLayer rlay = (RasterImageLayer)layer;
            name = rlay.getImageFileName().contains(System.getProperty("java.io.tmpdir")) ? "(**) " + rlay.getName() : rlay.getName();
        } else if (sclass.equals("WMSLayer")) {
            WMSLayer wlyr = (WMSLayer)layer;
            name = wlyr.getName();
        } else {
            Layer lay = (Layer)layer;
            if (!lay.hasReadableDataSource() || Utils.getLayerablePath(lay).contains(System.getProperty("java.io.tmpdir")) || lay.getDataSourceQuery() == null) {
                name = "<font color=\"red\">(**) " + lay.getName();
            } else if (lay.hasReadableDataSource() & lay.isFeatureCollectionModified()) {
                name = "<font color=\"red\">(*) " + lay.getName();
            } else if (lay.hasReadableDataSource() & !lay.isFeatureCollectionModified()) {
                name = lay.getName();
            }
        }
        return name;
    }

    public static String getLayerablePath(Layerable layer) {
        String path = "";
        String sclass = layer.getClass().getSimpleName();
        if (sclass.equals("WMSLayer")) {
            try {
                WMSLayer lay = (WMSLayer)layer;
                path = lay.getServerURL();
            }
            catch (Exception ex) {
                path = "";
            }
        } else if (sclass.equals("RasterImageLayer")) {
            try {
                RasterImageLayer lay = (RasterImageLayer)layer;
                path = lay.getFilePath();
            }
            catch (Exception ex) {
                path = "";
            }
        } else if (sclass.equals("ReferencedImagesLayer")) {
            try {
                Layer lay = (Layer)layer;
                FeatureCollectionWrapper featureCollection = lay.getFeatureCollectionWrapper();
                for (Feature feature : featureCollection) {
                    String filePath1;
                    String sourcePathImage = feature.getString(ImageryLayerDataset.ATTR_URI);
                    sourcePathImage = sourcePathImage.substring(5);
                    File f = new File(sourcePathImage);
                    String filePath = f.getAbsolutePath();
                    path = filePath1 = filePath.replace("%20", " ");
                }
            }
            catch (Exception ex) {
                path = "";
            }
        } else {
            Layer lay = (Layer)layer;
            DataSourceQuery dsq = lay.getDataSourceQuery();
            if (dsq != null) {
                Object fnameObj = dsq.getDataSource().getProperties().get("File");
                if (fnameObj == null) {
                    fnameObj = dsq.getDataSource().getProperties().get("Connection Descriptor");
                }
                if (fnameObj != null) {
                    path = fnameObj.toString();
                }
            }
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> mapSRIDS() throws IOException {
        LinkedHashMap<String, String> localLinkedHashMap = new LinkedHashMap<String, String>();
        InputStream localInputStream = ProjUtils.class.getResourceAsStream("srid.txt");
        try {
            String str1;
            BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(localInputStream));
            String str2 = null;
            while (null != (str1 = localBufferedReader.readLine())) {
                if (str1.startsWith("<")) {
                    int first = str1.indexOf("<");
                    int next = str1.indexOf(">", first);
                    String str3 = str1.substring(first + 1, next);
                    localLinkedHashMap.put(str3, str3);
                    if (str2 != null && str2.length() > 0) {
                        localLinkedHashMap.put(str2, str3);
                    }
                    str2 = null;
                    continue;
                }
                str2 = null;
            }
            LinkedHashMap<String, String> linkedHashMap = localLinkedHashMap;
            return linkedHashMap;
        }
        finally {
            if (localInputStream != null) {
                try {
                    localInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] mapSRIDasString() throws IOException {
        String[] arr = null;
        ArrayList<String> codes = new ArrayList<String>();
        InputStream localInputStream = ProjUtils.class.getResourceAsStream("srid.txt");
        try {
            String str1;
            BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(localInputStream));
            while (null != (str1 = localBufferedReader.readLine())) {
                if (!str1.startsWith("<")) continue;
                String str3 = str1.substring(1, str1.indexOf(">"));
                codes.add(str3);
            }
            String[] stringArray = arr = codes.toArray(new String[codes.size()]);
            return stringArray;
        }
        finally {
            if (localInputStream != null) {
                try {
                    localInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void removeButton(Container container) {
        Component[] components;
        for (Component component : components = container.getComponents()) {
            if (!(component instanceof AbstractButton)) continue;
            container.remove(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restorePropertiesFromFile(Task task, File file, PlugInContext context) throws Exception {
        try (FileReader reader = new FileReader(file);){
            Task sourceTask = (Task)new XML2Java(context.getWorkbenchContext().getWorkbench().getPlugInManager().getClassLoader()).read(reader, Task.class);
            task.setProperties(sourceTask.getProperties());
        }
    }

    public static Map<QName, Object> getSavedProperties(PlugInContext context, File file) {
        Task sourceTask = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e1) {
            context.getWorkbenchFrame().warnUser(I18N.getInstance().get("org.openjump.core.ui.plugin.layer.pirolraster.SaveRasterImageAsImagePlugIn.File-not-found"));
        }
        PlugInManager plugInManager = context.getWorkbenchContext().getWorkbench().getPlugInManager();
        ClassLoader pluginClassLoader = plugInManager.getClassLoader();
        try {
            sourceTask = (Task)new XML2Java(pluginClassLoader).read(inputStream, Task.class);
            sourceTask.getProperties();
        }
        catch (Exception e) {
            context.getWorkbenchFrame().warnUser("Missing class: " + e.getCause());
        }
        return sourceTask.getProperties();
    }
}

