/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.style;

import com.vividsolutions.jump.I18N;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openjump.core.ui.swing.SelectFromListPanel;
import org.openjump.util.SLDImporter;
import org.w3c.dom.Document;

public class StyleChooserPanel
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 7546547595382784628L;
    private Document doc;
    private SelectFromListPanel type;
    private SelectFromListPanel select;
    private static final String LABEL = I18N.getInstance().get("org.openjump.core.ui.plugin.style.ImportSLDPlugIn.Label-Styles");
    private static final String BASIC = I18N.getInstance().get("org.openjump.core.ui.plugin.style.ImportSLDPlugIn.Basic-Styles");
    private static final String THEMING = I18N.getInstance().get("org.openjump.core.ui.plugin.style.ImportSLDPlugIn.Color-Theming-Styles");

    public StyleChooserPanel(Document doc) {
        this.doc = doc;
        this.type = new SelectFromListPanel("none");
        this.select = new SelectFromListPanel("none");
        this.type.list.addListSelectionListener(this);
        Vector<String> types = new Vector<String>();
        types.add(BASIC);
        types.add(LABEL);
        types.add(THEMING);
        this.type.list.setListData(types);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        GridBagConstraints gb = new GridBagConstraints();
        gb.insets = new Insets(2, 2, 2, 2);
        gb.gridx = 0;
        gb.gridy = 0;
        this.add((Component)this.type, gb);
        ++gb.gridx;
        this.add((Component)this.select, gb);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.type.list.getSelectedValue().equals(LABEL)) {
            this.select.list.setListData(new Vector<String>(SLDImporter.getRuleNamesWithTextSymbolizers(this.doc)));
        }
        if (this.type.list.getSelectedValue().equals(BASIC)) {
            this.select.list.setListData(new Vector<String>(SLDImporter.getRuleNamesWithGeometrySymbolizers(this.doc)));
        }
        if (this.type.list.getSelectedValue().equals(THEMING)) {
            this.select.list.setListData(new Vector<String>(SLDImporter.getPossibleColorThemingStyleNames(this.doc)));
        }
    }

    public String getSelectedStyle() {
        return (String)this.select.list.getSelectedValue();
    }
}

