/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.SaveFileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openjump.core.apitools.IOTools;
import org.openjump.core.ui.io.file.FileNameExtensionFilter;

public class SaveStylePlugIn
extends ThreadedBasePlugIn {
    public static final ImageIcon ICON = IconLoader.icon("style_out.png");
    private final String name = I18N.getInstance().get("org.openjump.core.ui.plugin.style.StylePlugIns.export-style");
    File file;
    Layer layer;
    private final FileNameExtensionFilter filter = new FileNameExtensionFilter("JUMP layer symbology", "style.xml");
    private final FileNameExtensionFilter filter2 = new FileNameExtensionFilter("Spatial layer descriptor", "sld");
    private JFileChooser fc;
    private static final String FILE_CHOOSER_DIRECTORY_KEY = SaveFileDataSourceQueryChooser.class.getName() + " - FILE CHOOSER DIRECTORY";

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        this.fc = new GUIUtil.FileChooserWithOverwritePrompting();
        this.layer = context.getSelectedLayer(0);
        if (PersistentBlackboardPlugIn.get(context.getWorkbenchContext()).get(FILE_CHOOSER_DIRECTORY_KEY) != null) {
            this.fc.setCurrentDirectory(new File((String)PersistentBlackboardPlugIn.get(context.getWorkbenchContext()).get(FILE_CHOOSER_DIRECTORY_KEY)));
        }
        this.fc.setSelectedFile(new File(this.fc.getCurrentDirectory(), this.layer.getName().replaceAll("[/:\\\\><\\|]", "_")));
        this.fc.setDialogTitle(this.name);
        this.fc.setDialogType(1);
        this.fc.setFileFilter(this.filter2);
        this.fc.setFileFilter(this.filter);
        this.fc.addChoosableFileFilter(this.filter);
        return true;
    }

    public EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory ecf = EnableCheckFactory.getInstance(workbenchContext);
        MultiEnableCheck mec = new MultiEnableCheck().add(ecf.createWindowWithLayerNamePanelMustBeActiveCheck()).add(ecf.createExactlyNLayerablesMustBeSelectedCheck(1, Layer.class));
        return mec;
    }

    private void monitor(TaskMonitor monitor, File file) {
        monitor.allowCancellationRequests();
        monitor.report(I18N.getInstance().get("ui.plugin.SaveDatasetAsPlugIn.saving") + ": " + file.getAbsolutePath());
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        if (0 != this.fc.showSaveDialog(context.getWorkbenchFrame())) {
            return;
        }
        String filePath = "";
        if (this.fc.getFileFilter().equals(this.filter)) {
            this.file = this.fc.getSelectedFile();
            this.file = FileUtil.addExtensionIfNone(this.file, "style.xml");
            this.monitor(monitor, this.file);
            IOTools.saveSimbology_Jump(this.file, this.layer);
            filePath = this.file.getAbsolutePath();
        } else if (this.fc.getFileFilter().equals(this.filter2)) {
            this.file = this.fc.getSelectedFile();
            this.file = FileUtil.addExtensionIfNone(this.file, "sld");
            this.monitor(monitor, this.file);
            IOTools.saveSimbology_SLD2(this.file, this.layer);
            filePath = this.file.getAbsolutePath();
        }
        JOptionPane.showMessageDialog(JUMPWorkbench.getInstance().getFrame(), I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.file.saved") + ": " + filePath, this.getName(), -1);
    }
}

