/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.Viewport;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.rasterimage.ImageAndMetadata;
import org.openjump.core.rasterimage.RasterImageIO;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.Resolution;
import org.openjump.core.rasterimage.TiffTags;
import org.openjump.core.rasterimage.algorithms.VectorizeAlgorithm;
import org.openjump.core.rasterimage.sextante.OpenJUMPSextanteRasterLayer;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridWrapperNotInterpolated;
import org.openjump.core.ui.plugin.raster.Utils;
import org.openjump.core.ui.util.LayerableUtil;

public class VectorizeToContoursPlugIn
extends ThreadedBasePlugIn {
    private static I18N i18n = I18N.getInstance();
    private static String PROCESSING = I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.processing");
    private static String sLayer = I18N.getInstance().get("ui.GenericNames.Source-Layer");
    private static String NAME = I18N.getInstance().get("ui.plugin.raster.VectorizeToContoursPlugIn.Name");
    private static String sValue = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterQueryPlugIn.value");
    private static String sStyle = I18N.getInstance().get("ui.plugin.raster.VectorizeToContoursPlugIn.apply-random-style");
    public static String contour_baseContour = I18N.getInstance().get("ui.plugin.raster.VectorizeToContoursPlugIn.base-contour");
    public static String contour_distanceContours = I18N.getInstance().get("ui.plugin.raster.VectorizeToContoursPlugIn.interval");
    public static String contour_minContour = I18N.getInstance().get("ui.plugin.raster.VectorizeToContoursPlugIn.min-contour");
    public static String contour_maxcontour = I18N.getInstance().get("ui.plugin.raster.VectorizeToContoursPlugIn.max-contour");
    public static String contour_contourNumber = I18N.getInstance().get("ui.plugin.raster.VectorizeToContoursPlugIn.contour-number");
    private final String MIN = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.nodata.min");
    private final String MAX = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.nodata.max");
    JTextField jTextField_ContBase;
    JTextField jTextField_ContIntv;
    JTextField jTextField_ContMin;
    JTextField jTextField_ContMax;
    JTextField jTextField_ContCount;
    JTextField max;
    JTextField min;
    private double min_value;
    private double max_value;
    private int contCount = -1;
    private double contBase = 0.0;
    private int contIntv = 100;
    private double contMin = -1.0;
    private double contMax = -1.0;
    boolean applystyleb = false;
    List<RasterImageLayer> fLayers = new ArrayList<RasterImageLayer>();
    JComboBox<RasterImageLayer> layerableComboBox = new JComboBox();
    RasterImageLayer layer;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), NAME, true);
        this.setDialogValues(dialog, context);
        if (this.fLayers.isEmpty()) {
            return false;
        }
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        if (dialog.wasOKPressed()) {
            this.getDialogValues(dialog);
            return true;
        }
        return false;
    }

    private void setDialogValues(final MultiInputDialog dialog, PlugInContext context) throws IOException {
        dialog.setSideBarDescription(NAME);
        this.layer = !context.getLayerNamePanel().selectedNodes(RasterImageLayer.class).isEmpty() ? (RasterImageLayer)LayerTools.getSelectedLayerable(context, RasterImageLayer.class) : context.getTask().getLayerManager().getLayerables(RasterImageLayer.class).get(0);
        this.findParameters(this.layer);
        this.fLayers = context.getTask().getLayerManager().getLayerables(RasterImageLayer.class);
        this.layerableComboBox = dialog.addLayerableComboBox(sLayer, this.layer, "", this.fLayers);
        this.layerableComboBox.setSize(200, this.layerableComboBox.getPreferredSize().height);
        this.layerableComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VectorizeToContoursPlugIn.this.layer = (RasterImageLayer)dialog.getLayerable(sLayer);
                VectorizeToContoursPlugIn.this.findParameters(VectorizeToContoursPlugIn.this.layer);
                dialog.pack();
                dialog.repaint();
            }
        });
        this.min = dialog.addDoubleField(this.MIN, this.min_value, 20);
        this.min.setEditable(false);
        this.max = dialog.addDoubleField(this.MAX, this.max_value, 20);
        this.max.setEditable(false);
        this.jTextField_ContBase = dialog.addDoubleField(contour_baseContour, this.contBase, 20);
        this.jTextField_ContBase.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                VectorizeToContoursPlugIn.this.contIntv = dialog.getInteger(contour_distanceContours);
                VectorizeToContoursPlugIn.this.contBase = dialog.getDouble(contour_baseContour);
                VectorizeToContoursPlugIn.this.findParameters(VectorizeToContoursPlugIn.this.layer);
                dialog.pack();
                dialog.repaint();
            }
        });
        this.jTextField_ContIntv = dialog.addIntegerField(contour_distanceContours, this.contIntv, 20, "");
        this.jTextField_ContIntv.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                VectorizeToContoursPlugIn.this.contIntv = dialog.getInteger(contour_distanceContours);
                VectorizeToContoursPlugIn.this.contBase = dialog.getDouble(contour_baseContour);
                VectorizeToContoursPlugIn.this.findParameters(VectorizeToContoursPlugIn.this.layer);
                dialog.pack();
                dialog.repaint();
            }
        });
        this.jTextField_ContMin = dialog.addDoubleField(contour_minContour, this.contMin, 20);
        this.jTextField_ContMin.setEditable(false);
        this.jTextField_ContMax = dialog.addDoubleField(contour_maxcontour, this.contMax, 20);
        this.jTextField_ContMax.setEditable(false);
        this.jTextField_ContCount = dialog.addIntegerField(contour_contourNumber, this.contCount, 20, "");
        this.jTextField_ContCount.setEditable(false);
        dialog.addCheckBox(sStyle, true);
    }

    private void findParameters(RasterImageLayer layer) {
        this.min_value = layer.getMetadata().getStats().getMin(0);
        this.max_value = layer.getMetadata().getStats().getMax(0);
        try {
            if (this.contBase < this.min_value) {
                this.contMin = this.contBase;
                while (this.contMin < this.min_value) {
                    this.contMin += (double)this.contIntv;
                }
                this.contMax = this.contMin;
                while (this.contMax < this.max_value) {
                    this.contMax += (double)this.contIntv;
                }
                this.contMax -= (double)this.contIntv;
            } else if (this.contBase == this.min_value) {
                this.contMin = this.min_value;
                this.contMax = this.min_value;
                while (this.contMax < this.max_value) {
                    this.contMax += (double)this.contIntv;
                }
                this.contMax -= (double)this.contIntv;
            } else if (this.contBase > this.min_value && this.contBase < this.max_value) {
                this.contMin = this.contBase;
                while (this.contMin > this.min_value) {
                    this.contMin -= (double)this.contIntv;
                }
                this.contMin += (double)this.contIntv;
                this.contMax = this.contBase;
                while (this.contMax < this.max_value) {
                    this.contMax += (double)this.contIntv;
                }
                this.contMax -= (double)this.contIntv;
            } else if (this.contBase == this.max_value) {
                this.contMin = this.contMax;
                while (this.contMin > this.min_value) {
                    this.contMin -= (double)this.contIntv;
                }
                this.contMin += (double)this.contIntv;
                this.contMax = this.max_value;
            } else if (this.contBase > this.max_value) {
                this.contMax = this.contBase;
                while (this.contMax > this.max_value) {
                    this.contMax -= (double)this.contIntv;
                }
                this.contMin = this.contMax;
                while (this.contMin > this.min_value) {
                    this.contMin -= (double)this.contIntv;
                }
                this.contMin += (double)this.contIntv;
            }
            this.contCount = (int)Math.ceil((this.contMax - this.contMin) / (double)this.contIntv) + 1;
            this.min.setText(this.min_value + "");
            this.max.setText(this.max_value + "");
            this.jTextField_ContMin.setText(this.contMin + "");
            this.jTextField_ContMax.setText(this.contMax + "");
            this.jTextField_ContCount.setText(this.contCount + "");
        }
        catch (Exception ex) {
            return;
        }
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer = (RasterImageLayer)dialog.getLayerable(sLayer);
        this.contIntv = dialog.getInteger(contour_distanceContours);
        this.applystyleb = dialog.getBoolean(sStyle);
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.report(PROCESSING);
        this.reportNothingToUndoYet(context);
        OpenJUMPSextanteRasterLayer rstLayer = new OpenJUMPSextanteRasterLayer();
        rstLayer.create(this.layer, true);
        GridWrapperNotInterpolated gwrapper = new GridWrapperNotInterpolated(rstLayer, rstLayer.getLayerGridExtent());
        FeatureSchema fs = new FeatureSchema();
        fs.addAttribute("geometry", AttributeType.GEOMETRY);
        fs.addAttribute(sValue, AttributeType.DOUBLE);
        FeatureCollection featDataset = new VectorizeAlgorithm().toContours(gwrapper, this.contMin, this.contMax, this.contIntv, sValue, 0);
        Layer vlayer = context.addLayer(StandardCategoryNames.WORKING, rstLayer.getName() + "_vectorized", featDataset);
        if (this.applystyleb) {
            Utils.applyRandomGradualStyle(vlayer, sValue);
        }
    }

    public void load(File inputFile, String category, PlugInContext context) throws NoninvertibleTransformException, TiffTags.TiffReadingException, Exception {
        RasterImageIO rasterImageIO = new RasterImageIO();
        Point point = RasterImageIO.getImageDimensions(inputFile.getAbsolutePath());
        Envelope env = RasterImageIO.getGeoReferencing(inputFile.getAbsolutePath(), true, point);
        Viewport viewport = context.getLayerViewPanel().getViewport();
        Resolution requestedRes = RasterImageIO.calcRequestedResolution(viewport);
        ImageAndMetadata imageAndMetadata = rasterImageIO.loadImage(inputFile.getAbsolutePath(), null, viewport.getEnvelopeInModelCoordinates(), requestedRes);
        RasterImageLayer ril = new RasterImageLayer(inputFile.getName(), context.getLayerManager(), inputFile.getAbsolutePath(), imageAndMetadata.getImage(), env);
        try {
            category = ((Category)context.getLayerableNamePanel().getSelectedCategories().toArray()[0]).getName();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        context.getLayerManager().addLayerable(category, ril);
    }

    public static MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithAssociatedTaskFrameMustBeActiveCheck()).add(checkFactory.createAtLeastNLayerablesOfTypeMustExistCheck(1, RasterImageLayer.class)).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                ArrayList<RasterImageLayer> mLayer = new ArrayList<RasterImageLayer>();
                List<RasterImageLayer> rlayers = workbenchContext.getLayerManager().getLayerables(RasterImageLayer.class);
                for (RasterImageLayer currentLayer : rlayers) {
                    if (!LayerableUtil.isMonoband(currentLayer)) continue;
                    mLayer.add(currentLayer);
                }
                if (!mLayer.isEmpty()) {
                    return null;
                }
                String msg = null;
                if (mLayer.isEmpty()) {
                    msg = I18N.getInstance().get("plugin.EnableCheckFactory.at-least-one-single-banded-layer-should-exist");
                }
                return msg;
            }
        });
    }
}

