/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.HTMLPanel;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.Raster;
import java.io.File;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.ccordsys.utils.ProjUtils;
import org.openjump.core.ccordsys.utils.SRSInfo;
import org.openjump.core.ccordsys.utils.SridLookupTable;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.TiffTags;
import org.openjump.core.ui.plugin.raster.RasterImageLayerProperties;
import org.openjump.core.ui.swing.DetachableInternalFrame;
import org.saig.core.gui.swing.sldeditor.util.FormUtils;

public class RasterImageLayerPropertiesPlugIn
extends AbstractPlugIn {
    private JSlider transparencySlider = new JSlider();
    private JPanel transparencySliderPanel = new JPanel(new GridBagLayout());
    private String layer_name;
    private String file_path;
    private String raster_bands;
    private String raster_datatype;
    private String raster_colordepth;
    private String raster_dpi;
    private int extent_columns;
    private int extent_rows;
    private String extent_cellnumber;
    private String extent_cellnumbervalid;
    private String extent_cellnumbernodata;
    private String extent_area;
    private String extent_width;
    private String extent_height;
    private String extent_cellSizeX;
    private String extent_cellSizeY;
    private String extent_minX;
    private String extent_maxX;
    private String extent_minY;
    private String extent_maxY;
    private long file_size;
    private String file_sizeMB;
    private String file_type;
    private String raster_nodata;
    private String proj_file_path;
    private String proj_coordinate;
    private static final String PLUGIN_NAME = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn");
    private static final String LAYER_PROPERTIES = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Layer-Properties");
    private static final String INFO = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Info");
    private static final String PROPORTIONAL_TRANSPARENCY_ADJUSTER = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Proportional-Transparency-Adjustment");
    private static final String TRANSPARENCY = I18N.getInstance().get("ui.renderer.style.ColorThemingPanel.transparency");
    private static final String FILE = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.namefile");
    private static final String FILE_NAME = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Source-Path");
    private static final String FILE_TYPE = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.type");
    private static final String FILE_DIMENSION = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.dimension");
    private static final String RASTER = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.raster");
    private static final String RASTER_BANDS = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.file.bands_number");
    private static final String RASTER_DPI = "DPI";
    private static final String RASTER_DATATYPE = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.datatype");
    private static final String RASTER_COLORDEPTH = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.colordepth");
    private static final String RASTER_NODATA = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.cell.nodata");
    private static final String EXTENT = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.extent");
    private static final String EXTENT_XMIN = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.xmin");
    private static final String EXTENT_YMIN = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.ymin");
    private static final String EXTENT_XMAX = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.xmax");
    private static final String EXTENT_YMAX = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.ymax");
    private static final String EXTENT_SIZE = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.dimension_raster");
    private static final String EXTENT_CELL_SIZE = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.dimension_cell");
    private static final String EXTENT_CELL_NUM = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.cellnum");
    private static final String EXTENT_CELL_NODATA = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.nodatacell");
    private static final String EXTENT_CELL_VALID = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.validcells");
    private static final String EXTENT_AREA = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.area");
    private static final String BAND = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.CreatePolygonGridFromSelectedImageLayerPlugIn.band");
    private static final String LAYER = I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.plugin.AddNewLayerPlugIn.name");
    private static final String NAME = I18N.getInstance().get("jump.workbench.ui.plugin.datastore.ConnectionDescriptorPanel.Name");
    private static final String SEXTANTE = I18N.getInstance().get("org.openjump.core.rasterimage.AddRasterImageLayerWizard.Sextante-Raster-Image");
    private static final String NOT_SAVED = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Not-Saved");
    private static final String CANCEL = I18N.getInstance().get("ui.OKCancelPanel.cancel");
    private static final String OK = I18N.getInstance().get("ui.OKCancelPanel.ok");
    private static final String COORDINATE_SYSTEM = I18N.getInstance().get("datasource.FileDataSourceQueryChooser.coordinate-system-of-file");
    private static final String R_MAX = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.maximum");
    private static final String R_MIN = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.minimum");
    private static final String R_MEAN = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.mean");
    private static final String R_STD = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.standard-dev");
    private static final String PROJECTION = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.projection");
    private Envelope extent;
    private final String bgColor0 = "\"#FEEDD6\"";
    private final String bgColor1 = "\"#EAEAEA\"";
    private final String bgColor3 = "\"#FBFFE1\"";
    private final String bgColor4 = "\"#CCCCCC\"";

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        MultiEnableCheck multiEnableCheck = new MultiEnableCheck();
        multiEnableCheck.add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, RasterImageLayer.class));
        return multiEnableCheck;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("information_16x16.png");
    }

    @Override
    public String getName() {
        return PLUGIN_NAME;
    }

    public String title(String textA, String textB) {
        String cabecera = "  <tr valign=\"top\">     <td width=\"400\" height=\"18\" align=\"center\"><font face=\"Arial\" size=\"4\" align=\"right\"><b>" + textA + "</b></font></td>     <td width=\"1586\" height=\"18\" align=\"left\"><font face=\"Arial\" size=\"4\"><b>" + textB + "</b></font></td>  </tr>";
        return cabecera;
    }

    public String header(String textA, String textB) {
        String cabecera = "  <tr valign=\"top\">     <td width=\"400\" height=\"18\" bgcolor=\"#FBFFE1\"align=\"center\"><font face=\"Arial\" size=\"3\" align=\"right\"><b>" + textA + "</b></font></td>     <td width=\"1586\" height=\"18\" bgcolor=" + "\"#FBFFE1\"" + "align=\"center\"><font face=\"Arial\" size=\"3\"><b>" + textB + "</b></font></td>  </tr>";
        return cabecera;
    }

    public String property(String textA, String textB, String color) {
        String propiedad = "  <tr valign=\"top\">     <td width=\"400\" height=\"18\" bgcolor=\"#CCCCCC\"align=\"right\"><font face=\"Arial\" size=\"3\" align=\"right\">" + textA + "</font></td>     <td width=\"1586\" height=\"18\" bgcolor=" + color + "align=\"left\"><font face=\"Arial\" size=\"3\">" + textB + "</font></td>  </tr>";
        return propiedad;
    }

    public String infoText(RasterImageLayer rLayer) throws Exception {
        this.setInfo(rLayer);
        this.setInfoProjection(rLayer);
        int numBands = rLayer.getNumBands();
        String info = "";
        info = info + this.title(INFO, "");
        info = info + this.header("", LAYER);
        info = info + this.property(NAME, this.layer_name, "\"#FEEDD6\"");
        info = info + this.header("", FILE);
        if (rLayer.getImageFileName().contains(System.getProperty("java.io.tmpdir"))) {
            info = info + this.property(FILE_NAME, NOT_SAVED, "\"#EAEAEA\"");
            info = info + this.header("", COORDINATE_SYSTEM);
            info = info + this.property(PROJECTION, this.proj_coordinate, "\"#EAEAEA\"");
            info = info + this.property(FILE_NAME, this.proj_file_path, "\"#FEEDD6\"");
        } else {
            info = info + this.property(FILE_TYPE, this.file_type, "\"#FEEDD6\"");
            info = info + this.property(FILE_NAME, this.file_path, "\"#EAEAEA\"");
            info = info + this.property(FILE_DIMENSION, this.file_sizeMB + " (" + this.file_size + " bytes)", "\"#FEEDD6\"");
            info = info + this.header("", COORDINATE_SYSTEM);
            info = info + this.property(PROJECTION, this.proj_coordinate, "\"#EAEAEA\"");
            info = info + this.property(FILE_NAME, this.proj_file_path, "\"#FEEDD6\"");
        }
        info = info + this.header("", EXTENT);
        info = info + this.property(EXTENT_XMIN, this.extent_minX, "\"#FEEDD6\"");
        info = info + this.property(EXTENT_XMAX, this.extent_maxX, "\"#EAEAEA\"");
        info = info + this.property(EXTENT_YMIN, this.extent_minY, "\"#FEEDD6\"");
        info = info + this.property(EXTENT_YMAX, this.extent_maxY, "\"#EAEAEA\"");
        info = info + this.property(EXTENT_SIZE, this.extent_width + " x " + this.extent_height + " (" + EXTENT_AREA + ": " + this.extent_area + ")", "\"#FEEDD6\"");
        info = info + this.property(EXTENT_CELL_SIZE, this.extent_cellSizeX + ", " + this.extent_cellSizeY, "\"#EAEAEA\"");
        info = info + this.property(EXTENT_CELL_NUM, this.extent_cellnumber, "\"#FEEDD6\"");
        if (rLayer.getNumBands() == 1) {
            info = info + this.property(EXTENT_CELL_VALID, this.extent_cellnumbervalid, "\"#EAEAEA\"");
            info = info + this.property(EXTENT_CELL_NODATA, this.extent_cellnumbernodata, "\"#FEEDD6\"");
        }
        info = info + this.header("", RASTER);
        info = info + this.property(RASTER_DPI, this.raster_dpi, "\"#FEEDD6\"");
        info = info + this.property(RASTER_DATATYPE, this.raster_datatype, "\"#EAEAEA\"");
        info = info + this.property(RASTER_COLORDEPTH, this.raster_colordepth, "\"#FEEDD6\"");
        info = info + this.property(RASTER_BANDS, this.raster_bands, "\"#EAEAEA\"");
        if (rLayer.getNumBands() == 1) {
            info = info + this.property(RASTER_NODATA, this.raster_nodata, "\"#FEEDD6\"");
        }
        for (int b = 0; b < numBands; ++b) {
            int numerobanda = b + 1;
            info = info + this.header("", BAND + " - " + numerobanda);
            info = info + this.property(R_MIN, String.valueOf(rLayer.getMetadata().getStats().getMin(b)), "\"#FEEDD6\"");
            info = info + this.property(R_MAX, String.valueOf(rLayer.getMetadata().getStats().getMax(b)), "\"#EAEAEA\"");
            info = info + this.property(R_MEAN, String.valueOf(rLayer.getMetadata().getStats().getMean(b)), "\"#FEEDD6\"");
            info = info + this.property(R_STD, String.valueOf(rLayer.getMetadata().getStats().getStdDev(b)), "\"#EAEAEA\"");
        }
        String table = "<table border='0.1'>";
        String table2 = "</table>";
        String infotext = "<html>" + table + info + table2 + "</html>";
        return infotext;
    }

    private JPanel Transparency(final RasterImageLayer layer) {
        this.transparencySliderPanel.setBorder(BorderFactory.createTitledBorder(PROPORTIONAL_TRANSPARENCY_ADJUSTER));
        Box box = new Box(1);
        Hashtable<Integer, JLabel> sliderLabelDictionary = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 100; i += 25) {
            ((Dictionary)sliderLabelDictionary).put(i, new JLabel(i + "%"));
        }
        this.transparencySlider.setMinimumSize(new Dimension(200, 20));
        this.transparencySlider.setPreferredSize(new Dimension(460, 50));
        this.transparencySlider.setPaintLabels(true);
        this.transparencySlider.setPaintTicks(true);
        this.transparencySlider.setLabelTable(sliderLabelDictionary);
        this.transparencySlider.setMajorTickSpacing(10);
        this.transparencySlider.setMinorTickSpacing(5);
        this.transparencySlider.setMaximum(100);
        this.transparencySlider.setMinimum(0);
        this.transparencySlider.setValue((int)(layer.getTransparencyLevel() * 100.0));
        box.add(this.transparencySlider);
        this.transparencySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    int newTransparencyValue = RasterImageLayerPropertiesPlugIn.this.transparencySlider.getValue();
                    layer.setTransparencyLevelInPercent(newTransparencyValue);
                    layer.fireAppearanceChanged();
                }
            }
        });
        this.transparencySliderPanel.add(box);
        return this.transparencySliderPanel;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        final RasterImageLayer rLayer = (RasterImageLayer)LayerTools.getSelectedLayerable(context, RasterImageLayer.class);
        final double transparency = rLayer.getTransparencyLevel();
        final DetachableInternalFrame frame = new DetachableInternalFrame(LAYER_PROPERTIES + ": " + rLayer.getName());
        frame.setIconifiable(true);
        frame.setFrameIcon(IconLoader.icon("information_16x16.png"));
        HTMLPanel infoHTML = new HTMLPanel();
        infoHTML.getRecordPanel().removeAll();
        infoHTML.createNewDocument();
        infoHTML.append(this.infoText(rLayer));
        JTabbedPane tabbedPane = new JTabbedPane();
        CompoundBorder mainComponentBorder = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel panelTransparency = new JPanel();
        FormUtils.addRowInGBL(panelTransparency, 1, 0, this.Transparency(rLayer));
        tabbedPane.setBorder(mainComponentBorder);
        tabbedPane.addTab(INFO, this.getIcon(), infoHTML, "");
        tabbedPane.addTab(TRANSPARENCY, null, panelTransparency, "");
        JButton okButton = new JButton(OK){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(100, 25);
            }
        };
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.dispose();
            }
        });
        JButton cancelButton = new JButton(CANCEL){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(100, 25);
            }
        };
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rLayer.setTransparencyLevel(transparency);
                RasterImageLayerPropertiesPlugIn.this.transparencySlider.setValue((int)transparency * 100);
                frame.dispose();
            }
        });
        JPanel okCancelPane = new JPanel();
        okCancelPane.add(okButton);
        okCancelPane.add(cancelButton);
        frame.add((Component)tabbedPane, "Center");
        frame.add((Component)okCancelPane, "South");
        frame.setClosable(true);
        frame.setResizable(true);
        frame.setMaximizable(true);
        frame.setSize(550, 400);
        frame.setVisible(true);
        frame.setIcon(true);
        context.getWorkbenchFrame().addInternalFrame(frame, true, true);
        return true;
    }

    private void setInfo(RasterImageLayer rLayer) throws Exception {
        this.layer_name = rLayer.getName();
        this.file_path = rLayer.getImageFileName();
        String fileSourcePath = rLayer.getImageFileName();
        String extension = FileUtil.getExtension(fileSourcePath).toLowerCase();
        this.file_type = (extension.equals("tif") || extension.equals("tiff")) && TiffTags.readMetadata(new File(fileSourcePath)).isGeoTiff() ? "GeoTIFF - " + SEXTANTE : RasterImageLayerProperties.getFileExtension(rLayer) + " - " + SEXTANTE;
        this.file_size = RasterImageLayerProperties.getFileSizeBytes(rLayer);
        this.file_sizeMB = RasterImageLayerProperties.getFileSizeMegaBytes(this.file_size);
        this.raster_bands = "" + rLayer.getNumBands();
        Raster raster = rLayer.getRasterData(null);
        this.raster_datatype = RasterImageLayerProperties.getDataType(raster);
        this.raster_colordepth = RasterImageLayerProperties.getColorDepth(raster, new File(rLayer.getFilePath()));
        this.raster_dpi = RasterImageLayerProperties.getDPI(raster, new File(rLayer.getFilePath()));
        this.extent = rLayer.getWholeImageEnvelope();
        this.extent_cellSizeX = "" + RasterImageLayerProperties.cellSizeX(raster, this.extent);
        this.extent_cellSizeY = "" + RasterImageLayerProperties.cellSizeY(raster, this.extent);
        this.extent_columns = RasterImageLayerProperties.getNumColumns(raster);
        this.extent_rows = RasterImageLayerProperties.getNumRows(raster);
        this.extent_cellnumber = String.valueOf(this.extent_columns * this.extent_rows);
        this.extent_area = "" + this.extent.getArea();
        this.extent_width = "" + this.extent.getWidth();
        this.extent_height = "" + this.extent.getHeight();
        this.extent_minX = "" + this.extent.getMinX();
        this.extent_maxX = "" + this.extent.getMaxX();
        this.extent_minY = "" + this.extent.getMinY();
        this.extent_maxY = "" + this.extent.getMaxY();
        this.raster_nodata = String.valueOf(rLayer.getNoDataValue());
        int numBands = rLayer.getNumBands();
        this.raster_bands = String.valueOf(numBands);
        if (rLayer.getNumBands() == 1) {
            this.extent_cellnumbervalid = String.valueOf(RasterImageLayerProperties.getValidCellsNumber(raster, rLayer.getNoDataValue()));
            this.extent_cellnumbernodata = String.valueOf(RasterImageLayerProperties.getNodataCellNumber(raster, rLayer.getNoDataValue()));
        }
    }

    private void setInfoProjection(RasterImageLayer layer) throws Exception {
        try {
            String srsCode = (String)layer.getMetaInformation().getMetaData().get("srid");
            String srsLocation = (String)layer.getMetaInformation().getMetaData().get("srid-location");
            SRSInfo srsInfo = SridLookupTable.getSrsAndUnitFromCode(srsCode);
            this.proj_coordinate = srsInfo.toString();
            this.proj_file_path = srsLocation;
        }
        catch (Exception e) {
            SRSInfo srsInfo = ProjUtils.getSRSInfoFromLayerSource(layer);
            this.proj_coordinate = srsInfo.toString();
            this.proj_file_path = srsInfo.getSource();
        }
    }
}

