/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.queries;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class SearchAllAttributes
extends AbstractPlugIn {
    private static final String SEARCHFOR = I18N.getInstance().get("org.openjump.core.ui.plugin.queries.SearchAllAttributes.search-for");
    private static final String SEARCHALLATTRIBUTES = I18N.getInstance().get("org.openjump.core.ui.plugin.queries.SearchAllAttributes.search-all-attributes");
    private static final String INCLUDEGEOMETRY = I18N.getInstance().get("org.openjump.core.ui.plugin.queries.SearchAllAttributes.include-geometry");
    private static final String MATCHOR = I18N.getInstance().get("org.openjump.core.ui.plugin.queries.SearchAllAttributes.match-any-search-word");
    private static final String MATCHAND = I18N.getInstance().get("org.openjump.core.ui.plugin.queries.SearchAllAttributes.match-all-search-words");
    private static final String MATCHHINT = I18N.getInstance().get("org.openjump.core.ui.plugin.queries.SearchAllAttributes.all-search-words-must-be-ina-single-attribute");
    private static final String CASESENSITIVE = I18N.getInstance().get("org.openjump.core.ui.plugin.queries.SearchAllAttributes.case-sensitive");
    private static final String WHOLEWORD = I18N.getInstance().get("org.openjump.core.ui.plugin.queries.SearchAllAttributes.whole-word");
    private static final String SIDEBARTEXT = I18N.getInstance().get("org.openjump.core.ui.plugin.queries.SearchAllAttributes.search-for-text-in-any-attribute");
    private static final String REGULAREXPRESSIONS = I18N.getInstance().get("org.openjump.core.ui.plugin.queries.SearchAllAttributes.regular-expressions");
    private boolean includeGeometry = false;
    private String searchString = "";
    private int patternCaseOption = 2;
    private boolean wholeWord = false;
    private boolean regularExpressions = false;
    private boolean SHIFT = false;
    private boolean multiWordMatchAnd = true;

    @Override
    public String getName() {
        return SEARCHALLATTRIBUTES;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_QUERIES}, this.getName() + "...", false, IconLoader.icon("search.png"), null);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.includeGeometry = false;
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        KeyEventPostProcessor kepp = new KeyEventPostProcessor(){

            @Override
            public boolean postProcessKeyEvent(KeyEvent e) {
                if (e.isShiftDown()) {
                    SearchAllAttributes.this.SHIFT = true;
                } else {
                    SearchAllAttributes.this.SHIFT = false;
                }
                return true;
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(kepp);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        SelectionManager selectionManager = context.getLayerViewPanel().getSelectionManager();
        if (!this.SHIFT) {
            selectionManager.clear();
        }
        this.searchInAttributes(context, this.searchString);
        return true;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(SIDEBARTEXT);
        dialog.addTextField(SEARCHFOR, this.searchString, 16, null, "Search target");
        dialog.addCheckBox(CASESENSITIVE, this.patternCaseOption == 0);
        dialog.addCheckBox(WHOLEWORD, this.wholeWord);
        dialog.addRadioButton(MATCHAND, "MatchOptions", this.multiWordMatchAnd, MATCHHINT);
        dialog.addRadioButton(MATCHOR, "MatchOptions", !this.multiWordMatchAnd, MATCHHINT);
        dialog.addCheckBox(INCLUDEGEOMETRY, this.includeGeometry);
        dialog.addCheckBox(REGULAREXPRESSIONS, this.regularExpressions);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.searchString = dialog.getText(SEARCHFOR);
        this.wholeWord = dialog.getCheckBox(WHOLEWORD).isSelected();
        this.multiWordMatchAnd = dialog.getRadioButton(MATCHAND).isSelected();
        this.patternCaseOption = dialog.getCheckBox(CASESENSITIVE).isSelected() ? 0 : 2;
        this.includeGeometry = dialog.getCheckBox(INCLUDEGEOMETRY).isSelected();
        this.regularExpressions = dialog.getCheckBox(REGULAREXPRESSIONS).isSelected();
    }

    private void searchInAttributes(PlugInContext context, String searchString) {
        SelectionManager selectionManager = context.getLayerViewPanel().getSelectionManager();
        LayerManager layerManager = context.getLayerManager();
        String[] searchStrings = searchString.split(" ");
        int nwords = searchStrings.length;
        Pattern[] patterns = new Pattern[nwords];
        String quote = "\\Q";
        String endQuote = "\\E";
        if (this.regularExpressions) {
            quote = "";
            endQuote = "";
        }
        for (int k = 0; k < nwords; ++k) {
            String regex = this.wholeWord ? "\\b" + quote + searchStrings[k] + endQuote + "\\b" : quote + searchStrings[k] + endQuote;
            patterns[k] = Pattern.compile(regex, this.patternCaseOption);
        }
        ArrayList<Layer> layerList = new ArrayList<Layer>(layerManager.getVisibleLayers(false));
        for (Layer layer : layerList) {
            Object f2;
            HashSet<Object> selectedFeatures = new HashSet<Object>();
            for (Object f2 : layer.getFeatureCollectionWrapper()) {
                String attribString = null;
                int n = f2.getAttributes().length;
                for (int i = 0; i < n; ++i) {
                    Object attribute = f2.getAttribute(i);
                    if (!this.includeGeometry && attribute instanceof Geometry) continue;
                    try {
                        attribString = attribute.toString();
                        boolean select = this.multiWordMatchAnd;
                        for (int k = 0; k < nwords; ++k) {
                            patterns[k].matcher(attribString).reset();
                            select = this.multiWordMatchAnd ? select && patterns[k].matcher(attribString).find() : select || patterns[k].matcher(attribString).find();
                        }
                        if (!select) continue;
                        selectedFeatures.add(f2);
                        continue;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
            if (selectedFeatures.size() > 0) {
                selectionManager.getFeatureSelection().selectItems(layer, selectedFeatures);
            }
            Envelope env = new Envelope();
            f2 = selectedFeatures.iterator();
            while (f2.hasNext()) {
                Feature f3 = (Feature)f2.next();
                env.expandToInclude(f3.getGeometry().getEnvelopeInternal());
            }
            try {
                env.expandBy(env.getWidth() / 3.0, env.getHeight() / 3.0);
                context.getLayerViewPanel().getViewport().zoom(env);
            }
            catch (NoninvertibleTransformException e) {
                e.printStackTrace();
            }
        }
    }
}

