/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.mousemenu;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.MoveSelectedItemsTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CopySelectedItemsPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.PasteItemsPlugIn;
import javax.swing.ImageIcon;

public class DuplicateItemPlugIn
extends AbstractPlugIn {
    public static ImageIcon ICON = IconLoader.icon("ItemDuplicate16.png");

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.DuplicateItemPlugIn");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        new CopySelectedItemsPlugIn().execute(context);
        new PasteItemsPlugIn().execute(context);
        context.getLayerViewPanel().setCurrentCursorTool(new MoveSelectedItemsTool(context.getWorkbenchContext()));
        return true;
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }

    public String getNameWithMnemonic() {
        return StringUtil.replace(this.getName(), "c", "&c", false);
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNItemsMustBeSelectedCheck(1)).add(checkFactory.createExactlyOneSelectedLayerMustBeEditableCheck());
    }
}

