/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer.pirolraster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.locationtech.jts.util.Assert;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.ui.plugin.layer.pirolraster.panel.RasterColorEditorPanel;
import org.openjump.core.ui.plugin.layer.pirolraster.panel.RasterScaleStylePanel;
import org.openjump.core.ui.plugin.layer.pirolraster.panel.RasterTransparencyPanel;

public class ChangeRasterImagePropertiesPlugIn
extends AbstractPlugIn {
    private static final String LAST_TAB_KEY = ChangeRasterImagePropertiesPlugIn.class.getName() + " - LAST TAB";

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        RasterImageLayer rLayer = (RasterImageLayer)LayerTools.getSelectedLayerable(context, RasterImageLayer.class);
        String bboardKey = ChangeRasterImagePropertiesPlugIn.class.getName() + "-" + rLayer.getUUID() + " - COLORSTYLE";
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), I18N.getInstance().get("ui.style.ChangeStylesPlugIn.change-styles") + " - " + rLayer.getName() + " (Sextante)", true);
        dialog.setSideBarImage(IconLoader.icon("Symbology.gif"));
        dialog.setSize(500, 400);
        ArrayList<JPanel> stylePanels = new ArrayList<JPanel>();
        RasterColorEditorPanel rascolorpanel = context.getWorkbenchContext().getBlackboard().get(bboardKey) != null ? (RasterColorEditorPanel)context.getWorkbenchContext().getBlackboard().get(bboardKey) : new RasterColorEditorPanel(context, rLayer);
        RasterTransparencyPanel rasstyle = new RasterTransparencyPanel(rLayer);
        final RasterScaleStylePanel rasterScalepanel = new RasterScaleStylePanel(rLayer, context.getLayerViewPanel());
        if (rLayer.getNumBands() == 1) {
            stylePanels.add(rasstyle);
            stylePanels.add(rasterScalepanel);
        } else {
            stylePanels.add(rasstyle);
            stylePanels.add(rasterScalepanel);
        }
        JTabbedPane tabbedPane = new JTabbedPane();
        for (final StylePanel stylePanel : stylePanels) {
            tabbedPane.add((Component)((Object)stylePanel), stylePanel.getTitle());
            dialog.addEnableChecks(stylePanel.getTitle(), Arrays.asList(new EnableCheck(){

                @Override
                public String check(JComponent component) {
                    return stylePanel.validateInput();
                }
            }));
        }
        dialog.addRow(tabbedPane);
        tabbedPane.setSelectedComponent(this.find(stylePanels, (String)context.getWorkbenchContext().getWorkbench().getBlackboard().get(LAST_TAB_KEY, ((StylePanel)stylePanels.iterator().next()).getTitle())));
        context.getWorkbenchContext().getWorkbench().getBlackboard().put(LAST_TAB_KEY, ((StylePanel)((Object)tabbedPane.getSelectedComponent())).getTitle());
        dialog.addEnableChecks(rasterScalepanel.getTitle(), new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return rasterScalepanel.validateInput();
            }
        });
        dialog.pack();
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (dialog.wasOKPressed()) {
            if (rLayer.getNumBands() == 1) {
                rasterScalepanel.updateStyles();
                rasstyle.updateStyles();
                rascolorpanel.updateStyles();
            } else {
                rasterScalepanel.updateStyles();
                rasstyle.updateStyles();
            }
            return true;
        }
        return false;
    }

    private Component find(Collection stylePanels, String title) {
        for (StylePanel stylePanel : stylePanels) {
            if (!stylePanel.getTitle().equals(title)) continue;
            return (Component)((Object)stylePanel);
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("ui.style.ChangeStylesPlugIn.change-styles");
    }

    @Override
    public ImageIcon getIcon() {
        return GUIUtil.toSmallIcon(IconLoader.icon("Palette.png"));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        MultiEnableCheck multiEnableCheck = new MultiEnableCheck();
        multiEnableCheck.add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, RasterImageLayer.class));
        return multiEnableCheck;
    }
}

